/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjanitor.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.sun.management.HotSpotDiagnosticMXBean;
import dev.ftb.mods.ftbjanitor.FTBJanitor;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.mutable.MutableInt;

public class DumpCommands {
    public static boolean dumpItemCapabilityAttachStacks = false;

    public static void printStack(String name, String skipUntil, String skipAfter) {
        FTBJanitor.LOGGER.info(name);
        boolean found = skipUntil.isEmpty();
        for (StackTraceElement element : new Exception("Dummy Exception").getStackTrace()) {
            String s = element.toString();
            if (!found) {
                if (!s.startsWith(skipUntil)) continue;
                found = true;
                continue;
            }
            if (!skipAfter.isEmpty() && s.startsWith(skipAfter)) {
                return;
            }
            FTBJanitor.LOGGER.info("> " + s);
        }
    }

    public static void register(LiteralArgumentBuilder<CommandSource> dump) {
        dump.then(Commands.func_197057_a((String)"heap").executes(context -> DumpCommands.heapdump((CommandSource)context.getSource())));
        dump.then(Commands.func_197057_a((String)"modlist").executes(context -> DumpCommands.dumpModlist((CommandSource)context.getSource())));
        dump.then(Commands.func_197057_a((String)"registry_keys").executes(context -> DumpCommands.dumpRegistryKeys((CommandSource)context.getSource())));
        dump.then(Commands.func_197057_a((String)"block_states").executes(context -> DumpCommands.dumpBlockStates((CommandSource)context.getSource())));
        dump.then(Commands.func_197057_a((String)"bad_synced_configs").executes(context -> DumpCommands.dumpSyncedConfigs((CommandSource)context.getSource(), false)));
        dump.then(Commands.func_197057_a((String)"all_synced_configs").executes(context -> DumpCommands.dumpSyncedConfigs((CommandSource)context.getSource(), true)));
        dump.then(Commands.func_197057_a((String)"item_capability_attach_stacks").executes(context -> DumpCommands.dumpItemCapabilityAttachStacks((CommandSource)context.getSource())));
    }

    private static <T> T cast(Object o) {
        return (T)o;
    }

    private static int heapdump(CommandSource source) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
            String filename = "ftbjanitor-heapdump-" + System.currentTimeMillis() + ".hprof";
            mxBean.dumpHeap(filename, true);
            source.func_197030_a((ITextComponent)new StringTextComponent("Heap dump saved: " + filename), true);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return 0;
        }
        return 1;
    }

    private static int dumpSyncedConfigs(CommandSource source, boolean all) {
        if (!all) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Bad Config keys (size > 128):"), false);
        }
        ConfigTracker.INSTANCE.syncConfigs(false).forEach(stringS2CConfigDataPair -> {
            if (all || ((String)stringS2CConfigDataPair.getKey()).length() > 128) {
                source.func_197030_a((ITextComponent)new StringTextComponent((String)stringS2CConfigDataPair.getKey()).func_240699_a_(((String)stringS2CConfigDataPair.getKey()).length() > 128 ? TextFormatting.RED : TextFormatting.WHITE), false);
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Done"), false);
        return 1;
    }

    private static int dumpModlist(CommandSource source) {
        source.func_197030_a((ITextComponent)new StringTextComponent("Mods:\n" + ModList.get().getMods().stream().map(ModInfo::getModId).sorted().collect(Collectors.joining("\n"))), true);
        return 1;
    }

    private static int dumpRegistryKeys(CommandSource source) {
        source.func_197030_a((ITextComponent)new StringTextComponent("All registry keys:"), false);
        ArrayList lines = new ArrayList(RegistryKey.field_240898_a_.keySet());
        lines.sort(null);
        long mem = 0L;
        for (String s : lines) {
            mem += 8L * (((long)s.length() * 2L + 45L) / 8L);
        }
        double memd = (double)(mem *= 2L) / 1024.0 / 1024.0;
        lines.add("");
        lines.add("Estimated memory usage: " + (double)((long)(memd * 100.0)) / 100.0 + " MB");
        try {
            String filename = "registry-key-dump-" + Instant.now().toString().replaceAll("[:T]", "-") + ".txt";
            Files.write(source.func_197028_i().func_240776_a_(FolderName.field_237253_i_).resolve(filename), lines, new OpenOption[0]);
            source.func_197030_a((ITextComponent)new StringTextComponent("Registry key dump saved as " + filename + " (" + lines.size() + " lines, " + (double)((long)(memd * 100.0)) / 100.0 + " MB estimated memory use)"), true);
            return 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    private static int dumpBlockStates(CommandSource source) {
        ArrayList<String> lines = new ArrayList<String>();
        long total = 0L;
        HashMap<String, MutableInt> statesPerMod = new HashMap<String, MutableInt>();
        for (Block block : ForgeRegistries.BLOCKS) {
            ResourceLocation key = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
            if (key == null) {
                FTBJanitor.LOGGER.warn("Null key for block " + block.getClass().getName());
                continue;
            }
            int t = block.func_176194_O().func_177619_a().size();
            total += (long)t;
            lines.add("- " + key + "[" + t + "] - " + block.getClass().getName());
            statesPerMod.computeIfAbsent(key.func_110624_b(), k -> new MutableInt(0)).add(t);
            if (t > 1) {
                int i = 1;
                for (BlockState state : block.func_176194_O().func_177619_a()) {
                    StringBuilder sb = new StringBuilder();
                    if (i < 10 && t >= 10) {
                        sb.append('0');
                    }
                    if (i < 100 && t >= 100) {
                        sb.append('0');
                    }
                    if (i < 1000 && t >= 1000) {
                        sb.append('0');
                    }
                    if (i < 10000 && t >= 10000) {
                        sb.append('0');
                    }
                    if (i < 100000 && t >= 100000) {
                        sb.append('0');
                    }
                    if (i < 1000000 && t >= 1000000) {
                        sb.append('0');
                    }
                    sb.append(i);
                    sb.append(' ');
                    sb.append(key);
                    sb.append('[');
                    boolean first = true;
                    for (Map.Entry val : state.func_206871_b().entrySet()) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(',');
                        }
                        sb.append(((Property)val.getKey()).func_177701_a());
                        sb.append('=');
                        sb.append(((Property)val.getKey()).func_177702_a((Comparable)DumpCommands.cast(val.getValue())));
                    }
                    sb.append(']');
                    lines.add(sb.toString());
                    ++i;
                }
            }
            lines.add("");
        }
        lines.add(total + " block states in total");
        lines.add("");
        lines.add("States per mod:");
        double totald = total;
        statesPerMod.entrySet().stream().sorted((o1, o2) -> ((MutableInt)o2.getValue()).compareTo((MutableInt)o1.getValue())).forEach(entry -> lines.add((String)entry.getKey() + ": " + entry.getValue() + " [" + ((MutableInt)entry.getValue()).getValue().doubleValue() * 100.0 / totald + "%]"));
        try {
            String filename = "block-state-dump-" + Instant.now().toString().replaceAll("[:T]", "-") + ".txt";
            Files.write(source.func_197028_i().func_240776_a_(FolderName.field_237253_i_).resolve(filename), lines, new OpenOption[0]);
            source.func_197030_a((ITextComponent)new StringTextComponent("Block state dump saved as " + filename + " (" + total + " block states in total)"), true);
            return 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    private static int dumpItemCapabilityAttachStacks(CommandSource source) {
        FTBJanitor.LOGGER.info("=============== Item AttachCapabilitiesEvent<ItemStack> Dump Start ===============");
        dumpItemCapabilityAttachStacks = true;
        new ItemStack((IItemProvider)Items.field_151034_e);
        dumpItemCapabilityAttachStacks = false;
        FTBJanitor.LOGGER.info("=============== Item AttachCapabilitiesEvent<ItemStack> Dump End =================");
        source.func_197030_a((ITextComponent)new StringTextComponent("Done! Check latest.log! You may see same thing multiple times"), false);
        return 1;
    }
}

