/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.worldgen;

import java.util.function.Predicate;
import mcjty.lib.varia.DimensionId;
import mcjty.rftoolsbase.modules.worldgen.WorldGenModule;
import mcjty.rftoolsbase.modules.worldgen.config.WorldGenConfig;
import mcjty.rftoolsbase.setup.Registration;
import mcjty.rftoolsbase.worldgen.CountPlacementConfig;
import mcjty.rftoolsbase.worldgen.DimensionCompositeFeature;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class OreGenerator {
    private static final Predicate<BlockState> IS_NETHERACK = state -> state.func_177230_c() == Blocks.field_150424_aL;
    private static final Predicate<BlockState> IS_ENDSTONE = state -> state.func_177230_c() == Blocks.field_150377_bs;
    public static ConfiguredFeature OVERWORLD_SHARDS;
    public static ConfiguredFeature NETHER_SHARDS;
    public static ConfiguredFeature END_SHARDS;
    public static final RuleTest ENDSTONE_TEST;

    public static void registerConfiguredFeatures() {
        Registry registry = WorldGenRegistries.field_243653_e;
        ConfiguredFeature overworldFeature = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)WorldGenModule.DIMENSIONAL_SHARD_OVERWORLD.get()).func_176223_P(), ((Integer)WorldGenConfig.OVERWORLD_ORE_VEINSIZE.get()).intValue()));
        OVERWORLD_SHARDS = new DimensionCompositeFeature(overworldFeature, DimensionId.overworld()).func_227228_a_(((Placement)Registration.COUNT_PLACEMENT.get()).func_227446_a_((IPlacementConfig)new CountPlacementConfig((Integer)WorldGenConfig.OVERWORLD_ORE_MINY.get(), 0, (Integer)WorldGenConfig.OVERWORLD_ORE_MAXY.get() - (Integer)WorldGenConfig.OVERWORLD_ORE_MINY.get(), (Integer)WorldGenConfig.OVERWORLD_ORE_CHANCES.get())));
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("rftoolsbase", "dimshard_overworld"), (Object)OVERWORLD_SHARDS);
        ConfiguredFeature netherFeature = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241884_c, ((Block)WorldGenModule.DIMENSIONAL_SHARD_NETHER.get()).func_176223_P(), ((Integer)WorldGenConfig.NETHER_ORE_VEINSIZE.get()).intValue()));
        NETHER_SHARDS = new DimensionCompositeFeature(netherFeature, DimensionId.nether()).func_227228_a_(((Placement)Registration.COUNT_PLACEMENT.get()).func_227446_a_((IPlacementConfig)new CountPlacementConfig((Integer)WorldGenConfig.NETHER_ORE_MINY.get(), 0, (Integer)WorldGenConfig.NETHER_ORE_MAXY.get() - (Integer)WorldGenConfig.NETHER_ORE_MINY.get(), (Integer)WorldGenConfig.NETHER_ORE_CHANCES.get())));
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("rftoolsbase", "dimshard_nether"), (Object)NETHER_SHARDS);
        ConfiguredFeature endFeature = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(ENDSTONE_TEST, ((Block)WorldGenModule.DIMENSIONAL_SHARD_END.get()).func_176223_P(), ((Integer)WorldGenConfig.END_ORE_VEINSIZE.get()).intValue()));
        END_SHARDS = new DimensionCompositeFeature(endFeature, DimensionId.end()).func_227228_a_(((Placement)Registration.COUNT_PLACEMENT.get()).func_227446_a_((IPlacementConfig)new CountPlacementConfig((Integer)WorldGenConfig.END_ORE_MINY.get(), 0, (Integer)WorldGenConfig.END_ORE_MAXY.get() - (Integer)WorldGenConfig.END_ORE_MINY.get(), (Integer)WorldGenConfig.END_ORE_CHANCES.get())));
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("rftoolsbase", "dimshard_end"), (Object)END_SHARDS);
    }

    public static void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.NETHER) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, NETHER_SHARDS);
        } else if (event.getCategory() == Biome.Category.THEEND) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, END_SHARDS);
        } else {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, OVERWORLD_SHARDS);
        }
    }

    static {
        ENDSTONE_TEST = new TagMatchRuleTest((ITag)Tags.Blocks.END_STONES);
    }
}

