/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.crafting.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardContainer;
import mcjty.rftoolsbase.tools.ManualHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.network.NetworkHooks;

public class CraftingCardItem
extends Item
implements ITooltipSettings {
    public static final ManualEntry MANUAL = ManualHelper.create("rftoolsbase:tools/craftingcard");
    private static final CraftingInventory CRAFTING_INVENTORY = new CraftingInventory(new Container(null, -1){

        public boolean func_75145_c(PlayerEntity playerIn) {
            return false;
        }
    }, 3, 3);
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"info", stack -> {
        ItemStack result = CraftingCardItem.getResult(stack);
        if (!result.func_190926_b()) {
            if (result.func_190916_E() > 1) {
                return result.func_200301_q().getString() + "(" + result.func_190916_E() + ")";
            }
            return result.func_200301_q().getString();
        }
        return "<empty>";
    })});

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    public CraftingCardItem() {
        super(new Item.Properties().func_200916_a(RFToolsBase.setup.getTab()).func_200915_b(0).func_200917_a(1));
    }

    @Nullable
    private static IRecipe findRecipeInternal(World world, CraftingInventory inv, IRecipeType type) {
        for (IRecipe r : world.func_199532_z().func_199510_b()) {
            if (r == null || !type.equals(r.func_222127_g()) || !r.func_77569_a((IInventory)inv, world)) continue;
            return r;
        }
        return null;
    }

    @Nullable
    public static IRecipe findRecipe(World world, ItemStack craftingCard, IRecipeType type) {
        ItemStackList stacks = CraftingCardItem.getStacksFromItem(craftingCard);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int idx = y * 3 + x;
                int idxCard = y * 5 + x;
                CRAFTING_INVENTORY.func_70299_a(idx, (ItemStack)stacks.get(idxCard));
            }
        }
        return CraftingCardItem.findRecipeInternal(world, CRAFTING_INVENTORY, type);
    }

    public static void testRecipe(World world, ItemStack craftingCard) {
        ItemStackList stacks = CraftingCardItem.getStacksFromItem(craftingCard);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int idx = y * 3 + x;
                int idxCard = y * 5 + x;
                CRAFTING_INVENTORY.func_70299_a(idx, (ItemStack)stacks.get(idxCard));
            }
        }
        IRecipe recipe = CraftingCardItem.findRecipeInternal(world, CRAFTING_INVENTORY, IRecipeType.field_222149_a);
        if (recipe != null) {
            ItemStack stack = recipe.func_77572_b((IInventory)CRAFTING_INVENTORY);
            stacks.set(20, (Object)stack);
        } else {
            stacks.set(20, (Object)ItemStack.field_190927_a);
        }
        CraftingCardItem.putStacksInItem(craftingCard, stacks);
    }

    public static ItemStackList getStacksFromItem(ItemStack craftingCard) {
        CompoundNBT tagCompound = craftingCard.func_196082_o();
        ItemStackList stacks = ItemStackList.create((int)21);
        ListNBT bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.size(); ++i) {
            CompoundNBT nbtTagCompound = bufferTagList.func_150305_b(i);
            stacks.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)nbtTagCompound));
        }
        return stacks;
    }

    public static void putStacksInItem(ItemStack craftingCard, ItemStackList stacks) {
        CompoundNBT tagCompound = craftingCard.func_196082_o();
        ListNBT bufferTagList = new ListNBT();
        for (ItemStack stack : stacks) {
            CompoundNBT nbtTagCompound = new CompoundNBT();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.add((Object)nbtTagCompound);
        }
        tagCompound.func_218657_a("Items", (INBT)bufferTagList);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, list, flagIn);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(this.getRegistryName(), stack, list, flagIn);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != Hand.MAIN_HAND) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new StringTextComponent("Crafting Card");
                }

                public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
                    CraftingCardContainer container = new CraftingCardContainer(id, player.func_233580_cy_(), player);
                    container.setupInventories(null, playerInventory);
                    return container;
                }
            });
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public static ItemStack getResult(ItemStack card) {
        CompoundNBT tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return ItemStack.field_190927_a;
        }
        ListNBT bufferTagList = tagCompound.func_150295_c("Items", 10);
        CompoundNBT nbtTagCompound = bufferTagList.func_150305_b(20);
        return ItemStack.func_199557_a((CompoundNBT)nbtTagCompound);
    }

    private static boolean isInGrid(int index) {
        int x = index % 5;
        int y = index / 5;
        return x <= 2 && y <= 2;
    }

    public static boolean fitsGrid(ItemStack card) {
        CompoundNBT tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        ListNBT bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.size(); ++i) {
            CompoundNBT nbtTagCompound;
            ItemStack s;
            if (i >= 20 || (s = ItemStack.func_199557_a((CompoundNBT)(nbtTagCompound = bufferTagList.func_150305_b(i)))).func_190926_b() || CraftingCardItem.isInGrid(i)) continue;
            return false;
        }
        return true;
    }

    public static List<Ingredient> getIngredientsGrid(ItemStack card) {
        CompoundNBT tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return Collections.emptyList();
        }
        ListNBT bufferTagList = tagCompound.func_150295_c("Items", 10);
        ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
        for (int i = 0; i < bufferTagList.size(); ++i) {
            if (i >= 20) continue;
            CompoundNBT nbtTagCompound = bufferTagList.func_150305_b(i);
            ItemStack s = ItemStack.func_199557_a((CompoundNBT)nbtTagCompound);
            if (!CraftingCardItem.isInGrid(i)) continue;
            stacks.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{s}));
        }
        return stacks;
    }

    public static List<ItemStack> getIngredientStacks(ItemStack card) {
        CompoundNBT tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return Collections.emptyList();
        }
        ListNBT bufferTagList = tagCompound.func_150295_c("Items", 10);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < bufferTagList.size(); ++i) {
            CompoundNBT nbtTagCompound;
            ItemStack s;
            if (i >= 20 || (s = ItemStack.func_199557_a((CompoundNBT)(nbtTagCompound = bufferTagList.func_150305_b(i)))).func_190926_b()) continue;
            stacks.add(s);
        }
        return stacks;
    }

    public static List<Ingredient> getIngredients(ItemStack card) {
        CompoundNBT tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return Collections.emptyList();
        }
        ListNBT bufferTagList = tagCompound.func_150295_c("Items", 10);
        ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
        for (int i = 0; i < bufferTagList.size(); ++i) {
            CompoundNBT nbtTagCompound;
            ItemStack s;
            if (i >= 20 || (s = ItemStack.func_199557_a((CompoundNBT)(nbtTagCompound = bufferTagList.func_150305_b(i)))).func_190926_b()) continue;
            stacks.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{s}));
        }
        return stacks;
    }
}

