/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.wrapper;

import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.mod.util.color.NoColor;
import dev.latvian.mods.rhino.mod.util.color.SimpleColor;
import dev.latvian.mods.rhino.mod.util.color.SimpleColorWithAlpha;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Util;
import net.minecraft.util.text.TextFormatting;

public interface ColorWrapper {
    public static final Map<String, Color> MAP = new HashMap<String, Color>();
    public static final Color NONE = ColorWrapper.createMapped(new NoColor(), "NONE", "none", "", "-", "transparent");
    public static final Color BLACK = ColorWrapper.createMapped(TextFormatting.BLACK, "BLACK", "black");
    public static final Color DARK_BLUE = ColorWrapper.createMapped(TextFormatting.DARK_BLUE, "DARK_BLUE", "dark_blue", "darkBlue");
    public static final Color DARK_GREEN = ColorWrapper.createMapped(TextFormatting.DARK_GREEN, "DARK_GREEN", "dark_green", "darkGreen");
    public static final Color DARK_AQUA = ColorWrapper.createMapped(TextFormatting.DARK_AQUA, "DARK_AQUA", "dark_aqua", "darkAqua");
    public static final Color DARK_RED = ColorWrapper.createMapped(TextFormatting.DARK_RED, "DARK_RED", "dark_red", "darkRed");
    public static final Color DARK_PURPLE = ColorWrapper.createMapped(TextFormatting.DARK_PURPLE, "DARK_PURPLE", "dark_purple", "darkPurple");
    public static final Color GOLD = ColorWrapper.createMapped(TextFormatting.GOLD, "GOLD", "gold");
    public static final Color GRAY = ColorWrapper.createMapped(TextFormatting.GRAY, "GRAY", "gray");
    public static final Color DARK_GRAY = ColorWrapper.createMapped(TextFormatting.DARK_GRAY, "DARK_GRAY", "dark_gray", "darkGray");
    public static final Color BLUE = ColorWrapper.createMapped(TextFormatting.BLUE, "BLUE", "blue");
    public static final Color GREEN = ColorWrapper.createMapped(TextFormatting.GREEN, "GREEN", "green");
    public static final Color AQUA = ColorWrapper.createMapped(TextFormatting.AQUA, "AQUA", "aqua");
    public static final Color RED = ColorWrapper.createMapped(TextFormatting.RED, "RED", "red");
    public static final Color LIGHT_PURPLE = ColorWrapper.createMapped(TextFormatting.LIGHT_PURPLE, "LIGHT_PURPLE", "light_purple", "lightPurple");
    public static final Color YELLOW = ColorWrapper.createMapped(TextFormatting.YELLOW, "YELLOW", "yellow");
    public static final Color WHITE = ColorWrapper.createMapped(TextFormatting.WHITE, "WHITE", "white");
    public static final Map<String, TextFormatting> TEXT = (Map)Util.func_200696_a(new HashMap(), map -> {
        for (TextFormatting c : TextFormatting.values()) {
            map.put(c.func_96297_d(), c);
        }
    });
    public static final Color WHITE_DYE = ColorWrapper.createMapped(DyeColor.WHITE, "WHITE_DYE", "white_dye", "whiteDye");
    public static final Color ORANGE_DYE = ColorWrapper.createMapped(DyeColor.ORANGE, "ORANGE_DYE", "orange_dye", "orangeDye");
    public static final Color MAGENTA_DYE = ColorWrapper.createMapped(DyeColor.MAGENTA, "MAGENTA_DYE", "magenta_dye", "magentaDye");
    public static final Color LIGHT_BLUE_DYE = ColorWrapper.createMapped(DyeColor.LIGHT_BLUE, "LIGHT_BLUE_DYE", "light_blue_dye", "lightBlueDye");
    public static final Color YELLOW_DYE = ColorWrapper.createMapped(DyeColor.YELLOW, "YELLOW_DYE", "yellow_dye", "yellowDye");
    public static final Color LIME_DYE = ColorWrapper.createMapped(DyeColor.LIME, "LIME_DYE", "lime_dye", "limeDye");
    public static final Color PINK_DYE = ColorWrapper.createMapped(DyeColor.PINK, "PINK_DYE", "pink_dye", "pinkDye");
    public static final Color GRAY_DYE = ColorWrapper.createMapped(DyeColor.GRAY, "GRAY_DYE", "gray_dye", "grayDye");
    public static final Color LIGHT_GRAY_DYE = ColorWrapper.createMapped(DyeColor.LIGHT_GRAY, "LIGHT_GRAY_DYE", "lightGrayDye", "lightGrayDye");
    public static final Color CYAN_DYE = ColorWrapper.createMapped(DyeColor.CYAN, "CYAN_DYE", "cyan_dye", "cyanDye");
    public static final Color PURPLE_DYE = ColorWrapper.createMapped(DyeColor.PURPLE, "PURPLE_DYE", "purple_dye", "purpleDye");
    public static final Color BLUE_DYE = ColorWrapper.createMapped(DyeColor.BLUE, "BLUE_DYE", "blue_dye", "blueDye");
    public static final Color BROWN_DYE = ColorWrapper.createMapped(DyeColor.BROWN, "BROWN_DYE", "brown_dye", "brownDye");
    public static final Color GREEN_DYE = ColorWrapper.createMapped(DyeColor.GREEN, "GREEN_DYE", "green_dye", "greenDye");
    public static final Color RED_DYE = ColorWrapper.createMapped(DyeColor.RED, "RED_DYE", "red_dye", "redDye");
    public static final Color BLACK_DYE = ColorWrapper.createMapped(DyeColor.BLACK, "BLACK_DYE", "black_dye", "blackDye");
    public static final Map<String, DyeColor> DYE = (Map)Util.func_200696_a(new HashMap(), map -> {
        for (DyeColor c : DyeColor.values()) {
            map.put(c.func_176762_d(), c);
        }
    });

    public static Color of(Object o) {
        if (o instanceof Color) {
            return (Color)o;
        }
        if (o instanceof String) {
            String s = o.toString();
            Color c = MAP.get(s);
            if (c != null) {
                return c;
            }
            if (s.startsWith("#")) {
                int col = Long.decode(s).intValue();
                return s.length() == 7 ? new SimpleColor(col) : new SimpleColorWithAlpha(col);
            }
            return NONE;
        }
        if (o instanceof Number) {
            int i = ((Number)o).intValue();
            if (i == 0) {
                return NONE;
            }
            return new SimpleColor(i);
        }
        return NONE;
    }

    public static Color createMapped(Object o, String ... names) {
        Color c = ColorWrapper.of(o);
        for (String s : names) {
            MAP.put(s, c);
        }
        return c;
    }

    public static Color rgba(int r, int g, int b, int a) {
        return new SimpleColor(r << 16 | g << 8 | b | a << 24);
    }
}

