/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.type;

import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantment;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.event.DynamicEnchantmentEvent;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class AttributeTypeEnchantmentEffectiveness
extends PerkAttributeType {
    public AttributeTypeEnchantmentEffectiveness() {
        super(PerkAttributeTypesAS.KEY_ATTR_TYPE_INC_ENCH_EFFECT, true);
    }

    @Override
    protected void attachListeners(IEventBus eventBus) {
        super.attachListeners(eventBus);
        eventBus.addListener(this::onModify);
    }

    private void onModify(DynamicEnchantmentEvent.Modify event) {
        LogicalSide side;
        PlayerEntity player = event.getResolvedPlayer();
        if (!this.hasTypeApplied(player, side = this.getSide((Entity)player))) {
            return;
        }
        float inc = PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, ResearchHelper.getProgress(player, side), this);
        for (DynamicEnchantment ench : event.getEnchantmentsToApply()) {
            float lvl = ench.getLevelAddition();
            float post = AttributeEvent.postProcessModded(player, (PerkAttributeType)this, lvl *= inc);
            ench.setLevelAddition(Math.round(post));
        }
    }
}

