/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.sky.astral;

import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

class AstralSkyRendererSetup {
    private static final Random RAND = new Random();

    AstralSkyRendererSetup() {
    }

    static void generateSky(BufferBuilder skyBuffer) {
        AstralSkyRendererSetup.prepareSky(skyBuffer, 16.0f, false);
    }

    static void generateSkyHorizon(BufferBuilder skyBuffer) {
        AstralSkyRendererSetup.prepareSky(skyBuffer, -16.0f, true);
    }

    private static void prepareSky(BufferBuilder buf, float offsetY, boolean flip) {
        int scale = 64;
        int segments = 6;
        int width = segments * scale;
        buf.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int x = -width; x <= width; x += scale) {
            for (int z = -width; z <= width; z += scale) {
                float x0 = x;
                float x1 = x + scale;
                if (flip) {
                    x1 = x;
                    x0 = x + scale;
                }
                buf.func_225582_a_((double)x0, (double)offsetY, (double)z).func_181675_d();
                buf.func_225582_a_((double)x1, (double)offsetY, (double)z).func_181675_d();
                buf.func_225582_a_((double)x1, (double)offsetY, (double)(z + scale)).func_181675_d();
                buf.func_225582_a_((double)x0, (double)offsetY, (double)(z + scale)).func_181675_d();
            }
        }
    }

    static void generateStars(BufferBuilder starBuffer, int amount, float sizeMultiplier) {
        starBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < amount; ++i) {
            double x = -1.0f + RAND.nextFloat() * 2.0f;
            double y = -1.0f + RAND.nextFloat() * 2.0f;
            double z = -1.0f + RAND.nextFloat() * 2.0f;
            double ovrSize = 0.15f + RAND.nextFloat() * 0.2f;
            double d4 = x * x + y * y + z * z;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (x *= d4) * 100.0;
            double d6 = (y *= d4) * 100.0;
            double d7 = (z *= d4) * 100.0;
            double d8 = Math.atan2(x, z);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(x * x + z * z), y);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = RAND.nextDouble() * Math.PI * 2.0;
            double size = Math.sin(d14) * 2.0;
            double d16 = Math.cos(d14);
            size *= (double)sizeMultiplier;
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * ovrSize;
                double d19 = (double)((j + 1 & 2) - 1) * ovrSize;
                double d21 = d18 * d16 - d19 * size;
                double d22 = d19 * d16 + d18 * size;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                starBuffer.func_225582_a_(d5 + d25, d6 + d23, d7 + d26).func_225583_a_((float)((j + 1 & 2) >> 1), (float)((j + 2 & 2) >> 1)).func_181675_d();
            }
        }
    }
}

