/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.resource;

import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.resource.BindableResource;
import hellfirepvp.astralsorcery.client.resource.ReloadableResource;
import hellfirepvp.astralsorcery.common.util.NameUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class GeneratedResource
extends BindableResource
implements ReloadableResource {
    private final Supplier<BufferedImage> imageGen;
    private final boolean blur;
    private final boolean clamp;

    GeneratedResource(ResourceLocation key, Supplier<BufferedImage> imageGenerator, boolean blur, boolean clamp) {
        super(NameUtil.prefixPath(key, "dynamic_"));
        this.imageGen = imageGenerator;
        this.blur = blur;
        this.clamp = clamp;
    }

    @Override
    protected Texture allocateGlId() {
        if (AssetLibrary.isReloading()) {
            return null;
        }
        TextureManager mgr = Minecraft.func_71410_x().func_110434_K();
        Texture resource = mgr.func_229267_b_(this.getKey());
        if (resource != null) {
            return resource;
        }
        InMemoryTexture texture = new InMemoryTexture(this.imageGen, this.blur, this.clamp);
        mgr.func_229263_a_(this.getKey(), (Texture)texture);
        return mgr.func_229267_b_(this.getKey());
    }

    private static class InMemoryTexture
    extends Texture {
        private final Supplier<BufferedImage> imageGen;
        private final boolean blur;
        private final boolean clamp;

        private InMemoryTexture(Supplier<BufferedImage> imageGen, boolean blur, boolean clamp) {
            this.imageGen = imageGen;
            this.blur = blur;
            this.clamp = clamp;
        }

        public void func_195413_a(IResourceManager manager) throws IOException {
            NativeImage image = NativeImage.func_211679_a((NativeImage.PixelFormat)NativeImage.PixelFormat.RGBA, (InputStream)this.createMemInput());
            if (!RenderSystem.isOnRenderThreadOrInit()) {
                RenderSystem.recordRenderCall(() -> this.loadImage(image, this.blur, this.clamp));
            } else {
                this.loadImage(image, this.blur, this.clamp);
            }
        }

        private void loadImage(NativeImage imageIn, boolean blurIn, boolean clampIn) {
            TextureUtil.func_225681_a_((int)this.func_110552_b(), (int)0, (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
            imageIn.func_227789_a_(0, 0, 0, 0, 0, imageIn.func_195702_a(), imageIn.func_195714_b(), blurIn, clampIn, false, true);
        }

        private InputStream createMemInput() throws IOException {
            BufferedImage bufferedImage = this.imageGen.get();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
            baos.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }
    }
}

