/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.ShadowRenderHelper;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.entity.Entity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;

public class BeltRenderer
extends SafeTileEntityRenderer<BeltTileEntity> {
    public BeltRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public boolean shouldRenderOffScreen(BeltTileEntity te) {
        return te.isController();
    }

    @Override
    protected void renderSafe(BeltTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (!Backend.getInstance().canUseInstancing(te.func_145831_w())) {
            BlockState blockState = te.func_195044_w();
            if (!AllBlocks.BELT.has(blockState)) {
                return;
            }
            BeltSlope beltSlope = (BeltSlope)((Object)blockState.func_177229_b(BeltBlock.SLOPE));
            BeltPart part = (BeltPart)((Object)blockState.func_177229_b(BeltBlock.PART));
            Direction facing = (Direction)blockState.func_177229_b(BeltBlock.HORIZONTAL_FACING);
            Direction.AxisDirection axisDirection = facing.func_176743_c();
            boolean downward = beltSlope == BeltSlope.DOWNWARD;
            boolean upward = beltSlope == BeltSlope.UPWARD;
            boolean diagonal = downward || upward;
            boolean start = part == BeltPart.START;
            boolean end = part == BeltPart.END;
            boolean sideways = beltSlope == BeltSlope.SIDEWAYS;
            boolean alongX = facing.func_176740_k() == Direction.Axis.X;
            MatrixStack localTransforms = new MatrixStack();
            MatrixTransformStack msr = MatrixTransformStack.of((MatrixStack)localTransforms);
            IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
            float renderTick = AnimationTickHolder.getRenderTime((IWorld)te.func_145831_w());
            msr.centre();
            msr.rotateY((double)(AngleHelper.horizontalAngle(facing) + (float)(upward ? 180 : 0) + (float)(sideways ? 270 : 0)));
            msr.rotateZ(sideways ? 90.0 : 0.0);
            msr.rotateX(!diagonal && beltSlope != BeltSlope.HORIZONTAL ? 90.0 : 0.0);
            msr.unCentre();
            if (downward || beltSlope == BeltSlope.VERTICAL && axisDirection == Direction.AxisDirection.POSITIVE) {
                boolean b = start;
                start = end;
                end = b;
            }
            DyeColor color = te.color.orElse(null);
            for (boolean bottom : Iterate.trueAndFalse) {
                PartialModel beltPartial = BeltRenderer.getBeltPartial(diagonal, start, end, bottom);
                SuperByteBuffer beltBuffer = PartialBufferer.get(beltPartial, blockState).light(light);
                SpriteShiftEntry spriteShift = BeltRenderer.getSpriteShiftEntry(color, diagonal, bottom);
                float speed = te.getSpeed();
                if (speed != 0.0f || te.color.isPresent()) {
                    float time = renderTick * (float)axisDirection.func_179524_a();
                    if (diagonal && downward ^ alongX || !sideways && !diagonal && alongX || sideways && axisDirection == Direction.AxisDirection.NEGATIVE) {
                        speed = -speed;
                    }
                    float scrollMult = diagonal ? 0.375f : 0.5f;
                    float spriteSize = spriteShift.getTarget().func_94210_h() - spriteShift.getTarget().func_94206_g();
                    double scroll = (double)(speed * time) / 504.0 + (bottom ? 0.5 : 0.0);
                    scroll -= Math.floor(scroll);
                    scroll = scroll * (double)spriteSize * (double)scrollMult;
                    beltBuffer.shiftUVScrolling(spriteShift, (float)scroll);
                }
                beltBuffer.transform(localTransforms).renderInto(ms, vb);
                if (diagonal) break;
            }
            if (te.hasPulley()) {
                Direction dir = sideways ? Direction.UP : ((Direction)blockState.func_177229_b(BeltBlock.HORIZONTAL_FACING)).func_176746_e();
                Supplier<MatrixStack> matrixStackSupplier = () -> {
                    MatrixStack stack = new MatrixStack();
                    MatrixTransformStack stacker = MatrixTransformStack.of((MatrixStack)stack);
                    stacker.centre();
                    if (dir.func_176740_k() == Direction.Axis.X) {
                        stacker.rotateY(90.0);
                    }
                    if (dir.func_176740_k() == Direction.Axis.Y) {
                        stacker.rotateX(90.0);
                    }
                    stacker.rotateX(90.0);
                    stacker.unCentre();
                    return stack;
                };
                SuperByteBuffer superBuffer = CreateClient.BUFFER_CACHE.renderDirectionalPartial(AllBlockPartials.BELT_PULLEY, blockState, dir, matrixStackSupplier);
                KineticTileEntityRenderer.standardKineticRotationTransform(superBuffer, te, light).renderInto(ms, vb);
            }
        }
        this.renderItems(te, partialTicks, ms, buffer, light, overlay);
    }

    public static SpriteShiftEntry getSpriteShiftEntry(DyeColor color, boolean diagonal, boolean bottom) {
        if (color != null) {
            return (diagonal ? AllSpriteShifts.DYED_DIAGONAL_BELTS : (bottom ? AllSpriteShifts.DYED_OFFSET_BELTS : AllSpriteShifts.DYED_BELTS)).get(color);
        }
        return diagonal ? AllSpriteShifts.BELT_DIAGONAL : (bottom ? AllSpriteShifts.BELT_OFFSET : AllSpriteShifts.BELT);
    }

    public static PartialModel getBeltPartial(boolean diagonal, boolean start, boolean end, boolean bottom) {
        if (diagonal) {
            if (start) {
                return AllBlockPartials.BELT_DIAGONAL_START;
            }
            if (end) {
                return AllBlockPartials.BELT_DIAGONAL_END;
            }
            return AllBlockPartials.BELT_DIAGONAL_MIDDLE;
        }
        if (bottom) {
            if (start) {
                return AllBlockPartials.BELT_START_BOTTOM;
            }
            if (end) {
                return AllBlockPartials.BELT_END_BOTTOM;
            }
            return AllBlockPartials.BELT_MIDDLE_BOTTOM;
        }
        if (start) {
            return AllBlockPartials.BELT_START;
        }
        if (end) {
            return AllBlockPartials.BELT_END;
        }
        return AllBlockPartials.BELT_MIDDLE;
    }

    protected void renderItems(BeltTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (!te.isController()) {
            return;
        }
        if (te.beltLength == 0) {
            return;
        }
        ms.func_227860_a_();
        Direction beltFacing = te.getBeltFacing();
        Vector3i directionVec = beltFacing.func_176730_m();
        Vector3d beltStartOffset = Vector3d.func_237491_b_((Vector3i)directionVec).func_186678_a(-0.5).func_72441_c(0.5, 0.9375, 0.5);
        ms.func_227861_a_(beltStartOffset.field_72450_a, beltStartOffset.field_72448_b, beltStartOffset.field_72449_c);
        BeltSlope slope = (BeltSlope)((Object)te.func_195044_w().func_177229_b(BeltBlock.SLOPE));
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
        boolean slopeAlongX = beltFacing.func_176740_k() == Direction.Axis.X;
        boolean onContraption = te.func_145831_w() instanceof WrappedWorld;
        for (TransportedItemStack transported : te.getInventory().getTransportedItems()) {
            boolean alongX;
            boolean tiltForward;
            int stackLight;
            ms.func_227860_a_();
            MatrixTransformStack.of((MatrixStack)ms).nudge(transported.angle);
            float offset = MathHelper.func_219799_g((float)partialTicks, (float)transported.prevBeltPosition, (float)transported.beltPosition);
            float sideOffset = MathHelper.func_219799_g((float)partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset);
            float verticalMovement = verticality;
            if (te.getSpeed() == 0.0f) {
                offset = transported.beltPosition;
                sideOffset = transported.sideOffset;
            }
            int n = stackLight = onContraption ? light : this.getPackedLight(te, offset);
            if ((double)offset < 0.5) {
                verticalMovement = 0.0f;
            }
            Vector3d offsetVec = Vector3d.func_237491_b_((Vector3i)directionVec).func_186678_a((double)offset).func_72441_c(0.0, (double)(verticalMovement *= Math.min(offset, (float)te.beltLength - 0.5f) - 0.5f), 0.0);
            boolean onSlope = slope != BeltSlope.HORIZONTAL && MathHelper.func_76131_a((float)offset, (float)0.5f, (float)((float)te.beltLength - 0.5f)) == offset;
            boolean bl = tiltForward = (slope == BeltSlope.DOWNWARD ^ beltFacing.func_176743_c() == Direction.AxisDirection.POSITIVE) == (beltFacing.func_176740_k() == Direction.Axis.Z);
            float slopeAngle = onSlope ? (tiltForward ? -45.0f : 45.0f) : 0.0f;
            ms.func_227861_a_(offsetVec.field_72450_a, offsetVec.field_72448_b, offsetVec.field_72449_c);
            boolean bl2 = alongX = beltFacing.func_176746_e().func_176740_k() == Direction.Axis.X;
            if (!alongX) {
                sideOffset *= -1.0f;
            }
            ms.func_227861_a_(alongX ? (double)sideOffset : 0.0, 0.0, alongX ? 0.0 : (double)sideOffset);
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            boolean renderUpright = BeltHelper.isItemUpright(transported.stack);
            boolean blockItem = itemRenderer.func_184393_a(transported.stack, te.func_145831_w(), null).func_177556_c();
            int count = MathHelper.func_151239_c((int)transported.stack.func_190916_E()) / 2;
            Random r = new Random(transported.angle);
            if (Minecraft.func_71410_x().field_71474_y.field_238330_f_ == GraphicsFanciness.FANCY) {
                Vector3d shadowPos = Vector3d.func_237491_b_((Vector3i)te.func_174877_v()).func_178787_e(beltStartOffset.func_186678_a(1.0).func_178787_e(offsetVec).func_72441_c(alongX ? (double)sideOffset : 0.0, 0.39, alongX ? 0.0 : (double)sideOffset));
                ShadowRenderHelper.renderShadow(ms, buffer, shadowPos, 0.75f, blockItem ? 0.2f : 0.2f);
            }
            if (renderUpright) {
                Entity renderViewEntity = Minecraft.func_71410_x().field_175622_Z;
                if (renderViewEntity != null) {
                    Vector3d positionVec = renderViewEntity.func_213303_ch();
                    Vector3d vectorForOffset = BeltHelper.getVectorForOffset(te, offset);
                    Vector3d diff = vectorForOffset.func_178788_d(positionVec);
                    float yRot = (float)MathHelper.func_181159_b((double)diff.field_72449_c, (double)(-diff.field_72450_a));
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)((double)yRot + 1.5707963267948966)));
                }
                ms.func_227861_a_(0.0, 0.09375, 0.0625);
            }
            if (!renderUpright) {
                ms.func_227863_a_(new Vector3f(slopeAlongX ? 0.0f : 1.0f, 0.0f, slopeAlongX ? 1.0f : 0.0f).func_229187_a_(slopeAngle));
            }
            if (onSlope) {
                ms.func_227861_a_(0.0, 0.125, 0.0);
            }
            for (int i = 0; i <= count; ++i) {
                ms.func_227860_a_();
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)transported.angle));
                if (!blockItem && !renderUpright) {
                    ms.func_227861_a_(0.0, -0.09375, 0.0);
                    ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                }
                if (blockItem) {
                    ms.func_227861_a_((double)(r.nextFloat() * 0.0625f * (float)i), 0.0, (double)(r.nextFloat() * 0.0625f * (float)i));
                }
                ms.func_227862_a_(0.5f, 0.5f, 0.5f);
                itemRenderer.func_229110_a_(transported.stack, ItemCameraTransforms.TransformType.FIXED, stackLight, overlay, ms, buffer);
                ms.func_227865_b_();
                if (!renderUpright) {
                    if (!blockItem) {
                        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(10.0f));
                    }
                    ms.func_227861_a_(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                    continue;
                }
                ms.func_227861_a_(0.0, 0.0, -0.0625);
            }
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    protected int getPackedLight(BeltTileEntity controller, float beltPos) {
        int segment = (int)Math.floor(beltPos) * 2;
        if (controller.light == null || segment >= controller.light.length || segment < 0) {
            return 0;
        }
        return controller.light[segment + 1] << 20 | controller.light[segment] << 4;
    }
}

