/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.jozufozu.flywheel.light.GridAlignedBB;
import com.jozufozu.flywheel.light.ILightUpdateListener;
import com.jozufozu.flywheel.light.LightUpdater;
import com.jozufozu.flywheel.light.LightVolume;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.render.RenderedContraption;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;

public abstract class ContraptionLighter<C extends Contraption>
implements ILightUpdateListener {
    protected final C contraption;
    public final LightVolume lightVolume;
    protected GridAlignedBB bounds;
    protected boolean scheduleRebuild;

    protected ContraptionLighter(C contraption) {
        this.contraption = contraption;
        this.bounds = this.getContraptionBounds();
        this.lightVolume = new LightVolume(this.contraptionBoundsToVolume(this.bounds.copy()));
        this.lightVolume.initialize((IBlockDisplayReader)((Contraption)contraption).entity.field_70170_p);
        this.scheduleRebuild = true;
        this.startListening();
    }

    public void tick(RenderedContraption owner) {
        if (this.scheduleRebuild) {
            this.lightVolume.initialize((IBlockDisplayReader)owner.contraption.entity.field_70170_p);
            this.scheduleRebuild = false;
        }
    }

    public abstract GridAlignedBB getContraptionBounds();

    public boolean onLightUpdate(IBlockDisplayReader world, LightType type, GridAlignedBB changed) {
        this.lightVolume.notifyLightUpdate(world, type, changed);
        return false;
    }

    public boolean onLightPacket(IBlockDisplayReader world, int chunkX, int chunkZ) {
        this.lightVolume.notifyLightPacket(world, chunkX, chunkZ);
        return false;
    }

    protected void startListening() {
        LightUpdater.getInstance().startListening(this.bounds, (ILightUpdateListener)this);
    }

    protected GridAlignedBB contraptionBoundsToVolume(GridAlignedBB bounds) {
        bounds.grow(2);
        bounds.minY = Math.max(bounds.minY, 0);
        bounds.maxY = Math.min(bounds.maxY, 255);
        return bounds;
    }

    public GridAlignedBB getBounds() {
        return this.bounds;
    }
}

