/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.foundation.item.ItemHandlerWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class PortableItemInterfaceTileEntity
extends PortableStorageInterfaceTileEntity {
    protected LazyOptional<IItemHandlerModifiable> capability = LazyOptional.empty();

    public PortableItemInterfaceTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void startTransferringTo(Contraption contraption, float distance) {
        LazyOptional<IItemHandlerModifiable> oldCap = this.capability;
        this.capability = LazyOptional.of(() -> new InterfaceItemHandler((IItemHandlerModifiable)contraption.inventory));
        oldCap.invalidate();
        super.startTransferringTo(contraption, distance);
    }

    @Override
    protected void stopTransferring() {
        LazyOptional<IItemHandlerModifiable> oldCap = this.capability;
        this.capability = LazyOptional.of(() -> new InterfaceItemHandler((IItemHandlerModifiable)new ItemStackHandler(0)));
        oldCap.invalidate();
        super.stopTransferring();
    }

    @Override
    protected void invalidateCapability() {
        this.capability.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    class InterfaceItemHandler
    extends ItemHandlerWrapper {
        public InterfaceItemHandler(IItemHandlerModifiable wrapped) {
            super(wrapped);
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!PortableItemInterfaceTileEntity.this.canTransfer()) {
                return ItemStack.field_190927_a;
            }
            ItemStack extractItem = super.extractItem(slot, amount, simulate);
            if (!simulate && !extractItem.func_190926_b()) {
                PortableItemInterfaceTileEntity.this.onContentTransferred();
            }
            return extractItem;
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!PortableItemInterfaceTileEntity.this.canTransfer()) {
                return stack;
            }
            ItemStack insertItem = super.insertItem(slot, stack, simulate);
            if (!simulate && !insertItem.equals(stack, false)) {
                PortableItemInterfaceTileEntity.this.onContentTransferred();
            }
            return insertItem;
        }
    }
}

