/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllContainerTypes;
import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllInteractionBehaviours;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.CreateClient;
import com.simibubi.create.api.behaviour.BlockSpoutingBehaviour;
import com.simibubi.create.content.CreateItemGroup;
import com.simibubi.create.content.contraptions.TorquePropagator;
import com.simibubi.create.content.contraptions.components.flywheel.engine.FurnaceEngineModifiers;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.curiosities.weapons.BuiltinPotatoProjectileTypes;
import com.simibubi.create.content.logistics.RedstoneLinkNetworkHandler;
import com.simibubi.create.content.palettes.AllPaletteBlocks;
import com.simibubi.create.content.palettes.PalettesItemGroup;
import com.simibubi.create.content.schematics.SchematicProcessor;
import com.simibubi.create.content.schematics.ServerSchematicLoader;
import com.simibubi.create.content.schematics.filtering.SchematicInstances;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.command.ChunkUtil;
import com.simibubi.create.foundation.command.ServerLagger;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.LangMerger;
import com.simibubi.create.foundation.data.recipe.MechanicalCraftingRecipeGen;
import com.simibubi.create.foundation.data.recipe.ProcessingRecipeGen;
import com.simibubi.create.foundation.data.recipe.SequencedAssemblyRecipeGen;
import com.simibubi.create.foundation.data.recipe.StandardRecipeGen;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.worldgen.AllWorldFeatures;
import com.simibubi.create.repack.registrate.util.NonNullLazyValue;
import java.util.Random;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="create")
public class Create {
    public static final String ID = "create";
    public static final String NAME = "Create";
    public static final String VERSION = "0.3.2f";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final ItemGroup BASE_CREATIVE_TAB = new CreateItemGroup();
    public static final ItemGroup PALETTES_CREATIVE_TAB = new PalettesItemGroup();
    public static final ServerSchematicLoader SCHEMATIC_RECEIVER = new ServerSchematicLoader();
    public static final RedstoneLinkNetworkHandler REDSTONE_LINK_NETWORK_HANDLER = new RedstoneLinkNetworkHandler();
    public static final TorquePropagator TORQUE_PROPAGATOR = new TorquePropagator();
    public static final ServerLagger LAGGER = new ServerLagger();
    public static final ChunkUtil CHUNK_UTIL = new ChunkUtil();
    public static final Random RANDOM = new Random();
    private static final NonNullLazyValue<CreateRegistrate> REGISTRATE = CreateRegistrate.lazy("create");

    public Create() {
        Create.onCtor();
    }

    public static void onCtor() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        AllSoundEvents.prepare();
        AllBlocks.register();
        AllItems.register();
        AllFluids.register();
        AllTags.register();
        AllPaletteBlocks.register();
        AllContainerTypes.register();
        AllEntityTypes.register();
        AllTileEntities.register();
        AllMovementBehaviours.register();
        AllInteractionBehaviours.register();
        AllWorldFeatures.register();
        AllEnchantments.register();
        FurnaceEngineModifiers.register();
        AllConfigs.register(modLoadingContext);
        BlockSpoutingBehaviour.register();
        ForgeMod.enableMilkFluid();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(Create::init);
        modEventBus.addGenericListener(Feature.class, AllWorldFeatures::registerOreFeatures);
        modEventBus.addGenericListener(Placement.class, AllWorldFeatures::registerDecoratorFeatures);
        modEventBus.addGenericListener(IRecipeSerializer.class, AllRecipeTypes::register);
        modEventBus.addGenericListener(ParticleType.class, AllParticleTypes::register);
        modEventBus.addGenericListener(SoundEvent.class, AllSoundEvents::register);
        modEventBus.addListener(AllConfigs::onLoad);
        modEventBus.addListener(AllConfigs::onReload);
        modEventBus.addListener(EventPriority.LOWEST, Create::gatherData);
        forgeEventBus.addListener(EventPriority.HIGH, Create::onBiomeLoad);
        forgeEventBus.register((Object)CHUNK_UTIL);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateClient.onCtorClient(modEventBus, forgeEventBus));
    }

    public static void init(FMLCommonSetupEvent event) {
        CapabilityMinecartController.register();
        AllPackets.registerPackets();
        SchematicInstances.register();
        BuiltinPotatoProjectileTypes.register();
        CHUNK_UTIL.init();
        event.enqueueWork(() -> {
            AllTriggers.register();
            SchematicProcessor.register();
            AllWorldFeatures.registerFeatures();
        });
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.func_200390_a((IDataProvider)new AllAdvancements(gen));
        gen.func_200390_a((IDataProvider)new LangMerger(gen));
        gen.func_200390_a((IDataProvider)AllSoundEvents.provider(gen));
        gen.func_200390_a((IDataProvider)new StandardRecipeGen(gen));
        gen.func_200390_a((IDataProvider)new MechanicalCraftingRecipeGen(gen));
        gen.func_200390_a((IDataProvider)new SequencedAssemblyRecipeGen(gen));
        ProcessingRecipeGen.registerAll(gen);
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        AllWorldFeatures.reload(event);
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE.func_179281_c();
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(ID, path);
    }
}

