/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.validation;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.common.spell.validation.ActionAugmentationPolicyValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.AugmentCompatibilityValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.CombinedSpellValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.GlyphOccurrencesPolicyValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.MaxOneCastMethodSpellValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.NonEmptySpellValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.StartingCastMethodSpellValidator;
import java.util.LinkedList;
import java.util.List;

public class StandardSpellValidator
implements ISpellValidator {
    private static final ISpellValidator MAX_ONE_CAST_METHOD = new MaxOneCastMethodSpellValidator();
    private static final ISpellValidator NON_EMPTY_SPELL = new NonEmptySpellValidator();
    private static final ISpellValidator REQUIRE_CAST_METHOD_START = new StartingCastMethodSpellValidator();
    private static final ISpellValidator GLYPH_OCCURRENCES_POLICY = new GlyphOccurrencesPolicyValidator();
    private static final ISpellValidator EFFECT_AUGMENTATION_POLICY = new ActionAugmentationPolicyValidator();
    private static final ISpellValidator AUGMENT_COMPATIBILITY = new AugmentCompatibilityValidator();
    private final ISpellValidator combinedValidator;

    public StandardSpellValidator(boolean enforceCastTimeValidations) {
        LinkedList<ISpellValidator> validators = new LinkedList<ISpellValidator>();
        validators.add(MAX_ONE_CAST_METHOD);
        validators.add(GLYPH_OCCURRENCES_POLICY);
        validators.add(EFFECT_AUGMENTATION_POLICY);
        if (!enforceCastTimeValidations) {
            validators.add(AUGMENT_COMPATIBILITY);
        }
        if (enforceCastTimeValidations) {
            validators.add(NON_EMPTY_SPELL);
            validators.add(REQUIRE_CAST_METHOD_START);
        }
        this.combinedValidator = new CombinedSpellValidator(validators);
    }

    @Override
    public List<SpellValidationError> validate(List<AbstractSpellPart> spellRecipe) {
        return this.combinedValidator.validate(spellRecipe);
    }
}

