/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;

public class EffectGrow
extends AbstractEffect {
    public static EffectGrow INSTANCE = new EffectGrow();

    private EffectGrow() {
        super("grow", "Grow");
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        for (BlockPos blockpos : SpellUtil.calcAOEBlocks(shooter, rayTraceResult.func_216350_a(), rayTraceResult, spellStats)) {
            ItemStack stack = new ItemStack((IItemProvider)Items.field_196106_bc, 64);
            if (!BlockUtil.destroyRespectsClaim(shooter, world, blockpos) || !(world instanceof ServerWorld)) continue;
            BoneMealItem.applyBonemeal((ItemStack)stack, (World)world, (BlockPos)blockpos, (PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)));
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        if (!(rayTraceResult instanceof BlockRayTraceResult)) {
            return false;
        }
        BlockPos pos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
        return world.func_180495_p(pos).func_177230_c() instanceof IGrowable && ((IGrowable)world.func_180495_p(pos).func_177230_c()).func_176473_a((IBlockReader)world, pos, world.func_180495_p(pos), world.field_72995_K);
    }

    @Override
    public int getManaCost() {
        return 70;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221964_gn;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE, AugmentPierce.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Causes plants to accelerate in growth as if they were bonemealed.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_EARTH);
    }
}

