/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketGetPersistentData;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.network.PacketDistributor;

public class ScryingRitual
extends AbstractRitual {
    @Override
    protected void tick() {
        ParticleUtil.spawnFallingSkyEffect(this.tile.ritual, this.tile, this.rand, this.getCenterColor().toWrapper());
        if (this.getWorld().func_82737_E() % 20L == 0L && !this.getWorld().field_72995_K) {
            this.incrementProgress();
        }
        if (!this.getWorld().field_72995_K && this.getProgress() >= 15) {
            List players = this.getWorld().func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(this.getPos()).func_186662_g(5.0));
            if (players.size() > 0) {
                ItemStack item = this.getConsumedItems().stream().filter(i -> i.func_77973_b() instanceof BlockItem).findFirst().orElse(ItemStack.field_190927_a);
                int modifier = this.didConsumeItem(ArsNouveauAPI.getInstance().getGlyphItem(AugmentExtendTime.INSTANCE)) ? 3 : 1;
                for (ServerPlayerEntity playerEntity : players) {
                    ScryingRitual.grantScrying(playerEntity, item, 6000 * modifier);
                }
            }
            this.setFinished();
        }
    }

    public static void grantScrying(ServerPlayerEntity playerEntity, ItemStack stack, int ticks) {
        playerEntity.func_195064_c(new EffectInstance((Effect)ModPotions.SCRYING_EFFECT, ticks));
        CompoundNBT tag = playerEntity.getPersistentData().func_74775_l("PlayerPersisted");
        tag.func_74778_a("an_scrying", stack.func_77973_b().getRegistryName().toString());
        playerEntity.getPersistentData().func_218657_a("PlayerPersisted", (INBT)tag);
        Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> playerEntity), (Object)new PacketGetPersistentData(tag));
    }

    @Override
    public boolean canStart() {
        return !this.getConsumedItems().isEmpty();
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        Item extendTime = ArsNouveauAPI.getInstance().getGlyphItem(AugmentExtendTime.INSTANCE);
        if (this.didConsumeItem(extendTime) && this.getConsumedItems().size() == 1 && stack.func_77973_b() instanceof BlockItem) {
            return true;
        }
        if (!this.getConsumedItems().isEmpty() && stack.func_77973_b() instanceof BlockItem) {
            return false;
        }
        if (this.didConsumeItem(stack.func_77973_b())) {
            return false;
        }
        if (this.getConsumedItems().isEmpty() && stack.func_77973_b() instanceof BlockItem) {
            return true;
        }
        return stack.func_77973_b() == extendTime;
    }

    @Override
    public ParticleColor getCenterColor() {
        return ParticleColor.makeRandomColor(50, 155, 80, this.rand);
    }

    @Override
    public String getLangName() {
        return "Scrying";
    }

    @Override
    public String getLangDescription() {
        return "Grants vision of a given block through any other block for a given time. White particles signify you are very close, green is semi-far, and blue particles are blocks very far from you.  To complete the ritual, throw any block of your choice before starting. You may also add a Glyph of Extend Time to increase the duration to 15 minutes.";
    }

    @Override
    public String getID() {
        return "scrying";
    }
}

