/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.DelayedSpellEvent;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketClientDelayEffect {
    public Spell spell;
    public int duration;
    public int shooterID;
    public ParticleColor.IntWrapper color;
    @Nullable
    public BlockRayTraceResult hitPos;
    public int hitEntityID;

    public PacketClientDelayEffect(PacketBuffer buf) {
        this.duration = buf.readInt();
        this.spell = Spell.deserialize(buf.func_218666_n());
        this.shooterID = buf.readInt();
        this.color = ParticleColor.IntWrapper.deserialize(buf.func_218666_n());
        this.hitEntityID = buf.readInt();
        if (this.hitEntityID == -1) {
            this.hitPos = buf.func_218669_q();
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.duration);
        buf.func_180714_a(this.spell.serialize());
        buf.writeInt(this.shooterID);
        buf.func_180714_a(this.color.serialize());
        buf.writeInt(this.hitEntityID);
        if (this.hitEntityID == -1) {
            buf.func_218668_a(this.hitPos);
        }
    }

    public PacketClientDelayEffect(int duration, @Nullable LivingEntity shooter, Spell spell, SpellContext context, @Nullable BlockRayTraceResult hitPos, @Nullable Entity hitEntity) {
        this.duration = duration;
        this.shooterID = shooter == null ? -1 : shooter.func_145782_y();
        this.color = context.colors;
        this.spell = spell;
        this.hitPos = hitPos;
        this.hitEntityID = hitEntity == null ? -1 : hitEntity.func_145782_y();
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World world = ArsNouveau.proxy.getClientWorld();
            Entity hitEntity = world.func_73045_a(this.hitEntityID);
            Object result = this.hitEntityID == -1 ? this.hitPos : (hitEntity == null ? BlockRayTraceResult.func_216352_a((Vector3d)new Vector3d(0.0, 0.0, 0.0), (Direction)Direction.UP, (BlockPos)BlockPos.field_177992_a) : new EntityRayTraceResult(hitEntity));
            EventQueue.getClientQueue().addEvent(new DelayedSpellEvent(this.duration, this.spell, (RayTraceResult)result, world, (LivingEntity)world.func_73045_a(this.shooterID), new SpellContext(this.spell, (LivingEntity)world.func_73045_a(this.shooterID)).withColors(this.color)));
        });
        ctx.get().setPacketHandled(true);
    }
}

