/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.MathUtil;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketReactiveSpell;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class ReactiveEvents {
    @SubscribeEvent
    public static void livingHitEvent(LivingHurtEvent e) {
        LivingEntity entity = e.getEntityLiving();
        if (entity.func_130014_f_().field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        for (ItemStack s : entity.func_184193_aE()) {
            ReactiveEvents.castSpell((PlayerEntity)entity, s);
        }
    }

    public static void castSpell(PlayerEntity playerIn, ItemStack s) {
        if ((double)EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT, (ItemStack)s) * 0.25 >= Math.random() && s.func_77942_o() && s.func_77978_p().func_74764_b("spell")) {
            List<AbstractSpellPart> list = SpellParchment.getSpellRecipe(s);
            SpellResolver resolver = new SpellResolver(list, true, new SpellContext(list, (LivingEntity)playerIn));
            RayTraceResult result = playerIn.func_213324_a(5.0, 0.0f, false);
            EntityRayTraceResult entityRes = MathUtil.getLookedAtEntity((LivingEntity)playerIn, 25);
            ItemStack stack = playerIn.func_184614_ca();
            Hand handIn = Hand.MAIN_HAND;
            if (entityRes != null && entityRes.func_216348_a() instanceof LivingEntity) {
                resolver.onCastOnEntity(stack, (LivingEntity)playerIn, (Entity)((LivingEntity)entityRes.func_216348_a()), handIn);
                return;
            }
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                ItemUseContext context = new ItemUseContext(playerIn, handIn, (BlockRayTraceResult)result);
                resolver.onCastOnBlock(context);
                return;
            }
            resolver.onCast(stack, (LivingEntity)playerIn, playerIn.func_130014_f_());
        }
    }

    @SubscribeEvent
    public static void leftClickBlock(PlayerInteractEvent.LeftClickBlock e) {
        LivingEntity entity = e.getEntityLiving();
        if (entity.func_130014_f_().field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        ItemStack s = e.getItemStack();
        ReactiveEvents.castSpell((PlayerEntity)entity, s);
    }

    @SubscribeEvent
    public static void playerAttackEntity(AttackEntityEvent e) {
        LivingEntity entity = e.getEntityLiving();
        if (entity == null || entity.func_130014_f_().field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        ItemStack s = e.getEntityLiving().func_184614_ca();
        ReactiveEvents.castSpell((PlayerEntity)entity, s);
    }

    @SubscribeEvent
    public static void leftClickAir(PlayerInteractEvent.LeftClickEmpty e) {
        LivingEntity entity = e.getEntityLiving();
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT, (ItemStack)e.getItemStack()) > 0) {
            Networking.INSTANCE.sendToServer((Object)new PacketReactiveSpell());
        }
    }
}

