/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.chimera;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityChimera;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;

public class ChimeraDiveGoal
extends Goal {
    EntityChimera boss;
    boolean finished;
    int ticksFlying;
    boolean isDiving;
    BlockPos divePos;
    BlockPos startPos;
    BlockPos hoverPos;

    public ChimeraDiveGoal(EntityChimera boss) {
        this.boss = boss;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_220685_C_() {
        return false;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.finished = false;
        this.divePos = null;
        this.ticksFlying = 0;
        this.isDiving = false;
        this.startPos = this.boss.func_233580_cy_();
        this.hoverPos = this.startPos.func_177981_b(8);
        this.boss.setFlying(true);
        this.boss.func_70661_as().func_212239_d(true);
        Networking.sendToNearby(this.boss.field_70170_p, (Entity)this.boss, (Object)new PacketAnimEntity(this.boss.func_145782_y(), EntityChimera.Animations.FLYING.ordinal()));
    }

    public void func_75246_d() {
        super.func_75246_d();
        ++this.ticksFlying;
        if (this.ticksFlying < 60) {
            this.boss.setFlying(true);
            this.boss.func_70661_as().func_212239_d(true);
            this.boss.flyingNavigator.func_75492_a((double)this.hoverPos.func_177958_n(), (double)this.hoverPos.func_177956_o(), (double)this.hoverPos.func_177952_p(), 1.0);
            this.boss.func_213317_d(this.boss.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            if (this.boss.func_70638_az() != null) {
                EntityChimera.faceBlock(this.boss.func_70638_az().func_233580_cy_(), (LivingEntity)this.boss);
            }
        }
        if (this.ticksFlying > 60) {
            this.isDiving = true;
            this.boss.diving = true;
            if (this.divePos == null) {
                if (this.boss.func_70638_az() != null) {
                    this.divePos = this.boss.func_70638_az().func_233580_cy_().func_177977_b();
                    for (int i = 1; i < 50 && this.boss.field_70170_p.func_180495_p(this.divePos).func_196958_f(); ++i) {
                        this.divePos = this.divePos.func_177977_b();
                    }
                }
                Networking.sendToNearby(this.boss.field_70170_p, (Entity)this.boss, (Object)new PacketAnimEntity(this.boss.func_145782_y(), EntityChimera.Animations.DIVE_BOMB.ordinal()));
            }
            if (this.divePos != null) {
                this.boss.flyingNavigator.func_75492_a((double)this.divePos.func_177958_n() + 0.5, (double)this.divePos.func_177956_o(), (double)this.divePos.func_177952_p(), 4.0);
                this.boss.orbitOffset = new Vector3d((double)this.divePos.func_177958_n() + 0.5, (double)this.divePos.func_177956_o(), (double)this.divePos.func_177952_p() + 0.5);
            }
        }
        if (this.isDiving && (this.boss.func_233570_aj_() || BlockUtil.distanceFrom(this.boss.field_233557_ao_, this.divePos) <= 1.0) || this.boss.orbitOffset != null && BlockUtil.distanceFrom(this.boss.field_233557_ao_, this.boss.orbitOffset) <= 1.7) {
            this.makeExplosion();
            this.endGoal();
        }
        if (this.isDiving && (this.boss.func_70094_T() || this.boss.field_70123_F || this.boss.field_70124_G)) {
            this.makeExplosion();
            this.endGoal();
        }
        if (this.isDiving && this.divePos == null && this.boss.func_70638_az() == null) {
            this.endGoal();
        }
    }

    public void endGoal() {
        this.boss.func_70661_as().func_212239_d(false);
        this.boss.func_70661_as().func_75499_g();
        this.boss.setFlying(false);
        this.boss.diveCooldown = (int)(300.0 + ParticleUtil.inRange(-100.0, 100.0) + (double)this.boss.getCooldownModifier());
        this.boss.func_70661_as().func_75499_g();
        this.boss.func_70661_as().func_212239_d(false);
        this.boss.diving = false;
        this.boss.func_189654_d(false);
        this.boss.func_213293_j(0.0, 0.0, 0.0);
        this.boss.func_70661_as().func_75497_a((Entity)(this.boss.func_70638_az() != null ? this.boss.func_70638_az() : this.boss), 0.0);
        this.finished = true;
    }

    public void makeExplosion() {
        this.boss.field_70170_p.func_217385_a((Entity)this.boss, this.boss.func_226277_ct_() + 0.5, this.boss.func_226278_cu_(), this.boss.func_226281_cx_() + 0.5, 4.5f, Explosion.Mode.BREAK);
        Networking.sendToNearby(this.boss.field_70170_p, (Entity)this.boss, (Object)new PacketAnimEntity(this.boss.func_145782_y(), EntityChimera.Animations.HOWL.ordinal()));
    }

    public boolean func_75253_b() {
        return !this.finished && !this.boss.getPhaseSwapping();
    }

    public boolean func_75250_a() {
        return this.boss.canDive() && this.boss.func_70638_az() != null;
    }
}

