/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import net.minecraft.block.BlockState;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.state.Property;
import net.minecraft.util.GroundPathHelper;
import net.minecraft.util.math.BlockPos;

public class InteractTrapdoorGoal
extends Goal {
    protected MobEntity mob;
    protected BlockPos doorPos = BlockPos.field_177992_a;
    protected boolean hasDoor;
    private boolean passed;
    private float doorOpenDirX;
    private float doorOpenDirZ;

    public InteractTrapdoorGoal(MobEntity p_i1621_1_) {
        this.mob = p_i1621_1_;
        if (!GroundPathHelper.func_242319_a((MobEntity)p_i1621_1_)) {
            throw new IllegalArgumentException("Unsupported mob type for DoorInteractGoal");
        }
    }

    protected boolean isOpen() {
        if (!this.hasDoor) {
            return false;
        }
        BlockState blockstate = this.mob.field_70170_p.func_180495_p(this.doorPos);
        if (!(blockstate.func_177230_c() instanceof TrapDoorBlock)) {
            this.hasDoor = false;
            return false;
        }
        return (Boolean)blockstate.func_177229_b((Property)TrapDoorBlock.field_176283_b);
    }

    protected void setOpen(boolean p_195921_1_) {
        BlockState blockstate;
        if (this.hasDoor && (blockstate = this.mob.field_70170_p.func_180495_p(this.doorPos)).func_177230_c() instanceof TrapDoorBlock) {
            blockstate = (BlockState)blockstate.func_235896_a_((Property)TrapDoorBlock.field_176283_b);
            this.mob.field_70170_p.func_180501_a(this.doorPos, blockstate, 2);
        }
    }

    public boolean func_75250_a() {
        if (!GroundPathHelper.func_242319_a((MobEntity)this.mob)) {
            return false;
        }
        if (!this.mob.field_70123_F) {
            return false;
        }
        GroundPathNavigator groundpathnavigator = (GroundPathNavigator)this.mob.func_70661_as();
        Path path = groundpathnavigator.func_75505_d();
        if (path != null && !path.func_75879_b() && groundpathnavigator.func_179686_g()) {
            for (int i = 0; i < Math.min(path.func_75873_e() + 2, path.func_75874_d()); ++i) {
                PathPoint pathpoint = path.func_75877_a(i);
                this.doorPos = new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c);
                if (this.mob.func_70092_e((double)this.doorPos.func_177958_n(), this.mob.func_226278_cu_(), (double)this.doorPos.func_177952_p()) > 2.25) continue;
                this.hasDoor = this.isWoodenTrapdoor();
                if (!this.hasDoor) continue;
                return true;
            }
            this.doorPos = this.mob.func_233580_cy_().func_177984_a();
            this.hasDoor = this.isWoodenTrapdoor();
            return this.hasDoor;
        }
        return false;
    }

    public boolean isWoodenTrapdoor() {
        return this.mob.field_70170_p.func_180495_p(this.doorPos).func_177230_c() instanceof TrapDoorBlock && this.mob.field_70170_p.func_180495_p(this.doorPos).func_185904_a() == Material.field_151575_d;
    }

    public boolean func_75253_b() {
        return !this.passed;
    }

    public void func_75249_e() {
        this.passed = false;
        this.doorOpenDirX = (float)((double)this.doorPos.func_177958_n() + 0.5 - this.mob.func_226277_ct_());
        this.doorOpenDirZ = (float)((double)this.doorPos.func_177952_p() + 0.5 - this.mob.func_226281_cx_());
    }

    public void func_75246_d() {
        float f1;
        float f = (float)((double)this.doorPos.func_177958_n() + 0.5 - this.mob.func_226277_ct_());
        float f2 = this.doorOpenDirX * f + this.doorOpenDirZ * (f1 = (float)((double)this.doorPos.func_177952_p() + 0.5 - this.mob.func_226281_cx_()));
        if (f2 < 0.0f) {
            this.passed = true;
        }
    }
}

