/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class EntityLingeringSpell
extends EntityProjectileSpell {
    public static final DataParameter<Integer> ACCELERATES = EntityDataManager.func_187226_a(EntityLingeringSpell.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> AOE = EntityDataManager.func_187226_a(EntityLingeringSpell.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> LANDED = EntityDataManager.func_187226_a(EntityLingeringSpell.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> SENSITIVE = EntityDataManager.func_187226_a(EntityLingeringSpell.class, (IDataSerializer)DataSerializers.field_187198_h);
    public double extendedTime;
    public int maxProcs = 100;
    public int totalProcs;

    public EntityLingeringSpell(EntityType<? extends EntityProjectileSpell> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityLingeringSpell(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityLingeringSpell(World worldIn, LivingEntity shooter) {
        super(worldIn, shooter);
    }

    public void setAccelerates(int accelerates) {
        this.field_70180_af.func_187227_b(ACCELERATES, (Object)accelerates);
    }

    @Override
    public void func_70071_h_() {
        boolean isOnGround = this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_185904_a().func_76230_c();
        if (!this.field_70170_p.field_72995_K) {
            this.setLanded(isOnGround);
            if (this.spellResolver == null) {
                this.func_70106_y();
                return;
            }
        }
        int aoe = this.getAoe();
        if (!this.field_70170_p.field_72995_K && this.age % (20 - 2 * this.getAccelerates()) == 0) {
            if (this.isSensitive()) {
                for (BlockPos p : BlockPos.func_218278_a((BlockPos)this.func_233580_cy_().func_177965_g(aoe).func_177964_d(aoe), (BlockPos)this.func_233580_cy_().func_177985_f(aoe).func_177970_e(aoe))) {
                    this.spellResolver.onResolveEffect(this.field_70170_p, this.func_234616_v_() instanceof LivingEntity ? (LivingEntity)this.func_234616_v_() : null, (RayTraceResult)new BlockRayTraceResult(new Vector3d((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p()), Direction.UP, p, false));
                }
            } else {
                int i = 0;
                for (Entity entity : this.field_70170_p.func_72839_b(null, new AxisAlignedBB(this.func_233580_cy_()).func_186662_g((double)this.getAoe()))) {
                    if (entity.equals((Object)this) || entity instanceof EntityLingeringSpell || entity instanceof LightningBoltEntity) continue;
                    this.spellResolver.onResolveEffect(this.field_70170_p, this.func_234616_v_() instanceof LivingEntity ? (LivingEntity)this.func_234616_v_() : null, (RayTraceResult)new EntityRayTraceResult(entity));
                    if (++i <= 5) continue;
                    break;
                }
                this.totalProcs += i;
                if (this.totalProcs >= this.maxProcs) {
                    this.func_70106_y();
                }
            }
        }
        if (!isOnGround) {
            this.func_213293_j(0.0, -0.2, 0.0);
            super.func_70071_h_();
        } else {
            ++this.age;
        }
        if ((double)this.age > 70.0 + this.extendedTime * 20.0) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            ParticleUtil.spawnRitualAreaEffect(this.func_226268_ag_(), this.field_70170_p, this.field_70146_Z, this.getParticleColor(), this.getAoe(), 5, 20);
            ParticleUtil.spawnLight(this.field_70170_p, this.getParticleColor(), this.field_233557_ao_.func_72441_c(0.0, 0.5, 0.0), 10);
        }
    }

    public EntityLingeringSpell(FMLPlayMessages.SpawnEntity packet, World world) {
        super((EntityType<? extends EntityProjectileSpell>)ModEntities.LINGER_SPELL, world);
    }

    @Override
    public EntityType<?> func_200600_R() {
        return ModEntities.LINGER_SPELL;
    }

    @Override
    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && result instanceof BlockRayTraceResult && !this.field_70128_L) {
            BlockState state = this.field_70170_p.func_180495_p(((BlockRayTraceResult)result).func_216350_a());
            if (state.func_185904_a() == Material.field_151567_E) {
                state.func_177230_c().func_196262_a(state, this.field_70170_p, ((BlockRayTraceResult)result).func_216350_a(), (Entity)this);
                return;
            }
            this.setLanded(true);
        }
    }

    public int getAccelerates() {
        return (Integer)this.field_70180_af.func_187225_a(ACCELERATES);
    }

    public void setAoe(int aoe) {
        this.field_70180_af.func_187227_b(AOE, (Object)aoe);
    }

    public int getAoe() {
        return (this.isSensitive() ? 1 : 3) + (Integer)this.field_70180_af.func_187225_a(AOE);
    }

    public void setLanded(boolean landed) {
        this.field_70180_af.func_187227_b(LANDED, (Object)landed);
    }

    public boolean getLanded() {
        return (Boolean)this.field_70180_af.func_187225_a(LANDED);
    }

    public void setSensitive(boolean sensitive) {
        this.field_70180_af.func_187227_b(SENSITIVE, (Object)sensitive);
    }

    public boolean isSensitive() {
        return (Boolean)this.field_70180_af.func_187225_a(SENSITIVE);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ACCELERATES, (Object)0);
        this.field_70180_af.func_187214_a(AOE, (Object)0);
        this.field_70180_af.func_187214_a(LANDED, (Object)false);
        this.field_70180_af.func_187214_a(SENSITIVE, (Object)false);
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74757_a("sensitive", this.isSensitive());
    }

    @Override
    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setSensitive(compound.func_74767_n("sensitive"));
    }
}

