/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.IFollowingSummon;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.FollowSummonerFlyingGoal;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class EntityAllyVex
extends VexEntity
implements IFollowingSummon,
ISummon {
    private LivingEntity owner;
    @Nullable
    private BlockPos boundOrigin;
    private boolean limitedLifespan;
    private int limitedLifeTicks;

    public EntityAllyVex(EntityType<? extends VexEntity> p_i50190_1_, World p_i50190_2_) {
        super(ModEntities.ALLY_VEX, p_i50190_2_);
    }

    public EntityAllyVex(World p_i50190_2_, LivingEntity owner) {
        super(EntityType.field_200755_au, p_i50190_2_);
        this.owner = owner;
        this.limitedLifespan = false;
        this.setOwnerId(owner.func_110124_au());
        this.field_70765_h = new MoveHelperController(this);
    }

    public EntityType<?> func_200600_R() {
        return ModEntities.ALLY_VEX;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_180481_a(difficultyIn);
        this.func_180483_b(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151048_u));
        this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ChargeAttackGoal());
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowSummonerFlyingGoal(this, this.owner, 1.0, 6.0f, 3.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new CopyOwnerTargetGoal((CreatureEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, false, true, entity -> entity instanceof MobEntity && ((MobEntity)entity).func_70638_az() != null && ((MobEntity)entity).func_70638_az().equals((Object)this.owner) || entity instanceof LivingEntity && entity.func_94060_bK() != null && entity.func_94060_bK().equals((Object)this.owner)));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    public World getWorld() {
        return this.field_70170_p;
    }

    @Override
    public PathNavigator getPathNav() {
        return this.field_70699_by;
    }

    @Override
    public MobEntity getSelfEntity() {
        return this;
    }

    @Override
    public LivingEntity getSummoner() {
        return this.getOwnerFromID();
    }

    public LivingEntity getActualOwner() {
        return this.owner;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    public void func_70037_a(CompoundNBT compound) {
        UUID s;
        super.func_70037_a(compound);
        if (compound.func_74764_b("BoundX")) {
            this.boundOrigin = new BlockPos(compound.func_74762_e("BoundX"), compound.func_74762_e("BoundY"), compound.func_74762_e("BoundZ"));
        }
        if (compound.func_74764_b("LifeTicks")) {
            this.func_190653_a(compound.func_74762_e("LifeTicks"));
        }
        if (compound.func_150297_b("OwnerUUID", 8)) {
            s = compound.func_186857_a("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (s != null) {
            try {
                this.setOwnerId(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public LivingEntity getOwnerFromID() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.boundOrigin != null) {
            compound.func_74768_a("BoundX", this.boundOrigin.func_177958_n());
            compound.func_74768_a("BoundY", this.boundOrigin.func_177956_o());
            compound.func_74768_a("BoundZ", this.boundOrigin.func_177952_p());
        }
        if (this.limitedLifespan) {
            compound.func_74768_a("LifeTicks", this.limitedLifeTicks);
        }
        if (this.getOwnerId() == null) {
            compound.func_186854_a("OwnerUUID", Util.field_240973_b_);
        } else {
            compound.func_186854_a("OwnerUUID", this.getOwnerId());
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.onSummonDeath(this.field_70170_p, cause, false);
    }

    @Override
    public int getTicksLeft() {
        return this.limitedLifeTicks;
    }

    @Override
    public void setTicksLeft(int ticks) {
        this.limitedLifeTicks = ticks;
    }

    @Override
    @Nullable
    public UUID getOwnerID() {
        return null;
    }

    @Override
    public void setOwnerID(UUID uuid) {
    }

    class MoveRandomGoal
    extends Goal {
        public MoveRandomGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !EntityAllyVex.this.func_70605_aq().func_75640_a() && EntityAllyVex.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = EntityAllyVex.this.func_190646_di();
            if (blockpos == null) {
                blockpos = new BlockPos((Vector3i)EntityAllyVex.this.func_233580_cy_());
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityAllyVex.this.field_70146_Z.nextInt(15) - 7, EntityAllyVex.this.field_70146_Z.nextInt(11) - 5, EntityAllyVex.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityAllyVex.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityAllyVex.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityAllyVex.this.func_70638_az() != null) break;
                EntityAllyVex.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        private final EntityPredicate copyOwnerTargeting;

        public CopyOwnerTargetGoal(CreatureEntity creature) {
            super((MobEntity)creature, false);
            this.copyOwnerTargeting = new EntityPredicate().func_221014_c().func_221010_e();
        }

        public boolean func_75250_a() {
            return EntityAllyVex.this.owner != null && EntityAllyVex.this.owner.func_110144_aD() != null;
        }

        public void func_75249_e() {
            EntityAllyVex.this.func_70624_b(EntityAllyVex.this.owner.func_110144_aD());
            super.func_75249_e();
        }
    }

    class MoveHelperController
    extends MovementController {
        public MoveHelperController(VexEntity vex) {
            super((MobEntity)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d vec3d = new Vector3d(this.field_75646_b - EntityAllyVex.this.func_226277_ct_(), this.field_75647_c - EntityAllyVex.this.func_226278_cu_(), this.field_75644_d - EntityAllyVex.this.func_226281_cx_());
                double d0 = vec3d.func_72433_c();
                if (d0 < EntityAllyVex.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    EntityAllyVex.this.func_213317_d(EntityAllyVex.this.func_213322_ci().func_186678_a(0.5));
                } else {
                    EntityAllyVex.this.func_213317_d(EntityAllyVex.this.func_213322_ci().func_178787_e(vec3d.func_186678_a(this.field_75645_e * 0.05 / d0)));
                    if (EntityAllyVex.this.func_70638_az() == null) {
                        Vector3d vec3d1 = EntityAllyVex.this.func_213322_ci();
                        EntityAllyVex.this.field_70761_aq = EntityAllyVex.this.field_70177_z = -((float)MathHelper.func_181159_b((double)vec3d1.field_72450_a, (double)vec3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d2 = EntityAllyVex.this.func_70638_az().func_226277_ct_() - EntityAllyVex.this.func_226277_ct_();
                        double d1 = EntityAllyVex.this.func_70638_az().func_226281_cx_() - EntityAllyVex.this.func_226281_cx_();
                        EntityAllyVex.this.field_70761_aq = EntityAllyVex.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d2, (double)d1)) * 57.295776f;
                    }
                }
            }
        }
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (EntityAllyVex.this.func_70638_az() != null && !EntityAllyVex.this.func_70605_aq().func_75640_a() && EntityAllyVex.this.field_70146_Z.nextInt(7) == 0) {
                return EntityAllyVex.this.func_70068_e((Entity)EntityAllyVex.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntityAllyVex.this.func_70605_aq().func_75640_a() && EntityAllyVex.this.func_190647_dj() && EntityAllyVex.this.func_70638_az() != null && EntityAllyVex.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            LivingEntity livingentity = EntityAllyVex.this.func_70638_az();
            Vector3d vec3d = livingentity.func_174824_e(1.0f);
            EntityAllyVex.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            EntityAllyVex.this.func_190648_a(true);
            EntityAllyVex.this.func_184185_a(SoundEvents.field_191265_hd, 1.0f, 1.0f);
        }

        public void func_75251_c() {
            EntityAllyVex.this.func_190648_a(false);
        }

        public void func_75246_d() {
            LivingEntity livingentity = EntityAllyVex.this.func_70638_az();
            if (EntityAllyVex.this.func_174813_aQ().func_72326_a(livingentity.func_174813_aQ())) {
                EntityAllyVex.this.func_70652_k((Entity)livingentity);
                EntityAllyVex.this.func_190648_a(false);
            } else {
                double d0 = EntityAllyVex.this.func_70068_e((Entity)livingentity);
                if (d0 < 9.0) {
                    Vector3d vec3d = livingentity.func_174824_e(1.0f);
                    EntityAllyVex.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                }
            }
        }
    }
}

