/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketWarpPosition;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.world.server.ServerWorld;

public class PortalTile
extends TileEntity
implements ITickableTileEntity,
ITooltipProvider {
    public BlockPos warpPos;
    public String dimID;
    public Vector2f rotationVec;
    public String displayName;

    public PortalTile() {
        super(BlockRegistry.PORTAL_TILE_TYPE);
    }

    public void warp(Entity e) {
        if (!this.field_145850_b.field_72995_K && this.warpPos != null && !(this.field_145850_b.func_180495_p(this.warpPos).func_177230_c() instanceof PortalBlock)) {
            e.func_70012_b((double)this.warpPos.func_177958_n() + 0.5, (double)this.warpPos.func_177956_o(), (double)this.warpPos.func_177952_p() + 0.5, this.rotationVec != null ? this.rotationVec.field_189983_j : e.field_70177_z, this.rotationVec != null ? this.rotationVec.field_189982_i : e.field_70125_A);
            e.field_70125_A = this.rotationVec != null ? this.rotationVec.field_189982_i : e.field_70125_A;
            e.field_70177_z = this.rotationVec != null ? this.rotationVec.field_189983_j : e.field_70177_z;
            Networking.sendToNearby(this.field_145850_b, e, (Object)new PacketWarpPosition(e.func_145782_y(), e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), e.field_70125_A, e.field_70177_z));
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197599_J, (double)this.warpPos.func_177958_n(), (double)(this.warpPos.func_177956_o() + 1), (double)this.warpPos.func_177952_p(), 4, (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 2.0, -this.field_145850_b.field_73012_v.nextDouble(), (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 2.0, (double)0.1f);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.dimID = compound.func_74779_i("dim");
        this.warpPos = NBTUtil.getBlockPos(compound, "warp");
        this.rotationVec = new Vector2f(compound.func_74760_g("xRot"), compound.func_74760_g("yRot"));
        this.displayName = compound.func_74779_i("display");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.warpPos != null) {
            NBTUtil.storeBlockPos(compound, "warp", this.warpPos);
        }
        compound.func_74778_a("dim", this.dimID);
        if (this.rotationVec != null) {
            compound.func_74776_a("xRot", this.rotationVec.field_189982_i);
            compound.func_74776_a("yRot", this.rotationVec.field_189983_j);
        }
        if (this.displayName != null) {
            compound.func_74778_a("display", this.displayName);
        }
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.warpPos != null && !(this.field_145850_b.func_180495_p(this.warpPos).func_177230_c() instanceof PortalBlock)) {
            List entities = this.field_145850_b.func_217357_a(Entity.class, new AxisAlignedBB(this.field_174879_c));
            for (Entity e : entities) {
                this.field_145850_b.func_184133_a(null, this.warpPos, SoundEvents.field_193788_dg, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                e.func_70634_a((double)this.warpPos.func_177958_n(), (double)this.warpPos.func_177956_o(), (double)this.warpPos.func_177952_p());
                ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197599_J, (double)this.warpPos.func_177958_n(), (double)(this.warpPos.func_177956_o() + 1), (double)this.warpPos.func_177952_p(), 4, (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 2.0, -this.field_145850_b.field_73012_v.nextDouble(), (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 2.0, (double)0.1f);
                if (this.rotationVec == null) continue;
                e.field_70125_A = this.rotationVec.field_189982_i;
                e.field_70177_z = this.rotationVec.field_189983_j;
                Networking.sendToNearby(e.field_70170_p, e, (Object)new PacketWarpPosition(e.func_145782_y(), this.warpPos.func_177958_n(), this.warpPos.func_177956_o(), this.warpPos.func_177952_p(), e.field_70125_A, e.field_70177_z));
            }
        }
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.displayName != null) {
            list.add(this.displayName);
        }
        return list;
    }

    public boolean update() {
        if (this.field_174879_c != null && this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            return true;
        }
        return false;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }
}

