/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.MathUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.IntangibleAirTile;
import com.hollingsworth.arsnouveau.common.block.tile.PhantomBlockTile;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public interface ISpellCaster {
    @Nonnull
    public Spell getSpell();

    public Spell getSpell(int var1);

    public int getMaxSlots();

    public int getCurrentSlot();

    public void setCurrentSlot(int var1);

    public void setSpell(Spell var1, int var2);

    public void setSpell(Spell var1);

    public void setColor(ParticleColor.IntWrapper var1);

    public void setFlavorText(String var1);

    public String getFlavorText();

    public ParticleColor.IntWrapper getColor();

    public Map<Integer, Spell> getSpells();

    default public Spell getSpell(World world, PlayerEntity playerEntity, Hand hand, ISpellCaster caster) {
        return caster.getSpell();
    }

    default public ActionResult<ItemStack> castSpell(World worldIn, PlayerEntity playerIn, Hand handIn, TranslationTextComponent invalidMessage, Spell spell) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
        }
        if (spell == null) {
            PortUtil.sendMessageNoSpam((Entity)playerIn, (ITextComponent)invalidMessage);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        SpellResolver resolver = new SpellResolver(new SpellContext(spell, (LivingEntity)playerIn).withColors(this.getColor()));
        boolean isSensitive = resolver.spell.getBuffsAtIndex(0, (LivingEntity)playerIn, AugmentSensitive.INSTANCE) > 0;
        RayTraceResult result = playerIn.func_213324_a(5.0, 0.0f, isSensitive);
        if (result instanceof BlockRayTraceResult && worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a()) instanceof ScribesTile) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (result instanceof BlockRayTraceResult && !playerIn.func_225608_bj_() && worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a()) != null && !(worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a()) instanceof IntangibleAirTile) && !(worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a()) instanceof PhantomBlockTile)) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        EntityRayTraceResult entityRes = MathUtil.getLookedAtEntity((LivingEntity)playerIn, 25);
        if (entityRes != null && entityRes.func_216348_a() instanceof LivingEntity) {
            resolver.onCastOnEntity(stack, (LivingEntity)playerIn, (Entity)((LivingEntity)entityRes.func_216348_a()), handIn);
            return new ActionResult(ActionResultType.CONSUME, (Object)stack);
        }
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK || isSensitive && result instanceof BlockRayTraceResult) {
            ItemUseContext context = new ItemUseContext(playerIn, handIn, (BlockRayTraceResult)result);
            resolver.onCastOnBlock(context);
            return new ActionResult(ActionResultType.CONSUME, (Object)stack);
        }
        resolver.onCast(stack, (LivingEntity)playerIn, worldIn);
        return new ActionResult(ActionResultType.CONSUME, (Object)stack);
    }

    default public ActionResult<ItemStack> castSpell(World worldIn, PlayerEntity playerIn, Hand handIn, TranslationTextComponent invalidMessage) {
        return this.castSpell(worldIn, playerIn, handIn, invalidMessage, this.getSpell(worldIn, playerIn, handIn, this));
    }
}

