/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.recipe;

import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.RecipeRegistry;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GlyphPressRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation id;
    public final ISpellTier.Tier tier;
    public final ItemStack reagent;
    public final ItemStack output;

    public GlyphPressRecipe(ResourceLocation id, ISpellTier.Tier tier, ItemStack reagent, ItemStack output) {
        this.id = id;
        this.tier = tier;
        this.reagent = reagent;
        this.output = output;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.output;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeRegistry.PRESS_SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return (IRecipeType)Registry.field_218367_H.func_82594_a(new ResourceLocation("ars_nouveau", "glyph_recipe"));
    }

    public ItemStack getClay() {
        return GlyphPressRecipe.getClayFromTier(this.tier);
    }

    public static ItemStack getClayFromTier(ISpellTier.Tier tier) {
        switch (tier) {
            case ONE: {
                return new ItemStack((IItemProvider)ItemsRegistry.magicClay);
            }
            case TWO: {
                return new ItemStack((IItemProvider)ItemsRegistry.marvelousClay);
            }
        }
        return new ItemStack((IItemProvider)ItemsRegistry.mythicalClay);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<GlyphPressRecipe> {
        public GlyphPressRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ISpellTier.Tier tier = ISpellTier.Tier.valueOf(JSONUtils.func_151219_a((JsonObject)json, (String)"tier", (String)"ONE"));
            ItemStack input = new ItemStack((IItemProvider)JSONUtils.func_188180_i((JsonObject)json, (String)"input"));
            ItemStack output = new ItemStack((IItemProvider)JSONUtils.func_188180_i((JsonObject)json, (String)"output"));
            return new GlyphPressRecipe(recipeId, tier, input, output);
        }

        @Nullable
        public GlyphPressRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            ISpellTier.Tier tier = ISpellTier.Tier.valueOf(buffer.func_218666_n());
            ItemStack input = buffer.func_150791_c();
            ItemStack output = buffer.func_150791_c();
            return new GlyphPressRecipe(recipeId, tier, input, output);
        }

        public void toNetwork(PacketBuffer buf, GlyphPressRecipe recipe) {
            buf.func_180714_a(recipe.tier.toString());
            buf.func_150788_a(recipe.reagent);
            buf.func_150788_a(recipe.output);
        }
    }
}

