/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.mekanism;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.util.MapJS;
import javax.annotation.Nullable;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;

public abstract class MekanismRecipeJS
extends RecipeJS {
    public JsonElement serializeIngredientStack(IngredientStackJS in) {
        JsonObject json = new JsonObject();
        json.add("ingredient", in.ingredient.toJson());
        if (in.getCount() > 1) {
            json.addProperty("amount", (Number)in.getCount());
        }
        return json;
    }

    public static GasStackIngredient parseGasIngrdient(@Nullable Object o) {
        if (o instanceof JsonElement) {
            return GasStackIngredient.deserialize((JsonElement)((JsonElement)o));
        }
        if (o instanceof CharSequence) {
            JsonObject json = new JsonObject();
            json.addProperty("gas", o.toString());
            json.addProperty("amount", (Number)1000);
            return GasStackIngredient.deserialize((JsonElement)json);
        }
        JsonObject json = MapJS.of((Object)o).toJson();
        if (!json.has("amount")) {
            json.addProperty("amount", (Number)1000);
        }
        return GasStackIngredient.deserialize((JsonElement)json);
    }

    public static GasStack parseGasResult(@Nullable Object o) {
        if (o instanceof JsonObject) {
            return SerializerHelper.deserializeGas((JsonObject)((JsonObject)o));
        }
        if (o instanceof CharSequence) {
            JsonObject json = new JsonObject();
            json.addProperty("gas", o.toString());
            json.addProperty("amount", (Number)1000);
            return SerializerHelper.deserializeGas((JsonObject)json);
        }
        JsonObject json = MapJS.of((Object)o).toJson();
        if (!json.has("amount")) {
            json.addProperty("amount", (Number)1000);
        }
        return SerializerHelper.deserializeGas((JsonObject)json);
    }

    public static JsonElement parseChemicalStack(@Nullable Object o) {
        JsonObject json = new JsonObject();
        json.add("output", (JsonElement)MapJS.of((Object)o).toJson());
        return SerializerHelper.serializeBoxedChemicalStack((BoxedChemicalStack)BoxedChemicalStack.box((ChemicalStack)SerializerHelper.getBoxedChemicalStack((JsonObject)json, (String)"output")));
    }

    public static JsonObject serializeGasResult(GasStack stack) {
        return SerializerHelper.serializeGasStack((GasStack)stack);
    }

    public IngredientJS convertReplacedInput(int index, IngredientJS oldIngredient, IngredientJS newIngredient) {
        return newIngredient.asIngredientStack();
    }
}

