/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.displacement;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SplashPotionItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.kodoku.KodokuItem;
import stepsword.mahoutsukai.networking.DataManagerPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.MisfortunePotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.proxy.CommonProxy;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;
import stepsword.mahoutsukai.util.Utils;

public class ScryingMahoujinTileEntity
extends MahoujinTileEntity
implements ITickableTileEntity {
    private LivingEntity scryTarget = null;
    private CompoundNBT scryNBT = null;
    private float yaw = 0.0f;
    private float hyaw = 0.0f;
    private float ryaw = 0.0f;
    private float pitch = 0.0f;
    private float pyaw = 0.0f;
    private float phyaw = 0.0f;
    private float pryaw = 0.0f;
    private float ppitch = 0.0f;
    private double velx = 0.0;
    private double vely = 0.0;
    private double velz = 0.0;
    public Vector3d targetPos = null;
    public float prevSwingProgress = 0.0f;
    public float swingProgress = 0.0f;
    private UUID scryUniqueID = null;
    public float limbSwingAmount = 0.0f;
    public float prevLimbSwingAmount = 0.0f;
    public float limbSwing = 0.0f;
    public ArrayList<BlockPosInfo> lst = null;
    public List<EntityDataManager.DataEntry<?>> scryDataManager = null;
    private int tickCounter = 0;
    private int scryTimer = 0;
    private String viewTarget = "";
    private String VIEW_TARGET = "MAHOUTSUKAI_VIEW_TARGET";
    private String SCRY_ENTITY = "MAHOUTSUKAI_SCRY_ENTITY";
    private String SCRY_RENDER_YAW = "MAHOUTSUKAI_RENDER_YAW";
    private String SCRY_YAW = "MAHOUTSUKAI_YAW";
    private String SCRY_HEAD_YAW = "MAHOUTSUKAI_HYAW";
    private String SCRY_PITCH = "MAHOUTSUKAI_PITCH";
    private String SCRY_VEL_X = "MAHOUTSUKAI_VEL_X";
    private String SCRY_VEL_Y = "MAHOUTSUKAI_VEL_Y";
    private String SCRY_VEL_Z = "MAHOUTSUKAI_VEL_Z";
    private String SCRY_UNIQ = "MAHOUTSUKAI_SCRY_UNIQ";
    private String LIMB_SWING = "MAHOUTSUKAI_LS";
    private String LIMB_SWING_AMOUNT = "MAHOUTSUKAI_LSA";
    private String LIMB_SWING_PROGRESS = "MAHOUTSUKAI_LSP";
    private String SCRY_LOC_X = "MAHOUTSUKAI_LOC_X";
    private String SCRY_LOC_Y = "MAHOUTSUKAI_LOC_Y";
    private String SCRY_LOC_Z = "MAHOUTSUKAI_LOC_Z";
    private String SCRY_BLOCK = "MAHOUTSUKAI_BLOCK_";
    private boolean doRead = false;

    public ScryingMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.scrying);
    }

    public LivingEntity getScryTarget() {
        return this.scryTarget;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74778_a(this.VIEW_TARGET, this.viewTarget);
        if (this.scryTarget != null) {
            compound.func_74776_a(this.SCRY_PITCH, this.scryTarget.field_70125_A);
            compound.func_74776_a(this.SCRY_YAW, this.scryTarget.field_70177_z);
            compound.func_74776_a(this.SCRY_HEAD_YAW, this.scryTarget.field_70759_as);
            compound.func_74776_a(this.SCRY_RENDER_YAW, this.scryTarget.field_70761_aq);
            compound.func_74776_a(this.SCRY_RENDER_YAW, this.scryTarget.field_70761_aq);
            compound.func_74776_a(this.LIMB_SWING, this.scryTarget.field_184619_aG);
            compound.func_74776_a(this.LIMB_SWING_AMOUNT, this.scryTarget.field_70721_aZ);
            compound.func_74776_a(this.LIMB_SWING_PROGRESS, this.scryTarget.field_70733_aJ);
            Vector3d epos = this.scryTarget.func_213303_ch();
            Vector3d emot = this.scryTarget.func_213322_ci();
            compound.func_74780_a(this.SCRY_VEL_X, emot.field_72450_a);
            compound.func_74780_a(this.SCRY_VEL_Y, emot.field_72448_b);
            compound.func_74780_a(this.SCRY_VEL_Z, emot.field_72449_c);
            compound.func_74780_a(this.SCRY_LOC_X, epos.field_72450_a);
            compound.func_74780_a(this.SCRY_LOC_Y, epos.field_72448_b);
            compound.func_74780_a(this.SCRY_LOC_Z, epos.field_72449_c);
            compound.func_186854_a(this.SCRY_UNIQ, this.scryTarget.func_110124_au());
            int index = 0;
            int i = (int)Math.floor(epos.field_72450_a - 1.0);
            while ((double)i <= epos.field_72450_a + 1.0) {
                int j = (int)Math.floor(epos.field_72449_c - 1.0);
                while ((double)j <= epos.field_72449_c + 1.0) {
                    int k = (int)Math.floor(epos.field_72448_b - 1.0);
                    while ((double)k <= epos.field_72448_b + 2.0) {
                        BlockPos p = new BlockPos(i, k, j);
                        BlockPosInfo info = new BlockPosInfo(p, this.field_145850_b);
                        CompoundNBT infonbt = info.write();
                        compound.func_218657_a(this.SCRY_BLOCK + index, (INBT)infonbt);
                        ++index;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            CompoundNBT nbt = new CompoundNBT();
            EntityType entitytype = this.scryTarget.func_200600_R();
            ResourceLocation resourcelocation = EntityType.func_200718_a((EntityType)entitytype);
            nbt.func_74778_a("id", resourcelocation.toString());
            this.scryTarget.func_189511_e(nbt);
            compound.func_218657_a(this.SCRY_ENTITY, (INBT)nbt);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.viewTarget = compound.func_74779_i(this.VIEW_TARGET);
        if (compound.func_74764_b(this.SCRY_ENTITY)) {
            if (compound.func_74764_b(this.SCRY_YAW)) {
                this.yaw = compound.func_74760_g(this.SCRY_YAW);
            }
            if (compound.func_74764_b(this.SCRY_PITCH)) {
                this.pitch = compound.func_74760_g(this.SCRY_PITCH);
            }
            if (compound.func_74764_b(this.SCRY_HEAD_YAW)) {
                this.hyaw = compound.func_74760_g(this.SCRY_HEAD_YAW);
            }
            if (compound.func_74764_b(this.SCRY_RENDER_YAW)) {
                this.ryaw = compound.func_74760_g(this.SCRY_RENDER_YAW);
            }
            if (compound.func_74764_b(this.LIMB_SWING)) {
                this.limbSwing = compound.func_74760_g(this.LIMB_SWING);
            }
            if (compound.func_74764_b(this.LIMB_SWING_AMOUNT)) {
                this.limbSwingAmount = compound.func_74760_g(this.LIMB_SWING_AMOUNT);
            }
            if (compound.func_74764_b(this.LIMB_SWING_PROGRESS)) {
                this.swingProgress = compound.func_74760_g(this.LIMB_SWING_PROGRESS);
            }
            if (compound.func_74764_b(this.SCRY_VEL_X)) {
                this.velx = compound.func_74769_h(this.SCRY_VEL_X);
            }
            if (compound.func_74764_b(this.SCRY_VEL_Y)) {
                this.vely = compound.func_74769_h(this.SCRY_VEL_Y);
            }
            if (compound.func_74764_b(this.SCRY_VEL_Z)) {
                this.velz = compound.func_74769_h(this.SCRY_VEL_Z);
            }
            if (compound.func_186855_b(this.SCRY_UNIQ)) {
                this.scryUniqueID = compound.func_186857_a(this.SCRY_UNIQ);
            }
            int index = 0;
            this.lst = new ArrayList();
            while (compound.func_74764_b(this.SCRY_BLOCK + index)) {
                BlockPosInfo info = new BlockPosInfo();
                info.read(compound.func_74775_l(this.SCRY_BLOCK + index), this.field_145850_b);
                this.lst.add(info);
                ++index;
            }
            if (compound.func_74764_b(this.SCRY_LOC_X) && compound.func_74764_b(this.SCRY_LOC_Y) && compound.func_74764_b(this.SCRY_LOC_X)) {
                this.targetPos = new Vector3d(compound.func_74769_h(this.SCRY_LOC_X), compound.func_74769_h(this.SCRY_LOC_Y), compound.func_74769_h(this.SCRY_LOC_Z));
            }
            this.scryNBT = (CompoundNBT)compound.func_74781_a(this.SCRY_ENTITY);
            this.doRead = true;
        } else {
            this.scryTarget = null;
            this.lst = new ArrayList();
            this.scryNBT = null;
        }
        super.func_230337_a_(state, compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.scryTimer >= MTConfig.SCRYING_DURATION) {
                this.viewTarget = "";
                this.scryTarget = null;
                this.sendUpdates();
            }
            if (this.tickCounter == MTConfig.SCRYING_BLOCK_CYCLE) {
                boolean changedName = false;
                List lst = this.field_145850_b.func_217357_a(Entity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)));
                if (!lst.isEmpty()) {
                    PlayerEntity caster = this.getCaster();
                    Entity entityIn = (Entity)lst.get(0);
                    if (entityIn instanceof ItemEntity) {
                        boolean nearbyBatteriesGaveMana;
                        if (((ItemEntity)entityIn).func_92059_d().func_77973_b() == Items.field_151057_cb && ((nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.field_174879_c, this.field_145850_b, this.getCasterUUID(), MTConfig.SCRYING_MANA_COST)) || caster != null && PlayerManaManager.drainMana(caster, MTConfig.SCRYING_MANA_COST, false, false) == MTConfig.SCRYING_MANA_COST)) {
                            String s = ((ItemEntity)entityIn).func_92059_d().func_200301_q().getString();
                            this.viewTarget = s != null ? s : "";
                            this.scryTimer = 0;
                            changedName = true;
                            this.sendUpdates();
                            entityIn.func_70106_y();
                        }
                        this.sympathetic((ItemEntity)entityIn);
                    }
                }
                if (this.scryTarget == null || !this.scryTarget.func_70089_S() || changedName || this.doRead) {
                    if (this.viewTarget != null && !this.viewTarget.equals("")) {
                        PlayerEntity e = ScryingMahoujinTileEntity.getPlayerByName(this.viewTarget, this.field_145850_b);
                        if (e == null) {
                            HashSet<Entity> loaded = CommonProxy.getAllEntities((ServerWorld)this.field_145850_b);
                            this.scryTarget = null;
                            if (loaded != null) {
                                for (Entity entity2 : loaded) {
                                    if (entity2.func_200201_e() == null || !entity2.func_200201_e().getString().equals(this.viewTarget) || !(entity2 instanceof LivingEntity)) continue;
                                    this.scryTarget = (LivingEntity)entity2;
                                    this.sendUpdates();
                                    break;
                                }
                                if (this.scryTarget == null) {
                                    for (Entity entity2 : loaded) {
                                        if (!entity2.func_145748_c_().getString().equals(this.viewTarget) || !(entity2 instanceof LivingEntity)) continue;
                                        this.scryTarget = (LivingEntity)entity2;
                                        this.sendUpdates();
                                        break;
                                    }
                                }
                            }
                        } else {
                            this.scryTarget = e;
                            this.sendUpdates();
                        }
                    }
                    if (this.scryTarget != null && !this.scryTarget.func_70089_S()) {
                        this.scryTarget = null;
                        this.sendUpdates();
                    }
                    this.doRead = false;
                }
                if (this.scryTarget != null && this.scryTarget.func_70089_S()) {
                    List entries = this.scryTarget.func_184212_Q().func_187231_c();
                    if (entries != null) {
                        ArrayList entriesCopy = new ArrayList();
                        for (EntityDataManager.DataEntry e : entries) {
                            entriesCopy.add(e.func_192735_d());
                        }
                        ArrayList toSend = new ArrayList();
                        boolean changed = false;
                        if (this.scryDataManager == null) {
                            toSend = entriesCopy;
                            changed = true;
                        } else {
                            for (EntityDataManager.DataEntry<?> e : this.scryDataManager) {
                                DataParameter key = e.func_187205_a();
                                Object value = e.func_187206_b();
                                for (EntityDataManager.DataEntry dataEntry : entriesCopy) {
                                    if (!dataEntry.func_187205_a().equals((Object)key) || dataEntry.func_187206_b().equals(value)) continue;
                                    toSend.add(dataEntry);
                                    changed = true;
                                }
                            }
                        }
                        this.scryDataManager = entriesCopy;
                        if (changed && toSend.size() > 0) {
                            int r = 32;
                            AxisAlignedBB aabb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - r), (double)(this.field_174879_c.func_177956_o() - r), (double)(this.field_174879_c.func_177952_p() - r), (double)(this.field_174879_c.func_177958_n() + r), (double)(this.field_174879_c.func_177956_o() + r), (double)(this.field_174879_c.func_177952_p() + r));
                            List players = this.field_145850_b.func_217357_a(ServerPlayerEntity.class, aabb);
                            for (ServerPlayerEntity player : players) {
                                PacketHandler.sendTo(player, new DataManagerPacket(this.field_174879_c, toSend));
                            }
                        }
                    }
                    this.scryNBT = new CompoundNBT();
                    this.scryTarget.func_184198_c(this.scryNBT);
                    this.sendUpdates();
                }
                this.tickCounter = 0;
            }
            ++this.scryTimer;
            ++this.tickCounter;
        }
        if (this.doRead && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            EntityType zz = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(this.scryNBT.func_74779_i("id")));
            if (this.scryNBT != null && zz != null && zz == EntityType.field_200729_aH) {
                this.scryTarget = MahouTsukaiMod.proxy.getPlayerForScry(this.field_145850_b, this.viewTarget, this.scryNBT, this.scryUniqueID);
            } else if (this.scryNBT != null && !this.scryNBT.isEmpty()) {
                try {
                    EntityType.func_220330_a((CompoundNBT)this.scryNBT, (World)this.field_145850_b).ifPresent(entity -> {
                        this.scryTarget = (LivingEntity)entity;
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.doRead = false;
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && this.scryTarget != null) {
            this.scryTarget.field_70759_as = this.hyaw;
            this.scryTarget.field_70758_at = this.phyaw;
            this.scryTarget.field_70177_z = this.yaw;
            this.scryTarget.field_70126_B = this.pyaw;
            this.scryTarget.field_70125_A = this.pitch;
            this.scryTarget.field_70127_C = this.ppitch;
            this.scryTarget.field_70761_aq = this.ryaw;
            this.scryTarget.field_70760_ar = this.pryaw;
            this.scryTarget.func_213317_d(new Vector3d(this.velx, this.vely, this.velz));
            this.scryTarget.field_184619_aG = this.limbSwing;
            this.scryTarget.field_70721_aZ = this.limbSwingAmount;
            this.scryTarget.field_184618_aE = this.prevLimbSwingAmount;
            this.scryTarget.field_70733_aJ = this.swingProgress;
            this.scryTarget.field_70732_aI = this.prevSwingProgress;
            this.scryTarget.func_70107_b(this.targetPos.field_72450_a, this.targetPos.field_72448_b, this.targetPos.field_72449_c);
            this.prevLimbSwingAmount = this.scryTarget.field_70721_aZ;
            this.prevSwingProgress = this.scryTarget.field_70733_aJ;
            this.pyaw = this.scryTarget.field_70177_z;
            this.pryaw = this.scryTarget.field_70761_aq;
            this.ppitch = this.scryTarget.field_70125_A;
            this.phyaw = this.scryTarget.field_70759_as;
            if (this.scryDataManager != null) {
                try {
                    this.scryTarget.func_184212_Q().func_187218_a(this.scryDataManager);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static PlayerEntity getPlayerByName(String name, World world) {
        PlayerEntity ret = null;
        if (world != null) {
            for (PlayerEntity p : world.func_217369_A()) {
                if (!p.func_200200_C_().getString().equals(name)) continue;
                ret = p;
            }
        }
        return ret;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void sympathetic(ItemEntity e) {
        IItemHandler inventory;
        TileEntity down;
        double firechance = MTConfig.KODOKU_FIRE_CHANCE;
        double splashchance = MTConfig.KODOKU_SPLASH_CHANCE;
        double hungerchance = MTConfig.KODOKU_HUNGER_CHANCE;
        double hopchance = MTConfig.KODOKU_HOP_CHANCE;
        double glowchance = MTConfig.KODOKU_GLOW_CHANCE;
        double telechance = MTConfig.KODOKU_TELEPORT_CHANCE;
        double confusechance = MTConfig.KODOKU_CONFUSE_CHANCE;
        if (this.scryTarget != null && this.scryTarget.func_70089_S() && this.field_145850_b != null && (down = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(Direction.DOWN))) != null && (inventory = Utils.getInventory(down)) != null) {
            int kodoku = 0;
            int targetkodoku = MisfortunePotion.getMaxKodoku(this.scryTarget);
            ItemStack s = null;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                s = inventory.getStackInSlot(i);
                if (!(s.func_77973_b() instanceof KodokuItem)) continue;
                kodoku = KodokuItem.getKodoku(s);
                break;
            }
            LivingEntity realTarget = this.scryTarget;
            if (targetkodoku > kodoku * 2) {
                realTarget = this.getCaster();
            } else {
                kodoku -= targetkodoku;
            }
            if (kodoku > 0 && s != null) {
                boolean success = false;
                boolean consume = false;
                boolean actualconsume = false;
                if (this.getCaster() != null) {
                    if (e.func_92059_d().func_77973_b() == Items.field_151065_br) {
                        if (this.getCaster().func_70681_au().nextDouble() < firechance * (double)kodoku) {
                            realTarget.func_70015_d(7);
                            success = true;
                        }
                        consume = true;
                        actualconsume = true;
                    } else if (e.func_92059_d().func_77973_b() instanceof SplashPotionItem) {
                        if (this.getCaster().func_70681_au().nextDouble() < splashchance * (double)kodoku) {
                            ItemStack pot = e.func_92059_d().func_77979_a(1);
                            PotionEntity entitypotion = new PotionEntity(this.field_145850_b, realTarget.func_226277_ct_(), realTarget.func_226278_cu_(), realTarget.func_226281_cx_());
                            entitypotion.func_213884_b(pot);
                            this.field_145850_b.func_217376_c((Entity)entitypotion);
                            success = true;
                        }
                        consume = true;
                    } else if (e.func_92059_d().func_77973_b() == Items.field_151078_bh) {
                        if (realTarget instanceof PlayerEntity) {
                            if (this.getCaster().func_70681_au().nextDouble() < hungerchance * (double)kodoku) {
                                ((PlayerEntity)realTarget).func_71024_bL().func_75114_a(Math.max(((PlayerEntity)realTarget).func_71024_bL().func_75116_a() - 5, 0));
                                success = true;
                            }
                            consume = true;
                            actualconsume = true;
                        }
                    } else if (e.func_92059_d().func_77973_b() == Items.field_179556_br) {
                        if (this.getCaster().func_70681_au().nextDouble() < hopchance * (double)kodoku) {
                            realTarget.func_213293_j(realTarget.func_213322_ci().field_72450_a, (double)1.1f, realTarget.func_213322_ci().field_72449_c);
                            realTarget.field_70133_I = true;
                            realTarget.field_70160_al = true;
                            success = true;
                        }
                        actualconsume = true;
                        consume = true;
                    } else if (e.func_92059_d().func_77973_b() == ModItems.kodoku) {
                        if (KodokuItem.getKodoku(e.func_92059_d()) > 0) {
                            EffectUtil.buff(realTarget, ModEffects.MISFORTUNE, true, 600, KodokuItem.getKodoku(e.func_92059_d()));
                            success = true;
                        }
                        consume = true;
                        actualconsume = true;
                    } else if (e.func_92059_d().func_77973_b() == Items.field_151114_aO) {
                        if (this.getCaster().func_70681_au().nextDouble() < glowchance * (double)kodoku) {
                            EffectUtil.buff(realTarget, Effects.field_188423_x, true, 600);
                            success = true;
                        }
                        actualconsume = true;
                        consume = true;
                    } else if (e.func_92059_d().func_77973_b() == Items.field_151079_bi) {
                        if (this.getCaster().func_70681_au().nextDouble() < telechance * (double)kodoku) {
                            if (!(realTarget instanceof PlayerEntity) || ContractMahoujinTileEntity.isImmuneToSpell(realTarget.field_70170_p, this.getCasterUUID(), (Entity)realTarget)) {
                                MahouTsukaiTeleporter.teleport((Entity)realTarget, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, EffectUtil.getDimension(this.getCaster().field_70170_p));
                                success = true;
                            } else {
                                this.getCaster().func_146105_b((ITextComponent)new TranslationTextComponent("mahoutsukai.teleport_kodoku.failed"), true);
                                success = true;
                            }
                        }
                        actualconsume = true;
                        consume = true;
                    } else if (e.func_92059_d().func_77973_b() == Items.field_151075_bm) {
                        if (this.getCaster().func_70681_au().nextDouble() < confusechance * (double)kodoku) {
                            EffectUtil.buff(realTarget, ModEffects.CONFUSION, true, 240);
                            success = true;
                        }
                        consume = true;
                        actualconsume = true;
                    }
                    if (!success && consume) {
                        this.getCaster().func_146105_b((ITextComponent)new TranslationTextComponent("mahoutsukai.kodoku.failed"), true);
                    }
                    if (success) {
                        ModTriggers.KODOKU.trigger((ServerPlayerEntity)this.getCaster());
                    }
                    if (actualconsume) {
                        e.func_92059_d().func_190918_g(1);
                        s.func_190918_g(1);
                    }
                }
            }
        }
    }

    public class BlockPosInfo {
        public BlockState state;
        public TileEntity te;

        public BlockPosInfo(BlockPos pos, World world) {
            this.state = world.func_180495_p(pos);
            this.te = null;
        }

        public BlockPosInfo() {
            this.state = null;
            this.te = null;
        }

        public CompoundNBT write() {
            if (this.state.func_177230_c() == Blocks.field_150350_a) {
                return new CompoundNBT();
            }
            CompoundNBT nbt = new CompoundNBT();
            CompoundNBT nbts = new CompoundNBT();
            CompoundNBT nbtte = new CompoundNBT();
            if (this.state != null) {
                nbts = NBTUtil.func_190009_a((BlockState)this.state);
                nbt.func_218657_a("SCRY_STATE", (INBT)nbts);
            }
            return nbt;
        }

        public void read(CompoundNBT nbt, World world) {
            if (nbt.func_74764_b("SCRY_STATE")) {
                this.state = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("SCRY_STATE"));
            }
        }
    }
}

