/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.world.server.ServerWorld;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class DrainLifeBoundaryMahoujinTileEntity
extends BoundaryMahoujinTileEntity {
    public DrainLifeBoundaryMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.drainLifeBoundary);
    }

    @Override
    public int getManaCost() {
        return MTConfig.DRAIN_LIFE_BARRIER_MANA_COST;
    }

    @Override
    public int getManaCycle() {
        return MTConfig.DRAIN_LIFE_BARRIER_MANA_CYCLE;
    }

    @Override
    public int getBarrierCycle() {
        return MTConfig.DRAIN_LIFE_BARRIER_CYCLE;
    }

    @Override
    public int getBarrierRadius() {
        return MTConfig.DRAIN_LIFE_BARRIER_RADIUS;
    }

    @Override
    public void doBarrier(List<LivingEntity> entities) {
        final PlayerEntity caster = this.getCaster();
        for (final LivingEntity e : entities) {
            final float tmpHealth = e.func_110143_aJ();
            if (EffectUtil.inEntityBlacklist((Entity)e, MTConfig.DRAIN_LIFE_ENTITY_BLACKLIST) || !this.drainLife(e) || caster == null || !(this.field_145850_b instanceof ServerWorld) || this.field_145850_b.func_73046_m() == null) continue;
            ((ServerWorld)this.field_145850_b).func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, new Runnable(){

                @Override
                public void run() {
                    float newHealth = e.func_110143_aJ();
                    if ((double)(tmpHealth - newHealth) >= MTConfig.DRAIN_LIFE_DAMAGE || !e.func_70089_S()) {
                        DrainLifeBoundaryMahoujinTileEntity.this.giveLife(caster);
                    } else {
                        EffectUtil.genericAttack(e, (float)(MTConfig.DRAIN_LIFE_DAMAGE * MTConfig.DRAIN_LIFE_PUNISH_RESIST), DamageSource.field_76377_j, (LivingEntity)caster);
                        DrainLifeBoundaryMahoujinTileEntity.this.giveLife(caster);
                    }
                }
            }));
        }
    }

    public boolean drainLife(LivingEntity entityIn) {
        if (!ContractMahoujinTileEntity.isImmuneToSpell(this.field_145850_b, this.getCasterUUID(), (Entity)entityIn)) {
            EffectUtil.magicAttack(entityIn, (float)MTConfig.DRAIN_LIFE_DAMAGE, (LivingEntity)this.getCaster());
            return true;
        }
        return false;
    }

    public void giveLife(PlayerEntity caster) {
        if (caster.func_110143_aJ() >= caster.func_110138_aP()) {
            FoodStats casterFS = caster.func_71024_bL();
            if (casterFS.func_75116_a() >= 20 || MTConfig.DRAIN_LIFE_IGNORE_HUNGER) {
                IMahou mahou = Utils.getPlayerMahou((LivingEntity)caster);
                if (mahou != null) {
                    mahou.setStoredMana(Math.min(mahou.getMaxMana(), mahou.getStoredMana() + MTConfig.DRAIN_LIFE_MANA_REGEN));
                }
            } else {
                casterFS.func_75114_a(casterFS.func_75116_a() + 1);
            }
        } else {
            caster.func_70691_i((float)MTConfig.DRAIN_LIFE_HEAL_FACTOR);
        }
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((IItemProvider)ModItems.boundaryDrainLifeScroll);
    }
}

