/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.potion.EyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class DeathCollectionEyesPotion
extends EyesPotion {
    protected DeathCollectionEyesPotion() {
        super(ModEffects.getColorNumber(50, 168, 82));
    }

    public static boolean deathCollectionEyesLivingDeath(LivingEntity entity, DamageSource source) {
        boolean ret = false;
        if (!entity.field_70170_p.field_72995_K) {
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
                if (mahou != null && mahou.getDeathCollectionUsesLeft() >= 1.0f && source != DamageSource.field_76380_i) {
                    ret = true;
                    mahou.setDeathCollectionUsesLeft(mahou.getDeathCollectionUsesLeft() - 1.0f);
                    player.func_70606_j(12.0f);
                } else {
                    DeathCollectionEyesPotion.notifyNearby((LivingEntity)player);
                }
            } else {
                DeathCollectionEyesPotion.notifyNearby(entity);
            }
        }
        return ret;
    }

    public static void notifyNearby(LivingEntity me) {
        int range = MTConfig.DEATH_COLLECTION_RANGE_FROM_USER;
        AxisAlignedBB aabb = new AxisAlignedBB(me.func_226277_ct_() - (double)range, me.func_226278_cu_() - (double)range, me.func_226281_cx_() - (double)range, me.func_226277_ct_() + (double)range, me.func_226278_cu_() + (double)range, me.func_226281_cx_() + (double)range);
        if (me != null && !me.field_70128_L) {
            List players = me.field_70170_p.func_175647_a(PlayerEntity.class, aabb, null);
            for (PlayerEntity p : players) {
                IMahou mahou;
                if (p == null || !p.func_70089_S() || p.func_110124_au().equals(me.func_110124_au()) || !EffectUtil.isLookingAtMe(me, (LivingEntity)p) || (mahou = Utils.getPlayerMahou((LivingEntity)p)) == null || !EffectUtil.hasBuff((LivingEntity)p, ModEffects.DEATH_COLLECTION_EYES)) continue;
                if (me instanceof PlayerEntity) {
                    mahou.setDeathCollectionUsesLeft((float)((double)mahou.getDeathCollectionUsesLeft() + MTConfig.DEATH_COLLECTION_SOUL_VALUE_PLAYER));
                } else {
                    mahou.setDeathCollectionUsesLeft((float)((double)mahou.getDeathCollectionUsesLeft() + MTConfig.DEATH_COLLECTION_SOUL_VALUE_MOB));
                }
                mahou.setDeathCollectionUsesLeft((float)Math.min((double)mahou.getDeathCollectionUsesLeft(), MTConfig.DEATH_COLLECTION_MAX));
                p.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Death collected. Total number of souls collected: " + mahou.getDeathCollectionUsesLeft()), true);
            }
        }
    }
}

