/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.util.ByteBufUtils;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class KeyPressPacket {
    String keyD;

    public KeyPressPacket() {
    }

    public KeyPressPacket(String k) {
        this.keyD = k;
    }

    public void fromBytes(ByteBuf buf) {
        String s;
        this.keyD = s = ByteBufUtils.readUTF8String(buf);
    }

    public void toBytes(ByteBuf buf) {
        String s = this.keyD;
        ByteBufUtils.writeUTF8String(buf, s);
    }

    public static void encode(KeyPressPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static KeyPressPacket decode(PacketBuffer buf) {
        KeyPressPacket msg = new KeyPressPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final KeyPressPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                if (message.keyD.equals("key.drawMahoujin")) {
                    KeyPressPacket.drawMahoujin(context);
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void drawMahoujin(Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        IMahou playerMahou = Utils.getPlayerMahou((LivingEntity)player);
        if (playerMahou != null && EffectUtil.hasBuff((LivingEntity)player, ModEffects.BLEEDING)) {
            Vector3d pp = player.func_213303_ch();
            Vector3d pv = player.func_70676_i(1.0f);
            pv = new Vector3d(pv.field_72450_a, 0.0, pv.field_72449_c).func_72432_b();
            Vector3d pgoal = new Vector3d(pv.field_72450_a + pp.field_72450_a, pp.field_72448_b - 1.0, pv.field_72449_c + pp.field_72449_c);
            BlockPos posInFront = new BlockPos(pgoal);
            BlockState blockInFrontState = world.func_180495_p(posInFront);
            if (Utils.isBlockAir(world, posInFront)) {
                posInFront = posInFront.func_177977_b();
                blockInFrontState = world.func_180495_p(posInFront);
            }
            if (!Utils.isBlockAir(world, posInFront) && !(blockInFrontState.func_177230_c() instanceof IFluidBlock) && (blockInFrontState.func_215682_a((IBlockReader)world, posInFront, (Entity)player, Direction.UP) && blockInFrontState.func_177230_c() != ModBlocks.mahoujin || blockInFrontState.func_177230_c() instanceof ChestBlock || !MTConfig.BLOOD_CIRCLE_SOLID_ONLY)) {
                BlockPos mahoujinPos = posInFront.func_177984_a();
                if (!Utils.isBlockAir(world, mahoujinPos) && world.func_180495_p(mahoujinPos).func_177230_c() != ModBlocks.spellClothBlock) {
                    mahoujinPos = mahoujinPos.func_177984_a();
                    posInFront = posInFront.func_177984_a();
                    blockInFrontState = world.func_180495_p(posInFront);
                }
                if (blockInFrontState.func_215682_a((IBlockReader)world, posInFront, (Entity)player, Direction.UP) && blockInFrontState.func_177230_c() != ModBlocks.mahoujin || blockInFrontState.func_177230_c() instanceof ChestBlock || !MTConfig.BLOOD_CIRCLE_SOLID_ONLY) {
                    if (Utils.isBlockAir(world, mahoujinPos) || world.func_180495_p(mahoujinPos).func_177230_c() == ModBlocks.spellClothBlock) {
                        boolean clothFlag = world.func_180495_p(mahoujinPos).func_177230_c() == ModBlocks.spellClothBlock;
                        world.func_175656_a(mahoujinPos, ModBlocks.mahoujin.func_176223_P());
                        TileEntity te = world.func_175625_s(mahoujinPos);
                        if (te instanceof MahoujinTileEntity) {
                            ((MahoujinTileEntity)te).setCaster((PlayerEntity)player);
                            ((MahoujinTileEntity)te).setCloth(clothFlag);
                            ((MahoujinTileEntity)te).setFay(false);
                        }
                        playerMahou.setHasMagic(true);
                        ModTriggers.MAHOUTSUKAI.trigger(player);
                        PlayerManaManager.updateClientMahou(player, playerMahou);
                    }
                    EffectUtil.debuff((LivingEntity)player, ModEffects.BLEEDING);
                }
            }
        }
    }
}

