/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.rulebreaker;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ProbabilityAlterPotion;
import stepsword.mahoutsukai.render.item.RuleBreakerRenderer;
import stepsword.mahoutsukai.util.EffectUtil;

public class RuleBreaker
extends SwordItem {
    public static String MODULUS_TAG = "MAHOUTSUKAI_RB_MODULUS";
    public static String DESIGNATION_TAG = "MAHOUTSUKAI_RB_DESIGNATION";

    public RuleBreaker() {
        super((IItemTier)ItemTier.IRON, 2, 1.0f, new Item.Properties().func_200916_a(ModItems.MAHOUTSUKAI_CREATIVE_TAB).func_200917_a(1).func_200918_c(MTConfig.RULE_BREAKER_DURABILITY).setISTER(() -> RuleBreakerRenderer::new));
        this.setRegistryName("rule_breaker");
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.RULE_BREAKER_DURABILITY;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_226273_bm_()) {
                RuleBreaker.setDesignation(stack, RuleBreaker.getDesignation(stack) + 1);
            } else if (!EffectUtil.hasBuff((LivingEntity)player, ModEffects.PROBABILITY_ALTER)) {
                player.func_70097_a(DamageSource.field_76377_j, 2.0f);
                EffectUtil.buff((LivingEntity)player, ModEffects.PROBABILITY_ALTER, false, MTConfig.RULE_BREAKER_DURATION);
                int mod = RuleBreaker.getModulus(stack);
                int des = RuleBreaker.getDesignation(stack);
                ProbabilityAlterPotion.createProbabilityAlter((LivingEntity)player, des, mod);
                stack.func_222118_a(1, (LivingEntity)player, a -> {});
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public static void ruleBreakerLivingHurt(LivingHurtEvent event) {
        Entity e = event.getSource().func_76346_g();
        if (e instanceof LivingEntity && ((LivingEntity)e).func_184614_ca().func_77973_b() instanceof RuleBreaker) {
            LivingEntity target = event.getEntityLiving();
            ItemStack stack = ((LivingEntity)e).func_184614_ca();
            if (!target.field_70170_p.field_72995_K && !EffectUtil.hasBuff(target, ModEffects.PROBABILITY_ALTER)) {
                EffectUtil.buff(target, ModEffects.PROBABILITY_ALTER, false, MTConfig.RULE_BREAKER_DURATION);
                int mod = RuleBreaker.getModulus(stack);
                int des = RuleBreaker.getDesignation(stack);
                ProbabilityAlterPotion.createProbabilityAlter(target, des, mod);
            }
        }
    }

    public static boolean hasModulus(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b(MODULUS_TAG);
    }

    public static boolean hasDesignation(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b(DESIGNATION_TAG);
    }

    public static void setModulus(ItemStack stack, int m) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74768_a(MODULUS_TAG, Math.max(2, m));
    }

    public static void setDesignation(ItemStack stack, int d) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74768_a(DESIGNATION_TAG, Math.floorMod(d, RuleBreaker.getModulus(stack)));
    }

    public static int getModulus(ItemStack stack) {
        if (RuleBreaker.hasModulus(stack)) {
            return stack.func_77978_p().func_74762_e(MODULUS_TAG);
        }
        return 2;
    }

    public static int getDesignation(ItemStack stack) {
        if (RuleBreaker.hasDesignation(stack)) {
            return stack.func_77978_p().func_74762_e(DESIGNATION_TAG);
        }
        return 0;
    }
}

