/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.handlers;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.FogProjector;
import stepsword.mahoutsukai.block.MahoujinProjector;
import stepsword.mahoutsukai.capability.chunks.ChunkMahouProvider;
import stepsword.mahoutsukai.capability.mahou.MahouProvider;
import stepsword.mahoutsukai.capability.mahou.ManaEvents;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.capability.settingsmahou.SettingsMahouProvider;
import stepsword.mahoutsukai.capability.worldsave.WorldMahouProvider;
import stepsword.mahoutsukai.commands.ModCommands;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.Kodoku;
import stepsword.mahoutsukai.effects.displacement.EquivalentDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.displacement.MentalDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.displacement.ProjectileDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.displacement.ProtectiveDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.exchange.DamageExchangeSpellEffect;
import stepsword.mahoutsukai.effects.familiar.FamiliarsGardenEffect;
import stepsword.mahoutsukai.effects.familiar.SummonFamiliarSpellEffect;
import stepsword.mahoutsukai.effects.mystic.DamageReplicationSpellEffect;
import stepsword.mahoutsukai.effects.mystic.RhoAiasSpellEffect;
import stepsword.mahoutsukai.effects.projection.ClarentEffect;
import stepsword.mahoutsukai.effects.projection.MorganEffect;
import stepsword.mahoutsukai.effects.projection.PowerConsolidationSpellEffect;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.effects.projection.RealityMarbleSpellEffect;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.effects.secret.GeasEffect;
import stepsword.mahoutsukai.entity.mahoujin.RhongomyniadEntity;
import stepsword.mahoutsukai.fluids.MurkyWaterBlock;
import stepsword.mahoutsukai.item.emrys.StaffEmrys;
import stepsword.mahoutsukai.item.replica.Replica;
import stepsword.mahoutsukai.item.rulebreaker.RuleBreaker;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.item.spells.secret.ripper.TheRipper;
import stepsword.mahoutsukai.potion.BindingEyesPotion;
import stepsword.mahoutsukai.potion.BlackFlameEyesPotion;
import stepsword.mahoutsukai.potion.BorrowedAuthorityPotion;
import stepsword.mahoutsukai.potion.BoundPotion;
import stepsword.mahoutsukai.potion.ClairvoyanceEyesPotion;
import stepsword.mahoutsukai.potion.ConfusionPotion;
import stepsword.mahoutsukai.potion.DeathCollectionEyesPotion;
import stepsword.mahoutsukai.potion.FaySightEyesPotion;
import stepsword.mahoutsukai.potion.FearPotion;
import stepsword.mahoutsukai.potion.FlungPotion;
import stepsword.mahoutsukai.potion.ForesightPotion;
import stepsword.mahoutsukai.potion.ImmunityExchangePotion;
import stepsword.mahoutsukai.potion.InsightEyesPotion;
import stepsword.mahoutsukai.potion.MisfortunePotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ProbabilityAlterPotion;
import stepsword.mahoutsukai.potion.ReversionEyesPotion;
import stepsword.mahoutsukai.potion.RipperInvisPotion;
import stepsword.mahoutsukai.potion.WoundedPotion;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;

public class ServerHandler {
    public static final ResourceLocation MAHOU = new ResourceLocation("mahoutsukai", "mahou");
    public static final ResourceLocation SETTINGS_MAHOU = new ResourceLocation("mahoutsukai", "mahou_settings");
    public static long tickCounter = 0L;

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(MAHOU, (ICapabilityProvider)new MahouProvider());
            event.addCapability(SETTINGS_MAHOU, (ICapabilityProvider)new SettingsMahouProvider());
        }
    }

    @SubscribeEvent
    public void attachCapabilityWorld(AttachCapabilitiesEvent<World> event) {
        if (event.getObject() instanceof World) {
            event.addCapability(MAHOU, (ICapabilityProvider)new WorldMahouProvider());
        }
    }

    @SubscribeEvent
    public void attachCapabilityChunk(AttachCapabilitiesEvent<Chunk> event) {
        if (event.getObject() instanceof Chunk) {
            event.addCapability(MAHOU, (ICapabilityProvider)new ChunkMahouProvider());
        }
    }

    @SubscribeEvent
    public void serverLoad(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void tickCheck(TickEvent.PlayerTickEvent event) {
        if (tickCounter % 10L == 0L && !event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            InsightEyesPotion.insightEyesPlayerTick(event.player);
            BorrowedAuthorityPotion.authorityPlayerTick(event.player);
            BindingEyesPotion.bindingEyesPlayerTick(event.player);
            ReversionEyesPotion.reversionEyesPlayerTick(event.player);
            ClairvoyanceEyesPotion.clairvoyanceEyesPlayerTick(event.player);
            FearPotion.fearPlayerTick(event.player);
            MorganEffect.secretCalibur(event.player);
        }
        if (tickCounter % 100L == 0L && !event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            PlayerManaManager.regenMana(event.player, false);
            MahouSettings.updateClientMahou((ServerPlayerEntity)event.player);
        }
        if (tickCounter % 4L == 0L && !event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            FaySightEyesPotion.faySightEyesPlayerTick(event.player);
        }
        if (tickCounter % (long)MTConfig.BLACK_FLAME_IGNITION_TICKS == 0L && !event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            BlackFlameEyesPotion.blackFlameEyesPlayerTick(event.player);
        }
        if (tickCounter % 100L == 0L && !(event.player.func_184607_cu().func_77973_b() instanceof MysticStaff)) {
            MahouTsukaiMod.proxy.speedUp();
        }
    }

    @SubscribeEvent
    public void playerJump(LivingEvent.LivingJumpEvent event) {
        BorrowedAuthorityPotion.authorityJump(event.getEntityLiving());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.world.field_72995_K) {
            tickCounter = event.world.func_82737_E() % 50000L;
        }
        PowerConsolidationSpellEffect.powerConsolidationWorldTick(event);
        MurkyWaterBlock.murkyUpdateTick(event);
        FogProjector.fogUpdateTick(event);
    }

    @SubscribeEvent
    public void livingEvent(LivingEvent.LivingUpdateEvent event) {
        ServerHandler.cancelEvent((Event)event, BindingEyesPotion.bindingEyesLivingUpdate(event.getEntityLiving()));
        BorrowedAuthorityPotion.authorityLivingUpdate(event.getEntityLiving());
        ReversionEyesPotion.reversionEyesLivingUpdate(event.getEntityLiving());
        BlackFlameEyesPotion.blackFlameEyesLivingUpdate(event.getEntityLiving());
        FearPotion.fearLivingUpdate(event.getEntityLiving());
        MentalDisplacementSpellEffect.mentalDisplacementLivingUpdate((Entity)event.getEntityLiving());
        FamiliarsGardenEffect.familiarsGardenLivingUpdate(event.getEntityLiving());
        MisfortunePotion.misfortuneLivingUpdate(event.getEntityLiving());
        ConfusionPotion.confusionLivingUpdate(event.getEntityLiving());
        WoundedPotion.woundedLivingTick(event.getEntityLiving());
        TheRipper.ripperLivingTick(event.getEntityLiving());
        RipperInvisPotion.presenceConcealmentLivingTick(event.getEntityLiving());
        FlungPotion.flungLivingTick(event.getEntityLiving());
        ProbabilityAlterPotion.applyProbabilityAlter(event.getEntityLiving());
    }

    @SubscribeEvent
    public void attackFromPlayer(AttackEntityEvent event) {
        boolean canceled = BoundPotion.boundAttackFromPlayer(event.getPlayer()) || FamiliarsGardenEffect.familiarsGardenAttackEntity(event.getTarget(), event.getPlayer()) || GeasEffect.geasAttackEntity(event);
        ServerHandler.cancelEvent((Event)event, canceled);
        ServerHandler.cancelEvent((Event)event, canceled);
        if (!canceled) {
            BorrowedAuthorityPotion.authorityAttackFromPlayer(event.getPlayer(), event.getTarget());
            StaffEmrys.emrysHit(event);
        }
    }

    @SubscribeEvent
    public void struckByLightning(EntityStruckByLightningEvent event) {
        StaffEmrys.emrysStruckByLightning(event);
    }

    @SubscribeEvent
    public void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ServerHandler.cancelEvent((Event)event, BoundPotion.boundLeftClickBlock(event.getPlayer()));
        PowerConsolidationSpellEffect.caliburnLeftClickBlock(event);
        BorrowedAuthorityPotion.borrowedAuthorityLeftClickBlock(event.getPlayer());
    }

    @SubscribeEvent
    public void placeEvent(BlockEvent.EntityPlaceEvent event) {
        ForesightPotion.butterflyPlaceBlock(event);
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ServerHandler.cancelEvent((Event)event, BoundPotion.boundRightClickBlock(event.getPlayer()));
        ManaEvents.rightClickCircle(event.getPlayer(), event.getPos());
        EquivalentDisplacementSpellEffect.equivalentDisplacementShiftRightClick(event);
        MahoujinProjector.projectorRightClick(event);
        FogProjector.fogProjectorRightClick(event);
    }

    @SubscribeEvent
    public void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        ServerHandler.cancelEvent((Event)event, BoundPotion.boundRightClickItem(event.getPlayer()));
        ClarentEffect.clarentOnRightClick(event.getPlayer());
    }

    @SubscribeEvent
    public void projectileImpact(ProjectileImpactEvent.Arrow event) {
        boolean z = ReversionEyesPotion.reversionEyesProjectileImpact(event.getEntity(), event.getRayTraceResult());
        ServerHandler.cancelEvent((Event)event, z);
        if (!z) {
            ServerHandler.cancelEvent((Event)event, ProtectiveDisplacementSpellEffect.protectiveDisplacementProjectileImpact((ProjectileImpactEvent)event));
        }
    }

    @SubscribeEvent
    public void potionFinish(PotionEvent.PotionRemoveEvent event) {
        if (event.getPotion() == ModEffects.BLACK_FLAME_EYES) {
            BlackFlameEyesPotion.blackFlameEyesPotionFinish(event.getEntityLiving());
        }
        if (event.getPotion() == ModEffects.MISFORTUNE) {
            Kodoku.kodokuPotionRemove(event);
        }
    }

    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking event) {
        Entity e = event.getTarget();
        if (e instanceof LivingEntity) {
            ReversionEyesPotion.notifyIfReverted((LivingEntity)e);
            BlackFlameEyesPotion.notifyIfBurning((LivingEntity)e);
            RipperInvisPotion.notifyIfInvisible((LivingEntity)e);
        }
    }

    @SubscribeEvent
    public void livingUse(LivingEntityUseItemEvent.Stop event) {
        StrengtheningSpellEffect.strengtheningUseEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void highPriorityLivingDeath(LivingDeathEvent event) {
        boolean cancels = DeathCollectionEyesPotion.deathCollectionEyesLivingDeath(event.getEntityLiving(), event.getSource());
        ServerHandler.cancelEvent((Event)event, cancels);
        DamageReplicationSpellEffect.damageReplicationLivingDeath((Entity)event.getEntityLiving());
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        MorganEffect.morganLivingDeath(event);
        Kodoku.kodokuEntityDeath(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void highPriorityLivingHurt(LivingHurtEvent event) {
        boolean cancels = ImmunityExchangePotion.immunityExchangeLivingHurt(event) || GeasEffect.geasLivingHurt(event) || Replica.replicaLivingHurt(event);
        ServerHandler.cancelEvent((Event)event, cancels);
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent event) {
        if (!event.isCanceled()) {
            StrengtheningSpellEffect.strengtheningLivingHurt(event);
            RealityMarbleSpellEffect.realityMarbleLivingHurt(event.getEntity());
            ManaEvents.manaPlayerHurt(event.getEntityLiving(), event.getAmount());
            StaffEmrys.emrysLivingHurt(event);
            ClarentEffect.clarentLivingHurt(event);
            RhongomyniadEntity.rhongomyniadLivingHurt(event);
            TheRipper.ripperOnHit(event);
            DamageExchangeSpellEffect.damageExchangeLivingHurt(event);
            RuleBreaker.ruleBreakerLivingHurt(event);
        }
    }

    @SubscribeEvent
    public void anvilRepair(AnvilRepairEvent event) {
        ProjectionSpellEffect.projectionRepairAnvil(event);
    }

    @SubscribeEvent
    public void anvilUpdate(AnvilUpdateEvent event) {
        ProjectionSpellEffect.projectionUpdateAnvil(event);
    }

    @SubscribeEvent
    public void livingAttack(LivingAttackEvent event) {
        ClarentEffect.clarentLivingAttack(event);
        Replica.replicaLivingAttack(event);
        StrengtheningSpellEffect.strengtheningArmorEvent(event);
    }

    @SubscribeEvent
    public void harvestCheck(PlayerEvent.HarvestCheck event) {
        StrengtheningSpellEffect.strengtheningHarvestCheck(event);
    }

    @SubscribeEvent
    public void breakEvent(BlockEvent.BreakEvent event) {
        StrengtheningSpellEffect.strengtheningBreakEvent(event);
        MisfortunePotion.misfortuneBreakEvent(event);
        ForesightPotion.butterflyBreakBlock(event);
        Replica.replicaBreakBlock(event);
    }

    @SubscribeEvent
    public void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        StrengtheningSpellEffect.strengtheningBreakSpeed(event);
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload event) {
        RealityMarbleSpellEffect.realityMarbleChunkUnload(event);
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        RealityMarbleSpellEffect.realityMarbleChunkLoad(event);
        PowerConsolidationSpellEffect.powerConsolidationChunkLoad(event);
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        ServerHandler.cancelEvent((Event)event, RealityMarbleSpellEffect.realityMarbleLivingFall(event));
    }

    @SubscribeEvent
    public void entityJoinWorldEvent(EntityJoinWorldEvent event) {
        ProjectileDisplacementSpellEffect.projectileDisplacementJoinWorld(event.getEntity());
    }

    @SubscribeEvent
    public void explosionEvent(ExplosionEvent.Start event) {
        FamiliarsGardenEffect.familiarsGardenExplosion(event.getExplosion().func_94613_c());
    }

    @SubscribeEvent
    public void explosionEvent(ExplosionEvent.Detonate event) {
        RhoAiasSpellEffect.rhoAiasExplosionProtection(event);
        Replica.replicaExplosionProtection(event);
    }

    @SubscribeEvent
    public void livingDamageEvent(LivingDamageEvent event) {
        ServerHandler.cancelEvent((Event)event, FamiliarsGardenEffect.familiarsGardenLivingDamage(event));
        DamageReplicationSpellEffect.damageReplicationLivingDamage(event);
        ContractMahoujinTileEntity.breakContract(event);
    }

    @SubscribeEvent
    public void rightClickEntity(PlayerInteractEvent.EntityInteract event) {
        SummonFamiliarSpellEffect.familiarRightClick(event);
        RhongomyniadEntity.rhongomyniadRightClick(event);
    }

    @SubscribeEvent
    public void useItem(LivingEntityUseItemEvent.Finish event) {
        ManaEvents.drinkMilk(event);
    }

    @SubscribeEvent
    public void useItem(EntityItemPickupEvent event) {
        ServerHandler.cancelEvent((Event)event, GeasEffect.geasItem(event));
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        ManaEvents.mahouClone(event);
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ManaEvents.mahouLogin(event.getPlayer());
    }

    @SubscribeEvent
    public void playerSlept(PlayerWakeUpEvent event) {
        if (!event.wakeImmediately() && !event.updateWorld()) {
            ManaEvents.mahouSleep(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void potionAdded(PotionEvent.PotionAddedEvent event) {
        DamageReplicationSpellEffect.damageReplicationPotionAdded(event);
    }

    @SubscribeEvent
    public void setTargetEvent(LivingSetAttackTargetEvent event) {
        ServerHandler.cancelEvent((Event)event, FearPotion.fearLivingSetAttack(event.getEntityLiving(), event.getTarget()));
    }

    @SubscribeEvent
    public void livingDrops(LivingDropsEvent event) {
        MisfortunePotion.misfortuneLootEvent(event);
    }

    public static void cancelEvent(Event e, boolean c) {
        if (e.isCancelable() && !e.isCanceled()) {
            e.setCanceled(c);
        }
    }
}

