/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;

public class ReplicaTeleportMahoujinEntity
extends Entity {
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_GOAL_X = "MAHOUTSUKAI_GOAL_X";
    private static final String TAG_GOAL_Y = "MAHOUTSUKAI_GOAL_Y";
    private static final String TAG_GOAL_Z = "MAHOUTSUKAI_GOAL_Z";
    private static final String TAG_GOAL_DIM = "MAHOUTSUKAI_GOAL_DIM";
    private static final String TAG_FRIENDLY_ONLY = "MAHOUTSUKAI_FRIENDLY_ONLY";
    public static final AxisAlignedBB bb = new AxisAlignedBB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final AxisAlignedBB ZERO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final DataParameter<Float> CIRCLE_SIZE = EntityDataManager.func_187226_a(ReplicaTeleportMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(ReplicaTeleportMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> COLOR_R = EntityDataManager.func_187226_a(ReplicaTeleportMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G = EntityDataManager.func_187226_a(ReplicaTeleportMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B = EntityDataManager.func_187226_a(ReplicaTeleportMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_A = EntityDataManager.func_187226_a(ReplicaTeleportMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> GOAL_X = EntityDataManager.func_187226_a(ReplicaTeleportMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> GOAL_Y = EntityDataManager.func_187226_a(ReplicaTeleportMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> GOAL_Z = EntityDataManager.func_187226_a(ReplicaTeleportMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<String> GOAL_DIM = EntityDataManager.func_187226_a(ReplicaTeleportMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> FRIENDLY_ONLY = EntityDataManager.func_187226_a(ReplicaTeleportMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int casterUUID = 0;
    public boolean doTeleport = true;
    public static final String entityName = "replica_teleport_mahoujin_entity";

    public ReplicaTeleportMahoujinEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.REPLICA_TELEPORT, worldIn);
        this.field_70158_ak = true;
    }

    public ReplicaTeleportMahoujinEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public ReplicaTeleportMahoujinEntity(World world) {
        super(ModEntities.REPLICA_TELEPORT, world);
        this.field_70158_ak = true;
    }

    public ReplicaTeleportMahoujinEntity(World world, LivingEntity caster, float r, float g, float b, float a, ResourceLocation dim, Vector3d goal, boolean friendly) {
        this(world);
        this.casterUUID = caster.func_145782_y();
        this.setColor(r, g, b, a);
        this.setGoal(goal);
        this.setGoalDim(dim);
        this.setFriendlyOnly(friendly);
        this.sizer(0.0f);
    }

    public ReplicaTeleportMahoujinEntity(World world, LivingEntity caster, float r, float g, float b, float a, ResourceLocation dim, Vector3d goal, boolean friendly, boolean doTeleport) {
        this(world, caster, r, g, b, a, dim, goal, friendly);
        this.doTeleport = doTeleport;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LIFE, (Object)0);
        this.field_70180_af.func_187214_a(COLOR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(GOAL_X, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(GOAL_Y, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(GOAL_Z, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_A, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(GOAL_DIM, (Object)"minecraft:overworld");
        this.field_70180_af.func_187214_a(FRIENDLY_ONLY, (Object)true);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int teleportStart = MTConfig.REPLICA_TELEPORT_START_TELEPORTING;
        int teleportEnd = MTConfig.REPLICA_TELEPORT_STOP_TELEPORTING;
        int dieTime = MTConfig.REPLICA_TELEPORT_LIFE;
        float maxRadius = (float)MTConfig.REPLICA_TELEPORT_FRIEND_RANGE;
        this.func_213293_j(0.0, 0.0, 0.0);
        if (!this.field_70170_p.field_72995_K) {
            this.setLife(this.getLife() + 1);
            Entity caster = this.field_70170_p.func_73045_a(this.casterUUID);
            if (caster == null || !caster.func_70089_S()) {
                this.func_70106_y();
            }
            if (this.getLife() < teleportStart && this.getCircleSize() < maxRadius) {
                this.setCircleSize(this.getCircleSize() + 2.0f * maxRadius / (float)teleportStart);
            }
            if (this.getLife() >= teleportStart && this.getLife() < teleportEnd && this.doTeleport) {
                AxisAlignedBB aabb = new AxisAlignedBB(this.func_226277_ct_() - (double)maxRadius, this.func_226278_cu_() - (double)maxRadius, this.func_226281_cx_() - (double)maxRadius, this.func_226277_ct_() + (double)maxRadius, this.func_226278_cu_() + (double)maxRadius, this.func_226281_cx_() + (double)maxRadius);
                List entities = this.field_70170_p.func_217357_a(Entity.class, aabb);
                Vector3d goal = this.getGoal();
                ResourceLocation res = this.getGoalDim();
                boolean teleportAll = this.getFriendlyOnly();
                for (Entity e : entities) {
                    if (!(e instanceof ItemEntity) && (!(e instanceof LivingEntity) || !teleportAll && !ContractMahoujinTileEntity.isImmuneToSpell(this.field_70170_p, caster.func_110124_au(), e)) || !(e.func_213303_ch().func_72436_e(this.func_213303_ch()) < (double)(maxRadius * maxRadius))) continue;
                    MahouTsukaiTeleporter.teleport(e, goal.field_72450_a, goal.field_72448_b, goal.field_72449_c, res);
                }
            }
            if (this.getLife() > teleportEnd && this.getLife() < dieTime) {
                this.setCircleSize(Math.max(0.0f, this.getCircleSize() - 2.0f * maxRadius / (float)(dieTime - teleportEnd)));
            }
            if (this.getLife() >= dieTime) {
                this.func_70106_y();
            }
        } else {
            MahouTsukaiMod.proxy.spawnReplicaTeleportParticles(this);
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public void setColor(float r, float g, float b, float a) {
        this.field_70180_af.func_187227_b(COLOR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(COLOR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(COLOR_B, (Object)Float.valueOf(b));
        this.field_70180_af.func_187227_b(COLOR_A, (Object)Float.valueOf(a));
    }

    public void setGoal(Vector3d vec) {
        this.field_70180_af.func_187227_b(GOAL_X, (Object)Float.valueOf((float)vec.field_72450_a));
        this.field_70180_af.func_187227_b(GOAL_Y, (Object)Float.valueOf((float)vec.field_72448_b));
        this.field_70180_af.func_187227_b(GOAL_Z, (Object)Float.valueOf((float)vec.field_72449_c));
    }

    public Vector3d getGoal() {
        return new Vector3d((double)((Float)this.field_70180_af.func_187225_a(GOAL_X)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(GOAL_Y)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(GOAL_Z)).floatValue());
    }

    public void setFriendlyOnly(boolean b) {
        this.field_70180_af.func_187227_b(FRIENDLY_ONLY, (Object)b);
    }

    public boolean getFriendlyOnly() {
        return (Boolean)this.field_70180_af.func_187225_a(FRIENDLY_ONLY);
    }

    protected void func_145775_I() {
    }

    @Nullable
    public AxisAlignedBB func_174813_aQ() {
        return ZERO_AABB;
    }

    public float[] getColor() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(COLOR_R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_A)).floatValue()};
    }

    public void sizer(float s) {
        this.setCircleSize(s);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setCircleSize(compound.func_74760_g(TAG_CIRCLE_SIZE));
        this.setLife(compound.func_74762_e(TAG_LIFE));
        this.setColor(compound.func_74760_g(TAG_COLOR_R), compound.func_74760_g(TAG_COLOR_G), compound.func_74760_g(TAG_COLOR_B), compound.func_74760_g(TAG_COLOR_A));
        this.setGoal(new Vector3d((double)compound.func_74760_g(TAG_GOAL_X), (double)compound.func_74760_g(TAG_GOAL_Y), (double)compound.func_74760_g(TAG_GOAL_Z)));
        this.setGoalDim(new ResourceLocation(compound.func_74779_i(TAG_GOAL_DIM)));
        this.setFriendlyOnly(compound.func_74767_n(TAG_FRIENDLY_ONLY));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.func_74768_a(TAG_LIFE, this.getLife());
        float[] colors = this.getColor();
        compound.func_74776_a(TAG_COLOR_R, colors[0]);
        compound.func_74776_a(TAG_COLOR_G, colors[1]);
        compound.func_74776_a(TAG_COLOR_B, colors[2]);
        compound.func_74776_a(TAG_COLOR_A, colors[3]);
        Vector3d goal = this.getGoal();
        compound.func_74776_a(TAG_GOAL_X, (float)goal.field_72450_a);
        compound.func_74776_a(TAG_GOAL_Y, (float)goal.field_72448_b);
        compound.func_74776_a(TAG_GOAL_Z, (float)goal.field_72449_c);
        compound.func_74778_a(TAG_GOAL_DIM, this.getGoalDim().toString());
        compound.func_74757_a(TAG_FRIENDLY_ONLY, this.getFriendlyOnly());
    }

    public AxisAlignedBB func_184177_bl() {
        return bb;
    }

    public ResourceLocation getGoalDim() {
        return new ResourceLocation((String)this.field_70180_af.func_187225_a(GOAL_DIM));
    }

    public void setGoalDim(ResourceLocation dim) {
        this.field_70180_af.func_187227_b(GOAL_DIM, (Object)dim.toString());
    }

    public float getCircleSize() {
        return ((Float)this.field_70180_af.func_187225_a(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.field_70180_af.func_187227_b(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public void setLife(int l) {
        this.field_70180_af.func_187227_b(LIFE, (Object)l);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

