/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.item.spells.secret.GandrSpellScroll;
import stepsword.mahoutsukai.networking.MagicCircleBoomParticlePacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;

public class GandrEntity
extends Entity {
    public static final String entityName = "gandr_entity";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_FIRED = "MAHOUTSUKAI_FIRED";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(GandrEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> CASTER_UUID = EntityDataManager.func_187226_a(GandrEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> FIRED = EntityDataManager.func_187226_a(GandrEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> COLOR_R = EntityDataManager.func_187226_a(GandrEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G = EntityDataManager.func_187226_a(GandrEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B = EntityDataManager.func_187226_a(GandrEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_R2 = EntityDataManager.func_187226_a(GandrEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G2 = EntityDataManager.func_187226_a(GandrEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B2 = EntityDataManager.func_187226_a(GandrEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_A = EntityDataManager.func_187226_a(GandrEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public ArrayList<EffectInstance> effects = new ArrayList();
    public float damage = 0.0f;
    public int swirls = 100;
    public float[] progressstarts = new float[this.swirls];
    public float[] progressends = new float[this.swirls];
    public float[] angles = new float[this.swirls];
    public boolean inited = false;
    public float swirlLife = 9.0f;
    public int firedProgressLife = 3;
    public int ticksSinceFired = 0;
    public long timeCreated = -1L;

    public GandrEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.GANDR, worldIn);
        this.field_70158_ak = true;
    }

    public GandrEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public GandrEntity(World world) {
        super(ModEntities.GANDR, world);
        this.field_70158_ak = true;
    }

    public GandrEntity(World world, LivingEntity caster, float r, float g, float b, float a, float r2, float g2, float b2) {
        this(world);
        this.setCasterUUID(caster.func_110124_au());
        this.setColor(r, g, b, a, r2, g2, b2);
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2) {
        this.field_70180_af.func_187227_b(COLOR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(COLOR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(COLOR_B, (Object)Float.valueOf(b));
        this.field_70180_af.func_187227_b(COLOR_R2, (Object)Float.valueOf(r2));
        this.field_70180_af.func_187227_b(COLOR_G2, (Object)Float.valueOf(g2));
        this.field_70180_af.func_187227_b(COLOR_B2, (Object)Float.valueOf(b2));
        this.field_70180_af.func_187227_b(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getColor() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(COLOR_R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_A)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_R2)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G2)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B2)).floatValue()};
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(LIFE, (Object)0);
        this.field_70180_af.func_187214_a(CASTER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(FIRED, (Object)false);
        this.field_70180_af.func_187214_a(COLOR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_R2, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G2, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B2, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_A, (Object)Float.valueOf(1.0f));
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setLife(compound.func_74762_e(TAG_LIFE));
        this.setFired(compound.func_74767_n(TAG_FIRED));
        if (compound.func_186855_b(TAG_CASTER)) {
            this.setCasterUUID(compound.func_186857_a(TAG_CASTER));
        }
        this.setColor(compound.func_74760_g(TAG_COLOR_R), compound.func_74760_g(TAG_COLOR_G), compound.func_74760_g(TAG_COLOR_B), compound.func_74760_g(TAG_COLOR_A), compound.func_74760_g(TAG_COLOR_R2), compound.func_74760_g(TAG_COLOR_G2), compound.func_74760_g(TAG_COLOR_B2));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a(TAG_LIFE, this.getLife());
        compound.func_74757_a(TAG_FIRED, this.getFired());
        if (this.getCasterUUID() != null) {
            compound.func_186854_a(TAG_CASTER, this.getCasterUUID());
        }
        float[] colors = this.getColor();
        compound.func_74776_a(TAG_COLOR_R, colors[0]);
        compound.func_74776_a(TAG_COLOR_G, colors[1]);
        compound.func_74776_a(TAG_COLOR_B, colors[2]);
        compound.func_74776_a(TAG_COLOR_A, colors[3]);
        compound.func_74776_a(TAG_COLOR_R2, colors[4]);
        compound.func_74776_a(TAG_COLOR_G2, colors[5]);
        compound.func_74776_a(TAG_COLOR_B2, colors[6]);
    }

    public float getGrowingLife() {
        return 15.0f;
    }

    public void func_70071_h_() {
        PlayerEntity player;
        if (this.timeCreated == -1L) {
            this.timeCreated = this.field_70170_p.func_82737_E();
        }
        this.setLife(this.getLife() + 1);
        if (this.field_70170_p.field_72995_K) {
            if (!this.inited) {
                for (int i = 0; i < this.swirls; ++i) {
                    this.progressstarts[i] = (float)i * 1.0f / (float)this.swirls;
                    this.progressends[i] = this.progressstarts[i] + this.swirlLife / 100.0f;
                    this.angles[i] = this.field_70146_Z.nextFloat() * 360.0f;
                    if (!(this.progressends[i] > 1.0f)) continue;
                    int n = i;
                    this.progressends[n] = this.progressends[n] - 1.0f;
                }
                this.inited = true;
            }
        } else {
            if (this.ticksSinceFired > 800 || this.field_70170_p.func_82737_E() - this.timeCreated > 6000L) {
                this.func_70106_y();
            }
            PlayerEntity player2 = this.field_70170_p.func_217371_b(this.getCasterUUID());
            if (!(this.getFired() || player2 != null && (player2.func_184607_cu().func_77973_b() instanceof GandrSpellScroll || player2.func_184607_cu().func_77973_b() instanceof MysticCode))) {
                this.func_70106_y();
            }
        }
        if (this.getFired()) {
            ++this.ticksSinceFired;
            if (this.field_70170_p.field_72995_K) {
                MahouTsukaiMod.proxy.spawnGandrParticle(this);
            } else {
                this.checkHit();
            }
        }
        if (this.getCasterUUID() != null && !this.getFired() && (player = this.field_70170_p.func_217371_b(this.getCasterUUID())) != null) {
            this.setLookPos(player.field_70170_p.field_72995_K, (LivingEntity)player, this);
        }
        this.func_70634_a(this.func_226277_ct_() + this.func_213322_ci().field_72450_a, this.func_226278_cu_() + this.func_213322_ci().field_72448_b, this.func_226281_cx_() + this.func_213322_ci().field_72449_c);
    }

    public void checkHit() {
        Vector3d vec3d3;
        Vector3d vec3d = this.func_213322_ci();
        Vector3d vec3d2 = this.func_213303_ch();
        BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d2, vec3d3 = vec3d2.func_178787_e(vec3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            vec3d3 = raytraceresult.func_216347_e();
        }
        while (!this.field_70128_L) {
            EntityRayTraceResult entityraytraceresult = this.rayTraceEntities(vec3d2, vec3d3);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY && raytraceresult instanceof EntityRayTraceResult) {
                Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                Entity entity1 = this.getShooter();
                if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity) && !ContractMahoujinTileEntity.isImmuneToSpell(this.field_70170_p, this.getCasterUUID(), entity)) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                }
            }
            if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onHit((RayTraceResult)raytraceresult);
            }
            if (entityraytraceresult == null) break;
            raytraceresult = null;
        }
    }

    public void onHit(RayTraceResult result) {
        Vector3d look = this.func_70676_i(1.0f);
        int black_particles = MTConfig.GANDR_BLACK_PARTICLES_HIT;
        int red_particles = MTConfig.GANDR_RED_PARTICLES_HIT;
        float radius = (float)MTConfig.GANDR_HIT_RADIUS;
        int duration = MTConfig.GANDR_CLOUD_DURATION;
        AreaEffectCloudEntity area = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        boolean spawn = false;
        if (this.getShooter() instanceof LivingEntity) {
            area.func_184482_a(0xFF0000);
            area.func_184483_a(radius);
            area.func_184481_a((LivingEntity)this.getShooter());
            area.func_184486_b(duration);
            for (EffectInstance e : this.effects) {
                if (!GandrEntity.validEffect(e)) continue;
                spawn = true;
                area.func_184496_a(e);
            }
        }
        if (spawn) {
            this.field_70170_p.func_217376_c((Entity)area);
        }
        AxisAlignedBB aabb = new AxisAlignedBB(this.func_226277_ct_() - (double)radius, this.func_226278_cu_() - (double)radius, this.func_226281_cx_() - (double)radius, this.func_226277_ct_() + (double)radius, this.func_226278_cu_() + (double)radius, this.func_226281_cx_() + (double)radius);
        List entities = this.field_70170_p.func_175674_a(this.getShooter(), aabb, null);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || ContractMahoujinTileEntity.isImmuneToSpell(this.field_70170_p, this.getCasterUUID(), entity)) continue;
            EffectUtil.magicAttack((LivingEntity)entity, this.damage, (LivingEntity)this.field_70170_p.func_217371_b(this.getCasterUUID()));
            if (entity.func_70089_S() && !(((LivingEntity)entity).func_110143_aJ() <= 0.0f) || !(this.getShooter() instanceof ServerPlayerEntity)) continue;
            ModTriggers.GANDR.trigger((ServerPlayerEntity)this.getShooter());
        }
        float[] rgbs = this.getColor();
        PacketHandler.sendTracking(this, new MagicCircleBoomParticlePacket(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), look.field_72450_a, look.field_72448_b, look.field_72449_c, 2.0, 1, 1, black_particles, true, true, rgbs[0], rgbs[1], rgbs[2], rgbs[4], rgbs[5], rgbs[6]));
        PacketHandler.sendTracking(this, new MagicCircleBoomParticlePacket(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), look.field_72450_a, look.field_72448_b, look.field_72449_c, 2.0, 0, 1, red_particles, true, true, rgbs[0], rgbs[1], rgbs[2], rgbs[4], rgbs[5], rgbs[6]));
        this.func_70106_y();
    }

    public static boolean validEffect(EffectInstance e) {
        Effect effect = e.func_188419_a();
        boolean inwhitelist = false;
        for (String string : MTConfig.GANDR_EFFECT_WHITELIST) {
            if (!string.equals(e.func_188419_a().getRegistryName().toString())) continue;
            inwhitelist = true;
        }
        boolean inblacklist = false;
        for (String string : MTConfig.GANDR_EFFECT_BLACKLIST) {
            if (!string.equals(e.func_188419_a().getRegistryName().toString())) continue;
            inblacklist = true;
        }
        return inwhitelist || !inblacklist && effect.func_220303_e() == EffectType.HARMFUL;
    }

    @Nullable
    public Entity getShooter() {
        return this.getCasterUUID() != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.getCasterUUID()) : null;
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vector3d startVec, Vector3d endVec) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213871_1_ -> !p_213871_1_.func_175149_v() && p_213871_1_.func_70089_S() && p_213871_1_.func_70067_L() && (!p_213871_1_.func_110124_au().equals(this.getCasterUUID()) || this.ticksSinceFired >= 5));
    }

    public Vector3d setLookPos(boolean client, LivingEntity caster, GandrEntity gandr) {
        Vector3d look = caster.func_70676_i(1.0f);
        Vector3d oldlook = look.func_72432_b();
        look = oldlook.func_186678_a((double)1.1f);
        Vector3d start = look.func_178787_e(caster.func_174824_e(1.0f));
        gandr.field_70177_z = caster.field_70177_z;
        gandr.field_70125_A = caster.field_70125_A;
        if (!client) {
            gandr.func_70107_b(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        }
        return start;
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public void setLife(int l) {
        this.field_70180_af.func_187227_b(LIFE, (Object)l);
    }

    public UUID getCasterUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(uuid));
    }

    public boolean getFired() {
        return (Boolean)this.field_70180_af.func_187225_a(FIRED);
    }

    public void setFired(boolean f) {
        this.field_70180_af.func_187227_b(FIRED, (Object)f);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

