/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.Bakuretsu;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.networking.BakuretsuPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class BeamProjectileEntity
extends Entity {
    public static final String entityName = "beam_projectile_entity";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_FIRED = "MAHOUTSUKAI_FIRED";
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_COLOR_A2 = "MAHOUTSUKAI_COLOR_A2";
    private static final String TAG_RADIUS = "MAHOUTSUKAI_RADIUS";
    private static final String TAG_LENGTH = "MAHOUTSUKAI_LENGTH";
    private static final DataParameter<Float> ROTATION_YAW = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_ROLL = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_PITCH = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> CASTER_UUID = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> FIRED = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> COLOR_R = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_R2 = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G2 = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B2 = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_A = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_A2 = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> LENGTH = EntityDataManager.func_187226_a(BeamProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public ArrayList<EffectInstance> effects = new ArrayList();
    public float damage = 0.0f;
    public int ticksSinceFired = 0;
    public long timeCreated = -1L;

    public BeamProjectileEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.BEAM_PROJECTILE, worldIn);
        this.field_70158_ak = true;
    }

    public BeamProjectileEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public BeamProjectileEntity(World world) {
        super(ModEntities.BEAM_PROJECTILE, world);
        this.field_70158_ak = true;
    }

    public BeamProjectileEntity(World world, UUID caster, float r, float g, float b, float a, float r2, float g2, float b2, float a2, float radius, float length) {
        this(world);
        this.setCasterUUID(caster);
        this.setColor(r, g, b, a, r2, g2, b2, a2);
        this.setRadius(radius);
        this.setLength(length);
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2, float a2) {
        this.field_70180_af.func_187227_b(COLOR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(COLOR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(COLOR_B, (Object)Float.valueOf(b));
        this.field_70180_af.func_187227_b(COLOR_R2, (Object)Float.valueOf(r2));
        this.field_70180_af.func_187227_b(COLOR_G2, (Object)Float.valueOf(g2));
        this.field_70180_af.func_187227_b(COLOR_B2, (Object)Float.valueOf(b2));
        this.field_70180_af.func_187227_b(COLOR_A, (Object)Float.valueOf(a));
        this.field_70180_af.func_187227_b(COLOR_A2, (Object)Float.valueOf(a2));
    }

    public float[] getColor() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(COLOR_R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_A)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_R2)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G2)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B2)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_A2)).floatValue()};
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LIFE, (Object)0);
        this.field_70180_af.func_187214_a(CASTER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(FIRED, (Object)false);
        this.field_70180_af.func_187214_a(COLOR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(COLOR_B, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(COLOR_R2, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G2, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B2, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_A, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_A2, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(RADIUS, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(LENGTH, (Object)Float.valueOf(1.0f));
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setLife(compound.func_74762_e(TAG_LIFE));
        this.setFired(compound.func_74767_n(TAG_FIRED));
        if (compound.func_186855_b(TAG_CASTER)) {
            this.setCasterUUID(compound.func_186857_a(TAG_CASTER));
        }
        this.setColor(compound.func_74760_g(TAG_COLOR_R), compound.func_74760_g(TAG_COLOR_G), compound.func_74760_g(TAG_COLOR_B), compound.func_74760_g(TAG_COLOR_A), compound.func_74760_g(TAG_COLOR_R2), compound.func_74760_g(TAG_COLOR_G2), compound.func_74760_g(TAG_COLOR_B2), compound.func_74760_g(TAG_COLOR_A2));
        this.setLength(compound.func_74760_g(TAG_LENGTH));
        this.setRadius(compound.func_74760_g(TAG_RADIUS));
        this.setRotationYaw(compound.func_74760_g(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.func_74760_g(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.func_74760_g(TAG_ROTATION_PITCH));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a(TAG_LIFE, this.getLife());
        compound.func_74757_a(TAG_FIRED, this.getFired());
        if (this.getCasterUUID() != null) {
            compound.func_186854_a(TAG_CASTER, this.getCasterUUID());
        }
        float[] colors = this.getColor();
        compound.func_74776_a(TAG_COLOR_R, colors[0]);
        compound.func_74776_a(TAG_COLOR_G, colors[1]);
        compound.func_74776_a(TAG_COLOR_B, colors[2]);
        compound.func_74776_a(TAG_COLOR_A, colors[3]);
        compound.func_74776_a(TAG_COLOR_R2, colors[4]);
        compound.func_74776_a(TAG_COLOR_G2, colors[5]);
        compound.func_74776_a(TAG_COLOR_B2, colors[6]);
        compound.func_74776_a(TAG_COLOR_A2, colors[7]);
        compound.func_74776_a(TAG_LENGTH, this.getLength());
        compound.func_74776_a(TAG_RADIUS, this.getRadius());
        compound.func_74776_a(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.func_74776_a(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.func_74776_a(TAG_ROTATION_PITCH, this.getRotationPitch());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.timeCreated == -1L) {
            this.timeCreated = this.field_70170_p.func_82737_E();
        }
        this.setLife(this.getLife() + 1);
        if (!(this.field_70170_p.field_72995_K || this.ticksSinceFired <= 400 && this.field_70170_p.func_82737_E() - this.timeCreated <= 800L)) {
            this.func_70106_y();
        }
        ++this.ticksSinceFired;
        if (!this.field_70170_p.field_72995_K) {
            this.setLength((float)Math.min(3.0, (double)this.getLength() + this.func_213322_ci().func_72433_c() / 5.0));
            this.checkHit();
        }
        this.func_70634_a(this.func_226277_ct_() + this.func_213322_ci().field_72450_a, this.func_226278_cu_() + this.func_213322_ci().field_72448_b, this.func_226281_cx_() + this.func_213322_ci().field_72449_c);
    }

    public void checkHit() {
        EntityRayTraceResult entityraytraceresult;
        Vector3d vec3d3;
        Vector3d vec3d = this.func_213322_ci();
        Vector3d vec3d2 = this.func_213303_ch();
        BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d2, vec3d3 = vec3d2.func_178787_e(vec3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            vec3d3 = raytraceresult.func_216347_e();
        }
        if ((entityraytraceresult = this.rayTraceEntities(vec3d2, vec3d3)) != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY && raytraceresult instanceof EntityRayTraceResult) {
            Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
            Entity entity1 = this.getShooter();
            if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity) && !ContractMahoujinTileEntity.isImmuneToSpell(this.field_70170_p, this.getCasterUUID(), entity)) {
                raytraceresult = null;
                entityraytraceresult = null;
            }
        }
        if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.onHit((RayTraceResult)raytraceresult);
        }
        raytraceresult = null;
    }

    public void onHit(RayTraceResult result) {
        Vector3d target = result.func_216347_e();
        double x = target.field_72450_a;
        double y = target.field_72448_b;
        double z = target.field_72449_c;
        PlayerEntity caster = this.field_70170_p.func_217371_b(this.getCasterUUID());
        if (caster != null) {
            int radius = MTConfig.MYSTIC_STAFF_AOE_SIZE;
            Bakuretsu explosion = new Bakuretsu(radius, (float)x, (float)y, (float)z, MysticStaff.getExplosionDamage(true, Utils.getPlayerMahou((LivingEntity)caster)));
            explosion.explosionA(this.field_70170_p, caster);
            for (PlayerEntity entityplayer : this.field_70170_p.func_217369_A()) {
                if (!(entityplayer.func_70092_e(x, y, z) < 16384.0)) continue;
                Vector3d vec = null;
                if (explosion.knockback.containsKey(caster)) {
                    vec = explosion.knockback.get(caster);
                }
                if (vec == null) {
                    PacketHandler.sendTo((ServerPlayerEntity)caster, new BakuretsuPacket(x, y, z, radius, 0.0f, 0.0f, 0.0f));
                    continue;
                }
                PacketHandler.sendTo((ServerPlayerEntity)caster, new BakuretsuPacket(x, y, z, radius, (float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c));
            }
        }
        this.func_70106_y();
    }

    public Vector3d setLookPos(boolean client, Entity caster, boolean add) {
        Vector3d look = caster.func_70040_Z();
        Vector3d oldlook = look.func_72432_b();
        look = oldlook.func_186678_a((double)1.1f);
        Vector3d start = look.func_178787_e(caster.func_213303_ch());
        this.field_70177_z = caster.field_70177_z;
        this.field_70125_A = caster.field_70125_A;
        if (add) {
            this.field_70125_A = 90.0f - this.field_70125_A;
        }
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        if (!client && add) {
            this.func_70107_b(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        }
        return start;
    }

    @Nullable
    public Entity getShooter() {
        return this.getCasterUUID() != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.getCasterUUID()) : null;
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vector3d startVec, Vector3d endVec) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213871_1_ -> !p_213871_1_.func_175149_v() && p_213871_1_.func_70089_S() && p_213871_1_.func_70067_L() && !(p_213871_1_ instanceof BeamProjectileEntity) && (!p_213871_1_.func_110124_au().equals(this.getCasterUUID()) || this.ticksSinceFired >= 5));
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public void setLife(int l) {
        this.field_70180_af.func_187227_b(LIFE, (Object)l);
    }

    public UUID getCasterUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(uuid));
    }

    public boolean getFired() {
        return (Boolean)this.field_70180_af.func_187225_a(FIRED);
    }

    public void setFired(boolean f) {
        this.field_70180_af.func_187227_b(FIRED, (Object)f);
    }

    public float getLength() {
        return ((Float)this.field_70180_af.func_187225_a(LENGTH)).floatValue();
    }

    public void setLength(float f) {
        this.field_70180_af.func_187227_b(LENGTH, (Object)Float.valueOf(f));
    }

    public float getRadius() {
        return ((Float)this.field_70180_af.func_187225_a(RADIUS)).floatValue();
    }

    public void setRadius(float f) {
        this.field_70180_af.func_187227_b(RADIUS, (Object)Float.valueOf(f));
    }

    public float getRotationYaw() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.field_70180_af.func_187227_b(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.field_70180_af.func_187227_b(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.field_70180_af.func_187227_b(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

