/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;

public class MorganBallEntity
extends Entity {
    private static final String TAG_SPHERE_SIZE = "MAHOUTSUKAI_SPHERE_SIZE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final String TAG_SPIKE_LENGTH = "MAHOUTSUKAI_SPIKE_LENGTH";
    private static final String TAG_TARGETS = "MAHOUTSUKAI_TARGETS";
    private static final AxisAlignedBB ZERO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AxisAlignedBB bb = new AxisAlignedBB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final DataParameter<Float> SPHERE_SIZE = EntityDataManager.func_187226_a(MorganBallEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_R = EntityDataManager.func_187226_a(MorganBallEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G = EntityDataManager.func_187226_a(MorganBallEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B = EntityDataManager.func_187226_a(MorganBallEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_A = EntityDataManager.func_187226_a(MorganBallEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_R2 = EntityDataManager.func_187226_a(MorganBallEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G2 = EntityDataManager.func_187226_a(MorganBallEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B2 = EntityDataManager.func_187226_a(MorganBallEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> DISTANCE = EntityDataManager.func_187226_a(MorganBallEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SPIKE_LENGTH = EntityDataManager.func_187226_a(MorganBallEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<CompoundNBT> TARGETS = EntityDataManager.func_187226_a(MorganBallEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    public LivingEntity caster;
    public float damage;
    public int dyingTicks = 0;
    public float prev_spike_len;
    public float prev_sphere_size;
    ArrayList<LivingEntity> targets;
    public ArrayList<Float> yaws;
    public ArrayList<Float> pitchs;
    public ArrayList<Float> ds;
    public int m = 0;
    public int earlydeath = 0;
    public float rate = 0.4f;
    public static final String entityName = "morgan_ball_entity";
    public float maxsize = 1.3f;

    public MorganBallEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public MorganBallEntity(World world) {
        super(ModEntities.MORGAN_BALL, world);
        this.field_70158_ak = true;
    }

    public MorganBallEntity(World world, LivingEntity c, float r, float g, float b, float a, float r2, float g2, float b2, float size, float damage) {
        this(world);
        this.setColor(r, g, b, a, r2, g2, b2);
        this.sizer(size);
        this.caster = c;
        this.damage = damage;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SPHERE_SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(COLOR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_R2, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G2, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B2, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_A, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(DISTANCE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SPIKE_LENGTH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TARGETS, (Object)new CompoundNBT());
    }

    public void func_70071_h_() {
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        Vector3d newpos = this.func_213303_ch().func_178787_e(this.func_213322_ci());
        BlockPos pos = new BlockPos(newpos.func_178787_e(this.func_213322_ci().func_186678_a((double)this.getSphereSize())));
        if (this.field_70170_p.func_180495_p(pos).func_196958_f()) {
            this.func_70634_a(newpos.field_72450_a, newpos.field_72448_b, newpos.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.caster == null || !(this.caster.func_184614_ca().func_77973_b() instanceof Morgan)) {
                this.func_70106_y();
                return;
            }
            if (this.dyingTicks <= 0) {
                if (this.earlydeath > 0) {
                    this.setSphereSize(this.getSphereSize() - 0.04f);
                    if (this.getSphereSize() <= 0.0f) {
                        this.func_70106_y();
                    }
                } else {
                    this.setSphereSize(Math.min(this.maxsize, this.getSphereSize() + 0.02f));
                }
                if (this.func_213303_ch().func_72436_e(this.caster.func_213303_ch()) > (double)(MTConfig.MORGAN_MAX_BALL_RANGE * MTConfig.MORGAN_MAX_BALL_RANGE)) {
                    this.func_213317_d(this.func_213322_ci().func_186678_a((double)0.3f));
                } else {
                    this.func_213317_d(this.func_213322_ci().func_186678_a((double)1.02f));
                }
                if (this.caster.func_184614_ca().func_77973_b() instanceof Morgan && !(this.caster.func_184607_cu().func_77973_b() instanceof Morgan)) {
                    if (this.getSphereSize() > 1.0f && this.earlydeath <= 0) {
                        ++this.dyingTicks;
                    } else {
                        ++this.earlydeath;
                    }
                }
            } else {
                if (this.targets == null) {
                    int radius = MTConfig.MORGAN_SPIKE_RANGE;
                    AxisAlignedBB aabb = new AxisAlignedBB(this.func_226277_ct_() - (double)radius, this.func_226278_cu_() - (double)radius, this.func_226281_cx_() - (double)radius, this.func_226277_ct_() + (double)radius, this.func_226278_cu_() + (double)radius, this.func_226281_cx_() + (double)radius);
                    List ts = this.field_70170_p.func_175647_a(LivingEntity.class, aabb, a -> !a.equals((Object)this.caster));
                    this.targets = new ArrayList();
                    for (LivingEntity t : ts) {
                        this.targets.add(t);
                    }
                    this.setDataTargets(this.setTargets(this.targets));
                } else if (this.m > 6) {
                    this.setSpikeLength(Math.max(0.0f, this.getSpikeLength() - this.rate));
                    if (this.getSpikeLength() == 0.0f) {
                        ++this.earlydeath;
                    }
                    if (this.earlydeath > 0) {
                        this.setSphereSize(this.getSphereSize() - 0.04f);
                        if (this.getSphereSize() <= 0.0f) {
                            this.func_70106_y();
                        }
                    }
                    if (this.m == 7) {
                        ArrayList<LivingEntity> spikeTargets = this.getTargets(this.getDataTargets());
                        for (LivingEntity s : spikeTargets) {
                            if (ContractMahoujinTileEntity.isImmuneToSpell(this.field_70170_p, this.caster.func_110124_au(), (Entity)s)) continue;
                            EffectUtil.magicAttack(s, this.damage / (float)spikeTargets.size(), this.caster);
                            Vector3d d = s.func_174824_e(1.0f).func_178788_d(this.func_213303_ch());
                            MorganBallEntity.boop((Entity)s, (float)d.func_72433_c() / 4.0f, d.field_72450_a, d.field_72448_b, d.field_72449_c);
                        }
                    }
                    ++this.m;
                } else if (this.getSpikeLength() >= 1.0f) {
                    ++this.m;
                } else {
                    this.setSpikeLength(this.getSpikeLength() + this.rate);
                }
                ++this.dyingTicks;
            }
        } else {
            ArrayList<LivingEntity> spikeTargets = this.getTargets(this.getDataTargets());
            this.yaws = new ArrayList();
            this.pitchs = new ArrayList();
            this.ds = new ArrayList();
            for (LivingEntity e : spikeTargets) {
                this.addYawPitchDist(e);
            }
        }
        this.prev_spike_len = this.getSpikeLength();
        this.prev_sphere_size = this.getSphereSize();
    }

    public void addYawPitchDist(LivingEntity e) {
        if (e != null) {
            Vector3d v = e.func_174824_e(1.0f).func_178788_d(this.func_213303_ch());
            float d = (float)v.func_72433_c() + 1.5f;
            v = v.func_72432_b();
            float pitch = (float)Math.asin(-v.field_72448_b);
            float yaw = (float)Math.atan2(v.field_72450_a, v.field_72449_c);
            this.yaws.add(Float.valueOf(EffectUtil.toDegrees(yaw)));
            this.pitchs.add(Float.valueOf(EffectUtil.toDegrees(pitch) + 90.0f));
            this.ds.add(Float.valueOf(d));
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2) {
        this.field_70180_af.func_187227_b(COLOR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(COLOR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(COLOR_B, (Object)Float.valueOf(b));
        this.field_70180_af.func_187227_b(COLOR_R2, (Object)Float.valueOf(r2));
        this.field_70180_af.func_187227_b(COLOR_G2, (Object)Float.valueOf(g2));
        this.field_70180_af.func_187227_b(COLOR_B2, (Object)Float.valueOf(b2));
        this.field_70180_af.func_187227_b(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getColor() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(COLOR_R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_A)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_R2)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G2)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B2)).floatValue()};
    }

    protected void func_145775_I() {
    }

    @Nullable
    public AxisAlignedBB func_174813_aQ() {
        return ZERO_AABB;
    }

    public void sizer(float s) {
        this.setSphereSize(s);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setSphereSize(compound.func_74760_g(TAG_SPHERE_SIZE));
        this.setSpikeLength(compound.func_74760_g(TAG_SPIKE_LENGTH));
        this.setColor(compound.func_74760_g(TAG_COLOR_R), compound.func_74760_g(TAG_COLOR_G), compound.func_74760_g(TAG_COLOR_B), compound.func_74760_g(TAG_COLOR_A), compound.func_74760_g(TAG_COLOR_R2), compound.func_74760_g(TAG_COLOR_G2), compound.func_74760_g(TAG_COLOR_B2));
        this.setDistance(compound.func_74760_g(TAG_DISTANCE));
        this.setDataTargets(compound.func_74775_l(TAG_TARGETS));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a(TAG_SPHERE_SIZE, this.getSphereSize());
        compound.func_74776_a(TAG_SPIKE_LENGTH, this.getSpikeLength());
        float[] colors = this.getColor();
        compound.func_74776_a(TAG_COLOR_R, colors[0]);
        compound.func_74776_a(TAG_COLOR_G, colors[1]);
        compound.func_74776_a(TAG_COLOR_B, colors[2]);
        compound.func_74776_a(TAG_COLOR_A, colors[3]);
        compound.func_74776_a(TAG_COLOR_R2, colors[4]);
        compound.func_74776_a(TAG_COLOR_G2, colors[5]);
        compound.func_74776_a(TAG_COLOR_B2, colors[6]);
        compound.func_74776_a(TAG_DISTANCE, this.getDistance());
        compound.func_218657_a(TAG_TARGETS, (INBT)this.getDataTargets());
    }

    public AxisAlignedBB func_184177_bl() {
        return bb;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getSphereSize() {
        return ((Float)this.field_70180_af.func_187225_a(SPHERE_SIZE)).floatValue();
    }

    public void setSphereSize(float s) {
        this.field_70180_af.func_187227_b(SPHERE_SIZE, (Object)Float.valueOf(s));
    }

    public float getSpikeLength() {
        return ((Float)this.field_70180_af.func_187225_a(SPIKE_LENGTH)).floatValue();
    }

    public void setSpikeLength(float s) {
        this.field_70180_af.func_187227_b(SPIKE_LENGTH, (Object)Float.valueOf(s));
    }

    public ArrayList<LivingEntity> getTargets(CompoundNBT nbt) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        if (nbt != null) {
            int k = 0;
            while (nbt.func_74764_b("target" + k)) {
                Entity e = this.field_70170_p.func_73045_a(nbt.func_74762_e("target" + k));
                if (e instanceof LivingEntity) {
                    lst.add((LivingEntity)e);
                }
                ++k;
            }
        }
        return lst;
    }

    public CompoundNBT setTargets(ArrayList<LivingEntity> targets) {
        CompoundNBT nbt = new CompoundNBT();
        for (int k = 0; k < targets.size(); ++k) {
            if (!targets.get(k).func_70089_S()) continue;
            nbt.func_74768_a("target" + k, targets.get(k).func_145782_y());
        }
        return nbt;
    }

    public CompoundNBT getDataTargets() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(TARGETS);
    }

    public void setDataTargets(CompoundNBT nbt) {
        this.field_70180_af.func_187227_b(TARGETS, (Object)nbt);
    }

    public float getDistance() {
        return ((Float)this.field_70180_af.func_187225_a(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.field_70180_af.func_187227_b(DISTANCE, (Object)Float.valueOf(d));
    }

    public static void boop(Entity entity, float strength, double x, double y, double z) {
        entity.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(x * x + z * z + y * y));
        double motionX = 0.0;
        double motionY = 0.0;
        double motionZ = 0.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.field_70133_I = true;
        if (entity.func_233570_aj_()) {
            motionY /= 2.0;
            if ((motionY += 0.3) > 0.6) {
                motionY = 0.6;
            }
        }
        entity.func_213317_d(new Vector3d(motionX, motionY, motionZ));
    }
}

