/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.entity.MentalDisplacementEntity;
import stepsword.mahoutsukai.networking.DonePossessingPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class PossessEntityClientEffect {
    public static Entity possessionHold = null;

    public static void possessEntityInputUpdate(MovementInput mi, PlayerEntity player) {
        IMahou mahou;
        if (player != null && (mahou = Utils.getPlayerMahou((LivingEntity)player)) != null && mahou.isPossessing() && (mi.field_78901_c || mi.field_228350_h_ || mi.field_187257_e || mi.field_187255_c || mi.field_187256_d || mi.field_187258_f) && PossessEntityClientEffect.isActuallyPossessing(player)) {
            mi.field_78901_c = false;
            mi.field_228350_h_ = false;
            mi.field_187257_e = false;
            mi.field_187255_c = false;
            mi.field_187256_d = false;
            mi.field_187258_f = false;
        }
    }

    public static boolean possessEntityRenderHand() {
        IMahou mahou = Utils.getPlayerMahou((LivingEntity)Minecraft.func_71410_x().field_71439_g);
        return mahou != null && mahou.isPossessing() && PossessEntityClientEffect.isActuallyPossessing((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    public static void possessEntityMouseInput() {
        KeyBinding k;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IMahou mahou = Utils.getPlayerMahou((LivingEntity)Minecraft.func_71410_x().field_71439_g);
        if (mahou != null && mahou.isPossessing() && PossessEntityClientEffect.isActuallyPossessing((PlayerEntity)player) && (k = Minecraft.func_71410_x().field_71474_y.field_74312_F) != null && k.func_151468_f()) {
            k.field_74513_e = false;
            k.field_151474_i = 0;
            PossessEntityClientEffect.possessEntityDisallowedAction((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        }
    }

    public static boolean isActuallyPossessing(PlayerEntity player) {
        if (!(Minecraft.func_71410_x().func_175606_aa() instanceof MentalDisplacementEntity)) {
            return !(Minecraft.func_71410_x().func_175606_aa() instanceof PlayerEntity) || !Minecraft.func_71410_x().func_175606_aa().func_110124_au().equals(player.func_110124_au());
        }
        return false;
    }

    public static boolean possessEntityDisallowedAction(PlayerEntity player) {
        boolean ret = false;
        if (player != null) {
            IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
            if (player.field_70170_p.field_72995_K) {
                if (mahou != null && mahou.isPossessing() && PossessEntityClientEffect.isActuallyPossessing(player)) {
                    Entity entity = Minecraft.func_71410_x().func_175606_aa();
                    Minecraft.func_71410_x().func_175607_a((Entity)player);
                    if (entity != null) {
                        ChunkPos pos = new ChunkPos(entity.func_233580_cy_());
                        PacketHandler.sendToServer(new DonePossessingPacket(pos.field_77276_a, pos.field_77275_b));
                        ret = true;
                    }
                }
            } else if (mahou != null && mahou.isPossessing()) {
                ret = true;
            }
        }
        return ret;
    }

    public static boolean possessEntityDisallowedAction(PlayerInteractEvent event) {
        boolean ret = false;
        PlayerEntity player = event.getPlayer();
        if (player != null) {
            IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
            if (event.getWorld().field_72995_K && mahou != null && mahou.isPossessing() && PossessEntityClientEffect.isActuallyPossessing(player)) {
                Entity entity = Minecraft.func_71410_x().func_175606_aa();
                Minecraft.func_71410_x().func_175607_a((Entity)player);
                if (entity != null) {
                    ChunkPos pos = new ChunkPos(entity.func_233580_cy_());
                    ret = true;
                    PacketHandler.sendToServer(new DonePossessingPacket(pos.field_77276_a, pos.field_77275_b));
                }
            }
        } else {
            IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
            if (mahou != null && mahou.isPossessing()) {
                ret = true;
            }
        }
        return ret;
    }

    public static void possessionRenderWorldLast(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
        if (mahou != null && mahou.isPossessing() && PossessEntityClientEffect.isActuallyPossessing((PlayerEntity)player)) {
            ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
            float partialTicks = event.getPartialTicks();
            Vector3d Vector3d2 = renderInfo.func_216785_c();
            double xx = Vector3d2.func_82615_a();
            double yy = Vector3d2.func_82617_b();
            double zz = Vector3d2.func_82616_c();
            double d0 = MathHelper.func_219803_d((double)partialTicks, (double)player.field_70142_S, (double)player.func_226277_ct_());
            double d1 = MathHelper.func_219803_d((double)partialTicks, (double)player.field_70137_T, (double)player.func_226278_cu_());
            double d2 = MathHelper.func_219803_d((double)partialTicks, (double)player.field_70136_U, (double)player.func_226281_cx_());
            float f = MathHelper.func_219799_g((float)partialTicks, (float)player.field_70126_B, (float)player.field_70177_z);
            Minecraft.func_71410_x().func_175598_ae().func_229084_a_((Entity)player, d0 - xx, d1 - yy, d2 - zz, f, partialTicks, event.getMatrixStack(), (IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_(), 240);
        }
    }
}

