/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads.events;

import com.mojang.authlib.GameProfile;
import com.natamus.collective.functions.WorldFunctions;
import com.natamus.justmobheads.config.ConfigHandler;
import com.natamus.justmobheads.util.HeadData;
import com.natamus.justmobheads.util.MobHeads;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.WallSkullBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HeadDropEvent {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public void mobItemDrop(LivingDropsEvent e) {
        ItemEntity mobhead;
        Integer looting;
        TameableEntity te;
        Entity entity = e.getEntity();
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        if (((Boolean)ConfigHandler.GENERAL.onlyDropHeadsByChargedCreeper.get()).booleanValue() || ((Boolean)ConfigHandler.GENERAL.onlyDropHeadsByPlayerKill.get()).booleanValue()) {
            DamageSource source = e.getSource();
            Entity sourceentity = source.func_76364_f();
            if (((Boolean)ConfigHandler.GENERAL.onlyDropHeadsByChargedCreeper.get()).booleanValue()) {
                if (!(sourceentity instanceof CreeperEntity)) return;
                CreeperEntity creeper = (CreeperEntity)sourceentity;
                if (!creeper.func_225509_J__()) {
                    return;
                }
            } else if (((Boolean)ConfigHandler.GENERAL.onlyDropHeadsByPlayerKill.get()).booleanValue() && !(sourceentity instanceof PlayerEntity)) {
                return;
            }
        }
        if (((Boolean)ConfigHandler.GENERAL.onlyAdultMobsDropTheirHead.get()).booleanValue() && entity instanceof TameableEntity && (te = (TameableEntity)entity).func_70631_g_()) {
            return;
        }
        String mobname = MobHeads.getName(entity);
        if (mobname == "") {
            return;
        }
        double extrachance = 0.0;
        if (((Boolean)ConfigHandler.GENERAL.enableLootingEnchant.get()).booleanValue() && (looting = Integer.valueOf(e.getLootingLevel())) > 0) {
            extrachance = 0.025 + (double)(looting / 100);
        }
        String headname = "";
        if (mobname.equals("creeper") || mobname.equals("zombie") || mobname.equals("skeleton")) {
            if (!((Boolean)ConfigHandler.GENERAL.enableStandardHeads.get()).booleanValue()) return;
            headname = mobname.substring(0, 1).toUpperCase() + mobname.substring(1) + " Head";
        }
        double num = Math.random();
        if (((Boolean)ConfigHandler.GENERAL.mobSpecificDropChances.get()).booleanValue()) {
            double chance = -1.0;
            if (headname.equals("")) {
                if (HeadData.headchances.containsKey(mobname)) {
                    chance = HeadData.headchances.get(mobname);
                }
            } else {
                chance = (Double)ConfigHandler.GENERAL.creeperSkeletonZombieDropChance.get();
            }
            if (chance == -1.0 ? num > (Double)ConfigHandler.GENERAL.overallDropChance.get() + extrachance : num > chance + extrachance) {
                return;
            }
        } else if (num > (Double)ConfigHandler.GENERAL.overallDropChance.get() + extrachance) {
            return;
        }
        BlockPos pos = entity.func_233580_cy_();
        if (headname.equals("")) {
            ItemStack headstack = MobHeads.getMobHead(mobname, 1);
            if (headstack == null) {
                return;
            }
            mobhead = new ItemEntity(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), headstack);
        } else {
            mobhead = new ItemEntity(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), MobHeads.getStandardHead(headname));
        }
        world.func_217376_c((Entity)mobhead);
    }

    @SubscribeEvent
    public void onPlayerHeadBreak(BlockEvent.BreakEvent e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        BlockState state = e.getState();
        Block block = state.func_177230_c();
        if (block instanceof SkullBlock || block instanceof WallSkullBlock) {
            ItemStack named_headstack;
            if (e.getPlayer().func_184812_l_()) {
                return;
            }
            BlockPos pos = e.getPos();
            SkullTileEntity sbe = (SkullTileEntity)world.func_175625_s(pos);
            if (sbe == null) {
                return;
            }
            GameProfile profile = sbe.func_152108_a();
            if (profile == null) {
                return;
            }
            UUID uuid = profile.getId();
            if (uuid == null) {
                return;
            }
            String headid = uuid.toString();
            String correctheadname = "";
            for (String headname : HeadData.headdata.keySet()) {
                String headnameid = (String)HeadData.headdata.get(headname).getFirst();
                if (!headid.equals(headnameid)) continue;
                correctheadname = headname;
                break;
            }
            if ((named_headstack = MobHeads.getMobHead(correctheadname, 1)) != null) {
                e.setCanceled(true);
                world.func_175655_b(pos, false);
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), named_headstack));
            }
        }
    }
}

