/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective.functions.StringFunctions;
import com.natamus.justmobheads.util.HeadData;
import com.natamus.justmobheads.util.MobHeads;
import com.natamus.justmobheads.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class CommandJmh {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"jmh").requires(iCommandSender -> iCommandSender.func_197034_c(2))).then(Commands.func_197057_a((String)"reload").executes(command -> {
            CommandSource source = (CommandSource)command.getSource();
            StringFunctions.sendMessage((CommandSource)source, (String)"Reloading head chances config file now.", (TextFormatting)TextFormatting.DARK_GREEN);
            try {
                if (Util.generateChanceConfig(HeadData.defaultchances)) {
                    StringFunctions.sendMessage((CommandSource)source, (String)"Succesfully loaded! The dropchances have been altered.", (TextFormatting)TextFormatting.DARK_GREEN);
                } else {
                    StringFunctions.sendMessage((CommandSource)source, (String)"Generated new config file. Using the default chances.", (TextFormatting)TextFormatting.DARK_GREEN);
                }
            }
            catch (Exception ex) {
                StringFunctions.sendMessage((CommandSource)source, (String)"Something went wrong while loading the config file.", (TextFormatting)TextFormatting.RED);
            }
            return 1;
        }))).then(Commands.func_197057_a((String)"head").then(Commands.func_197057_a((String)"list").executes(command -> {
            CommandSource source = (CommandSource)command.getSource();
            StringFunctions.sendMessage((CommandSource)source, (String)"You can generate the following mob heads:", (TextFormatting)TextFormatting.DARK_GREEN);
            StringFunctions.sendMessage((CommandSource)source, (String)" Usage: /jmh head <name> <amount>:", (TextFormatting)TextFormatting.DARK_GREEN);
            ArrayList<String> mobnames = new ArrayList<String>(HeadData.headdata.keySet());
            Collections.sort(mobnames);
            String mnstr = String.join((CharSequence)", ", mobnames);
            StringFunctions.sendMessage((CommandSource)source, (String)mnstr, (TextFormatting)TextFormatting.YELLOW);
            return 1;
        })))).then(Commands.func_197057_a((String)"head").then(Commands.func_197056_a((String)"mob-name", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(command -> {
            ServerPlayerEntity player;
            CommandSource source = (CommandSource)command.getSource();
            String mobname = StringArgumentType.getString((CommandContext)command, (String)"mob-name").toLowerCase();
            Integer amount = IntegerArgumentType.getInteger((CommandContext)command, (String)"amount");
            if (!HeadData.headdata.containsKey(mobname)) {
                StringFunctions.sendMessage((CommandSource)source, (String)("The mobname '" + mobname + "' does not exist. You can get a list of all possible heads with:"), (TextFormatting)TextFormatting.RED);
                StringFunctions.sendMessage((CommandSource)source, (String)" Usage: /jmh head list", (TextFormatting)TextFormatting.RED);
                return 1;
            }
            try {
                player = source.func_197035_h();
            }
            catch (CommandSyntaxException ex) {
                StringFunctions.sendMessage((CommandSource)source, (String)"This command can only be executed as a player in-game.", (TextFormatting)TextFormatting.RED);
                return 1;
            }
            ItemStack headstack = MobHeads.getMobHead(mobname, amount);
            if (!player.field_71071_by.func_70441_a(headstack)) {
                player.func_71019_a(headstack, false);
            }
            StringFunctions.sendMessage((CommandSource)source, (String)("Successfully generated " + amount + " " + StringFunctions.capitalizeFirst((String)mobname.replace("_", " ")) + " heads."), (TextFormatting)TextFormatting.DARK_GREEN);
            return 1;
        })))));
    }
}

