/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.auxilium;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.PlatformDescriptors;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;

public class SystemStats {
    public String timeZone;
    public String javaVersion;
    public String javaVendor;
    public long memoryTotal;
    public long memoryMax;
    public int cpuCores;
    public String operatingSystemArch;
    public String operatingSystem;
    public String cpu;
    public String gpu;
    public String version;
    public String launchVersion;
    public String clientBrand;
    public double guiScale;
    public int resourcePacks = 0;
    public int refreshRate;
    public boolean vsync;
    public boolean fullscreen;
    public String lang;
    public int packId = -1;
    public int packVersionId = -1;

    public SystemStats(Minecraft minecraft) {
        Runtime runtime = Runtime.getRuntime();
        this.javaVersion = System.getProperty("java.version");
        this.javaVendor = System.getProperty("java.vendor");
        this.memoryTotal = runtime.totalMemory();
        this.memoryMax = runtime.maxMemory();
        this.cpuCores = runtime.availableProcessors();
        this.operatingSystemArch = System.getProperty("os.arch");
        this.operatingSystem = Util.func_110647_a().toString();
        this.timeZone = System.getProperty("user.timezone");
        this.cpu = PlatformDescriptors.func_227775_b_();
        this.gpu = PlatformDescriptors.func_227776_c_();
        this.guiScale = minecraft.func_228018_at_().func_198100_s();
        for (ResourcePackInfo pack : minecraft.func_195548_H().func_198980_d()) {
            if (pack.func_195797_g() || pack.func_195797_g()) continue;
            ++this.resourcePacks;
        }
        this.refreshRate = minecraft.func_228018_at_().func_227798_a_();
        this.vsync = minecraft.field_71474_y.field_74352_v;
        this.fullscreen = minecraft.field_71474_y.field_74353_u;
        this.lang = minecraft.field_71474_y.field_74363_ab;
        this.version = SharedConstants.func_215069_a().getName();
        this.launchVersion = minecraft.func_175600_c();
        this.clientBrand = ClientBrandRetriever.getClientModName();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timeZone", (Object)this.timeZone).add("javaVersion", (Object)this.javaVersion).add("javaVendor", (Object)this.javaVendor).add("memoryTotal", this.memoryTotal).add("memoryMax", this.memoryMax).add("cpuCores", this.cpuCores).add("operatingSystemArch", (Object)this.operatingSystemArch).add("operatingSystem", (Object)this.operatingSystem).add("cpu", (Object)this.cpu).add("gpu", (Object)this.gpu).add("version", (Object)this.version).add("launchVersion", (Object)this.launchVersion).add("clientBrand", (Object)this.clientBrand).add("guiScale", this.guiScale).add("resourcePacks", this.resourcePacks).add("refreshRate", this.refreshRate).add("vsync", this.vsync).add("fullscreen", this.fullscreen).add("lang", (Object)this.lang).toString();
    }
}

