/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.TimerCallbackManager;
import net.minecraft.command.TimerCallbackSerializers;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.UUIDCodec;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.WorldGenSettingsExport;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.VersionData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerWorldInfo
implements IServerWorldInfo,
IServerConfiguration {
    private static final Logger field_237341_a_ = LogManager.getLogger();
    private WorldSettings field_237342_b_;
    private final DimensionGeneratorSettings field_237343_c_;
    private final Lifecycle field_237344_d_;
    private int field_237345_e_;
    private int field_237346_f_;
    private int field_237347_g_;
    private float field_242984_h;
    private long field_237348_h_;
    private long field_237349_i_;
    @Nullable
    private final DataFixer field_237350_j_;
    private final int field_237351_k_;
    private boolean field_237352_l_;
    @Nullable
    private CompoundNBT field_237353_m_;
    private final int field_237354_n_;
    private int field_237355_o_;
    private boolean field_237356_p_;
    private int field_237357_q_;
    private boolean field_237358_r_;
    private int field_237359_s_;
    private boolean field_237360_t_;
    private boolean field_237361_u_;
    private WorldBorder.Serializer field_237362_v_;
    private CompoundNBT field_237363_w_;
    @Nullable
    private CompoundNBT field_237364_x_;
    private int field_237365_y_;
    private int field_237366_z_;
    @Nullable
    private UUID field_237337_A_;
    private final Set<String> field_237338_B_;
    private boolean field_237339_C_;
    private final TimerCallbackManager<MinecraftServer> field_237340_D_;

    private ServerWorldInfo(@Nullable DataFixer dataFixer, int n, @Nullable CompoundNBT compoundNBT, boolean bl, int n2, int n3, int n4, float f, long l, long l2, int n5, int n6, int n7, boolean bl2, int n8, boolean bl3, boolean bl4, boolean bl5, WorldBorder.Serializer serializer, int n9, int n10, @Nullable UUID uUID, LinkedHashSet<String> linkedHashSet, TimerCallbackManager<MinecraftServer> timerCallbackManager, @Nullable CompoundNBT compoundNBT2, CompoundNBT compoundNBT3, WorldSettings worldSettings, DimensionGeneratorSettings dimensionGeneratorSettings, Lifecycle lifecycle) {
        this.field_237350_j_ = dataFixer;
        this.field_237339_C_ = bl;
        this.field_237345_e_ = n2;
        this.field_237346_f_ = n3;
        this.field_237347_g_ = n4;
        this.field_242984_h = f;
        this.field_237348_h_ = l;
        this.field_237349_i_ = l2;
        this.field_237354_n_ = n5;
        this.field_237355_o_ = n6;
        this.field_237357_q_ = n7;
        this.field_237356_p_ = bl2;
        this.field_237359_s_ = n8;
        this.field_237358_r_ = bl3;
        this.field_237360_t_ = bl4;
        this.field_237361_u_ = bl5;
        this.field_237362_v_ = serializer;
        this.field_237365_y_ = n9;
        this.field_237366_z_ = n10;
        this.field_237337_A_ = uUID;
        this.field_237338_B_ = linkedHashSet;
        this.field_237353_m_ = compoundNBT;
        this.field_237351_k_ = n;
        this.field_237340_D_ = timerCallbackManager;
        this.field_237364_x_ = compoundNBT2;
        this.field_237363_w_ = compoundNBT3;
        this.field_237342_b_ = worldSettings;
        this.field_237343_c_ = dimensionGeneratorSettings;
        this.field_237344_d_ = lifecycle;
    }

    public ServerWorldInfo(WorldSettings worldSettings, DimensionGeneratorSettings dimensionGeneratorSettings, Lifecycle lifecycle) {
        this(null, SharedConstants.func_215069_a().getWorldVersion(), null, false, 0, 0, 0, 0.0f, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, WorldBorder.field_235925_b_, 0, 0, null, Sets.newLinkedHashSet(), new TimerCallbackManager<MinecraftServer>(TimerCallbackSerializers.field_216342_a), null, new CompoundNBT(), worldSettings.func_234959_h_(), dimensionGeneratorSettings, lifecycle);
    }

    public static ServerWorldInfo func_237369_a_(Dynamic<INBT> dynamic2, DataFixer dataFixer, int n, @Nullable CompoundNBT compoundNBT, WorldSettings worldSettings, VersionData versionData, DimensionGeneratorSettings dimensionGeneratorSettings, Lifecycle lifecycle) {
        long l = dynamic2.get("Time").asLong(0L);
        CompoundNBT \u26032 = (CompoundNBT)dynamic2.get("DragonFight").result().map(Dynamic::getValue).orElseGet(() -> (INBT)dynamic2.get("DimensionData").get("1").get("DragonFight").orElseEmptyMap().getValue());
        return new ServerWorldInfo(dataFixer, n, compoundNBT, dynamic2.get("WasModded").asBoolean(false), dynamic2.get("SpawnX").asInt(0), dynamic2.get("SpawnY").asInt(0), dynamic2.get("SpawnZ").asInt(0), dynamic2.get("SpawnAngle").asFloat(0.0f), l, dynamic2.get("DayTime").asLong(l), versionData.func_237323_a_(), dynamic2.get("clearWeatherTime").asInt(0), dynamic2.get("rainTime").asInt(0), dynamic2.get("raining").asBoolean(false), dynamic2.get("thunderTime").asInt(0), dynamic2.get("thundering").asBoolean(false), dynamic2.get("initialized").asBoolean(true), dynamic2.get("DifficultyLocked").asBoolean(false), WorldBorder.Serializer.func_235938_a_(dynamic2, WorldBorder.field_235925_b_), dynamic2.get("WanderingTraderSpawnDelay").asInt(0), dynamic2.get("WanderingTraderSpawnChance").asInt(0), dynamic2.get("WanderingTraderId").read(UUIDCodec.field_239775_a_).result().orElse(null), dynamic2.get("ServerBrands").asStream().flatMap(dynamic -> Util.func_215081_a(dynamic.asString().result())).collect(Collectors.toCollection(Sets::newLinkedHashSet)), new TimerCallbackManager<MinecraftServer>(TimerCallbackSerializers.field_216342_a, dynamic2.get("ScheduledEvents").asStream()), (CompoundNBT)dynamic2.get("CustomBossEvents").orElseEmptyMap().getValue(), \u26032, worldSettings, dimensionGeneratorSettings, lifecycle);
    }

    @Override
    public CompoundNBT func_230411_a_(DynamicRegistries dynamicRegistries, @Nullable CompoundNBT compoundNBT) {
        this.func_237367_I_();
        if (compoundNBT == null) {
            compoundNBT = this.field_237353_m_;
        }
        \u2603 = new CompoundNBT();
        this.func_237370_a_(dynamicRegistries, \u2603, compoundNBT);
        return \u2603;
    }

    private void func_237370_a_(DynamicRegistries dynamicRegistries, CompoundNBT compoundNBT, @Nullable CompoundNBT compoundNBT2) {
        ListNBT listNBT = new ListNBT();
        this.field_237338_B_.stream().map(StringNBT::func_229705_a_).forEach(listNBT::add);
        compoundNBT.func_218657_a("ServerBrands", listNBT);
        compoundNBT.func_74757_a("WasModded", this.field_237339_C_);
        CompoundNBT \u26032 = new CompoundNBT();
        \u26032.func_74778_a("Name", SharedConstants.func_215069_a().getName());
        \u26032.func_74768_a("Id", SharedConstants.func_215069_a().getWorldVersion());
        \u26032.func_74757_a("Snapshot", !SharedConstants.func_215069_a().isStable());
        compoundNBT.func_218657_a("Version", \u26032);
        compoundNBT.func_74768_a("DataVersion", SharedConstants.func_215069_a().getWorldVersion());
        WorldGenSettingsExport<INBT> \u26033 = WorldGenSettingsExport.func_240896_a_(NBTDynamicOps.field_210820_a, dynamicRegistries);
        DimensionGeneratorSettings.field_236201_a_.encodeStart(\u26033, (Object)this.field_237343_c_).resultOrPartial(Util.func_240982_a_("WorldGenSettings: ", arg_0 -> ((Logger)field_237341_a_).error(arg_0))).ifPresent(iNBT -> compoundNBT.func_218657_a("WorldGenSettings", (INBT)iNBT));
        compoundNBT.func_74768_a("GameType", this.field_237342_b_.func_234953_b_().func_77148_a());
        compoundNBT.func_74768_a("SpawnX", this.field_237345_e_);
        compoundNBT.func_74768_a("SpawnY", this.field_237346_f_);
        compoundNBT.func_74768_a("SpawnZ", this.field_237347_g_);
        compoundNBT.func_74776_a("SpawnAngle", this.field_242984_h);
        compoundNBT.func_74772_a("Time", this.field_237348_h_);
        compoundNBT.func_74772_a("DayTime", this.field_237349_i_);
        compoundNBT.func_74772_a("LastPlayed", Util.func_211179_d());
        compoundNBT.func_74778_a("LevelName", this.field_237342_b_.func_234947_a_());
        compoundNBT.func_74768_a("version", 19133);
        compoundNBT.func_74768_a("clearWeatherTime", this.field_237355_o_);
        compoundNBT.func_74768_a("rainTime", this.field_237357_q_);
        compoundNBT.func_74757_a("raining", this.field_237356_p_);
        compoundNBT.func_74768_a("thunderTime", this.field_237359_s_);
        compoundNBT.func_74757_a("thundering", this.field_237358_r_);
        compoundNBT.func_74757_a("hardcore", this.field_237342_b_.func_234954_c_());
        compoundNBT.func_74757_a("allowCommands", this.field_237342_b_.func_234956_e_());
        compoundNBT.func_74757_a("initialized", this.field_237360_t_);
        this.field_237362_v_.func_235939_a_(compoundNBT);
        compoundNBT.func_74774_a("Difficulty", (byte)this.field_237342_b_.func_234955_d_().func_151525_a());
        compoundNBT.func_74757_a("DifficultyLocked", this.field_237361_u_);
        compoundNBT.func_218657_a("GameRules", this.field_237342_b_.func_234957_f_().func_82770_a());
        compoundNBT.func_218657_a("DragonFight", this.field_237363_w_);
        if (compoundNBT2 != null) {
            compoundNBT.func_218657_a("Player", compoundNBT2);
        }
        DatapackCodec.field_234881_b_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.field_237342_b_.func_234958_g_()).result().ifPresent(iNBT -> compoundNBT.func_218657_a("DataPacks", (INBT)iNBT));
        if (this.field_237364_x_ != null) {
            compoundNBT.func_218657_a("CustomBossEvents", this.field_237364_x_);
        }
        compoundNBT.func_218657_a("ScheduledEvents", this.field_237340_D_.func_216327_b());
        compoundNBT.func_74768_a("WanderingTraderSpawnDelay", this.field_237365_y_);
        compoundNBT.func_74768_a("WanderingTraderSpawnChance", this.field_237366_z_);
        if (this.field_237337_A_ != null) {
            compoundNBT.func_186854_a("WanderingTraderId", this.field_237337_A_);
        }
    }

    @Override
    public int func_76079_c() {
        return this.field_237345_e_;
    }

    @Override
    public int func_76075_d() {
        return this.field_237346_f_;
    }

    @Override
    public int func_76074_e() {
        return this.field_237347_g_;
    }

    @Override
    public float func_241860_d() {
        return this.field_242984_h;
    }

    @Override
    public long func_82573_f() {
        return this.field_237348_h_;
    }

    @Override
    public long func_76073_f() {
        return this.field_237349_i_;
    }

    private void func_237367_I_() {
        if (this.field_237352_l_ || this.field_237353_m_ == null) {
            return;
        }
        if (this.field_237351_k_ < SharedConstants.func_215069_a().getWorldVersion()) {
            if (this.field_237350_j_ == null) {
                throw Util.func_229757_c_(new NullPointerException("Fixer Upper not set inside LevelData, and the player tag is not upgraded."));
            }
            this.field_237353_m_ = NBTUtil.func_210822_a(this.field_237350_j_, DefaultTypeReferences.PLAYER, this.field_237353_m_, this.field_237351_k_);
        }
        this.field_237352_l_ = true;
    }

    @Override
    public CompoundNBT func_230416_x_() {
        this.func_237367_I_();
        return this.field_237353_m_;
    }

    @Override
    public void func_76058_a(int n) {
        this.field_237345_e_ = n;
    }

    @Override
    public void func_76056_b(int n) {
        this.field_237346_f_ = n;
    }

    @Override
    public void func_76087_c(int n) {
        this.field_237347_g_ = n;
    }

    @Override
    public void func_241859_a(float f) {
        this.field_242984_h = f;
    }

    @Override
    public void func_82572_b(long l) {
        this.field_237348_h_ = l;
    }

    @Override
    public void func_76068_b(long l) {
        this.field_237349_i_ = l;
    }

    @Override
    public void func_176143_a(BlockPos blockPos, float f) {
        this.field_237345_e_ = blockPos.func_177958_n();
        this.field_237346_f_ = blockPos.func_177956_o();
        this.field_237347_g_ = blockPos.func_177952_p();
        this.field_242984_h = f;
    }

    @Override
    public String func_76065_j() {
        return this.field_237342_b_.func_234947_a_();
    }

    @Override
    public int func_230417_y_() {
        return this.field_237354_n_;
    }

    @Override
    public int func_230395_g_() {
        return this.field_237355_o_;
    }

    @Override
    public void func_230391_a_(int n) {
        this.field_237355_o_ = n;
    }

    @Override
    public boolean func_76061_m() {
        return this.field_237358_r_;
    }

    @Override
    public void func_76069_a(boolean bl) {
        this.field_237358_r_ = bl;
    }

    @Override
    public int func_76071_n() {
        return this.field_237359_s_;
    }

    @Override
    public void func_76090_f(int n) {
        this.field_237359_s_ = n;
    }

    @Override
    public boolean func_76059_o() {
        return this.field_237356_p_;
    }

    @Override
    public void func_76084_b(boolean bl) {
        this.field_237356_p_ = bl;
    }

    @Override
    public int func_76083_p() {
        return this.field_237357_q_;
    }

    @Override
    public void func_76080_g(int n) {
        this.field_237357_q_ = n;
    }

    @Override
    public GameType func_76077_q() {
        return this.field_237342_b_.func_234953_b_();
    }

    @Override
    public void func_230392_a_(GameType gameType) {
        this.field_237342_b_ = this.field_237342_b_.func_234950_a_(gameType);
    }

    @Override
    public boolean func_76093_s() {
        return this.field_237342_b_.func_234954_c_();
    }

    @Override
    public boolean func_76086_u() {
        return this.field_237342_b_.func_234956_e_();
    }

    @Override
    public boolean func_76070_v() {
        return this.field_237360_t_;
    }

    @Override
    public void func_76091_d(boolean bl) {
        this.field_237360_t_ = bl;
    }

    @Override
    public GameRules func_82574_x() {
        return this.field_237342_b_.func_234957_f_();
    }

    @Override
    public WorldBorder.Serializer func_230398_q_() {
        return this.field_237362_v_;
    }

    @Override
    public void func_230393_a_(WorldBorder.Serializer serializer) {
        this.field_237362_v_ = serializer;
    }

    @Override
    public Difficulty func_176130_y() {
        return this.field_237342_b_.func_234955_d_();
    }

    @Override
    public void func_230409_a_(Difficulty difficulty) {
        this.field_237342_b_ = this.field_237342_b_.func_234948_a_(difficulty);
    }

    @Override
    public boolean func_176123_z() {
        return this.field_237361_u_;
    }

    @Override
    public void func_230415_d_(boolean bl) {
        this.field_237361_u_ = bl;
    }

    @Override
    public TimerCallbackManager<MinecraftServer> func_215763_z() {
        return this.field_237340_D_;
    }

    @Override
    public void func_85118_a(CrashReportCategory crashReportCategory) {
        IServerWorldInfo.super.func_85118_a(crashReportCategory);
        IServerConfiguration.super.func_85118_a(crashReportCategory);
    }

    @Override
    public DimensionGeneratorSettings func_230418_z_() {
        return this.field_237343_c_;
    }

    @Override
    public CompoundNBT func_230402_B_() {
        return this.field_237363_w_;
    }

    @Override
    public void func_230413_a_(CompoundNBT compoundNBT) {
        this.field_237363_w_ = compoundNBT;
    }

    @Override
    public DatapackCodec func_230403_C_() {
        return this.field_237342_b_.func_234958_g_();
    }

    @Override
    public void func_230410_a_(DatapackCodec datapackCodec) {
        this.field_237342_b_ = this.field_237342_b_.func_234949_a_(datapackCodec);
    }

    @Override
    @Nullable
    public CompoundNBT func_230404_D_() {
        return this.field_237364_x_;
    }

    @Override
    public void func_230414_b_(@Nullable CompoundNBT compoundNBT) {
        this.field_237364_x_ = compoundNBT;
    }

    @Override
    public int func_230399_u_() {
        return this.field_237365_y_;
    }

    @Override
    public void func_230396_g_(int n) {
        this.field_237365_y_ = n;
    }

    @Override
    public int func_230400_v_() {
        return this.field_237366_z_;
    }

    @Override
    public void func_230397_h_(int n) {
        this.field_237366_z_ = n;
    }

    @Override
    public void func_230394_a_(UUID uUID) {
        this.field_237337_A_ = uUID;
    }

    @Override
    public void func_230412_a_(String string, boolean bl) {
        this.field_237338_B_.add(string);
        this.field_237339_C_ |= bl;
    }

    @Override
    public boolean func_230405_E_() {
        return this.field_237339_C_;
    }

    @Override
    public Set<String> func_230406_F_() {
        return ImmutableSet.copyOf(this.field_237338_B_);
    }

    @Override
    public IServerWorldInfo func_230407_G_() {
        return this;
    }
}

