/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.rune;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import io.github.noeppi_noeppi.libx.util.BoundingBoxUtils;
import io.github.noeppi_noeppi.libx.util.NBTX;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.ModBlocks;
import mythicbotany.ModItems;
import mythicbotany.ModRecipes;
import mythicbotany.misc.SolidifiedMana;
import mythicbotany.rune.RuneRitualRecipe;
import mythicbotany.rune.TileRuneHolder;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;

public class TileMasterRuneHolder
extends TileRuneHolder
implements ITickableTileEntity {
    private static final ResourceLocation MISSIGNO = new ResourceLocation("minecraft", "missingno");
    private static final Map<Item, Integer> RUNE_COLORS = ImmutableMap.builder().put((Object)vazkii.botania.common.item.ModItems.runeAir, (Object)6861034).put((Object)vazkii.botania.common.item.ModItems.runeSpring, (Object)0xFF919F).put((Object)vazkii.botania.common.item.ModItems.runeSummer, (Object)56813).put((Object)vazkii.botania.common.item.ModItems.runeAutumn, (Object)15057408).put((Object)vazkii.botania.common.item.ModItems.runeWinter, (Object)14736341).put((Object)vazkii.botania.common.item.ModItems.runeLust, (Object)15943377).put((Object)vazkii.botania.common.item.ModItems.runeGluttony, (Object)0x6E6E6E).put((Object)vazkii.botania.common.item.ModItems.runeGreed, (Object)37937).put((Object)vazkii.botania.common.item.ModItems.runeSloth, (Object)12293729).put((Object)vazkii.botania.common.item.ModItems.runeWrath, (Object)0xFF2424).put((Object)vazkii.botania.common.item.ModItems.runeEnvy, (Object)13129958).put((Object)vazkii.botania.common.item.ModItems.runePride, (Object)2896439).put((Object)ModItems.asgardRune, (Object)14796032).put((Object)ModItems.vanaheimRune, (Object)6276936).put((Object)ModItems.alfheimRune, (Object)0xFF76F7).put((Object)ModItems.midgardRune, (Object)1683771).put((Object)ModItems.joetunheimRune, (Object)11626265).put((Object)ModItems.muspelheimRune, (Object)0xBF0000).put((Object)ModItems.niflheimRune, (Object)45503).put((Object)ModItems.nidavellirRune, (Object)0x6F6F6F).put((Object)ModItems.helheimRune, (Object)0x780000).build();
    @Nullable
    private RuneRitualRecipe recipe;
    @Nullable
    private ResourceLocation recipeId;
    private int progress;
    private int transformId;
    private List<ItemStack> consumedStacks = new ArrayList<ItemStack>();
    private CompoundNBT specialNbt = new CompoundNBT();

    public TileMasterRuneHolder(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!(this.recipeId == null || this.recipe != null && this.recipeId.equals((Object)this.recipe.func_199560_c()))) {
            IRecipe foundRecipe = this.field_145850_b.func_199532_z().func_215367_a(this.recipeId).orElse(null);
            if (foundRecipe instanceof RuneRitualRecipe) {
                this.recipe = (RuneRitualRecipe)foundRecipe;
                this.recipeId = this.recipe.func_199560_c();
                this.func_70296_d();
                this.markDispatchable();
            } else {
                this.recipeId = null;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.recipe != null) {
                if (!this.recipeValid(this.recipe, this.transformId)) {
                    this.cancelRecipe();
                } else {
                    if (this.progress == 0) {
                        this.markDispatchable();
                    }
                    ++this.progress;
                    if (this.progress >= this.recipe.getTicks()) {
                        this.getInventory().setStackInSlot(0, ItemStack.field_190927_a);
                        for (ItemStack result : this.recipe.getOutputs()) {
                            ItemEntity ie = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, result.func_77946_l());
                            ie.func_174867_a(40);
                            ie.func_184195_f(true);
                            this.field_145850_b.func_217376_c((Entity)ie);
                        }
                        for (RuneRitualRecipe.RunePosition rune : this.recipe.getRunes()) {
                            BlockPos runePos = this.field_174879_c.func_177982_a(rune.getX(this.transformId), 0, rune.getZ(this.transformId));
                            BlockState state = Objects.requireNonNull(this.field_145850_b).func_180495_p(runePos);
                            if (state.func_177230_c() != ModBlocks.runeHolder) continue;
                            TileRuneHolder tile = (TileRuneHolder)ModBlocks.runeHolder.getTile(this.field_145850_b, runePos);
                            tile.setTarget(null, 0.0, true);
                            ItemStack runeStack = tile.getInventory().getStackInSlot(0);
                            tile.getInventory().setStackInSlot(0, ItemStack.field_190927_a);
                            if (rune.isConsumed() || runeStack.func_190926_b()) continue;
                            ItemEntity ie = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, runeStack);
                            this.field_145850_b.func_217376_c((Entity)ie);
                        }
                        RuneRitualRecipe recipeCopy = this.recipe;
                        this.recipe = null;
                        this.recipeId = null;
                        this.progress = 0;
                        this.transformId = 0;
                        List<ItemStack> consumedStacksCops = this.consumedStacks;
                        this.consumedStacks = new ArrayList<ItemStack>();
                        this.specialNbt = new CompoundNBT();
                        if (recipeCopy.getSpecialOutput() != null) {
                            recipeCopy.getSpecialOutput().apply(this.field_145850_b, this.field_174879_c, consumedStacksCops);
                        }
                        this.markDispatchable();
                    } else {
                        this.updatePatterns(this.recipe, this.transformId, (double)this.progress / (double)this.recipe.getTicks(), false);
                    }
                }
                this.func_70296_d();
            } else {
                this.recipeId = null;
                this.progress = 0;
                this.transformId = 0;
                if (!this.consumedStacks.isEmpty()) {
                    this.consumedStacks = new ArrayList<ItemStack>();
                }
                this.specialNbt = new CompoundNBT();
                this.func_70296_d();
                this.markDispatchable();
            }
        } else if (this.recipe != null && this.progress < this.recipe.getTicks() && this.progress > 0) {
            ++this.progress;
            double progressScaled = (double)this.progress / (double)this.recipe.getTicks();
            this.updatePatterns(this.recipe, this.transformId, progressScaled, false);
            if (this.progress == this.recipe.getTicks() - 1) {
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_218419_B, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.45, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            } else if (this.progress < this.recipe.getTicks() - 2) {
                progressScaled = Math.max(0.0, (double)(this.progress - 2) / (double)this.recipe.getTicks());
                for (RuneRitualRecipe.RunePosition rune : this.recipe.getRunes()) {
                    ItemStack stack;
                    TileEntity runeHolderTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(rune.getX(this.transformId), 0, rune.getZ(this.transformId)));
                    if (!(runeHolderTE instanceof TileRuneHolder) || (stack = ((TileRuneHolder)runeHolderTE).getInventory().getStackInSlot(0)).func_190926_b()) continue;
                    double x = (double)rune.getX(this.transformId) * (1.0 - progressScaled);
                    double y = Math.sin(progressScaled * Math.PI);
                    double z = (double)rune.getZ(this.transformId) * (1.0 - progressScaled);
                    double xr = this.field_145850_b.field_73012_v.nextDouble() * 0.6 - 0.3;
                    double yr = this.field_145850_b.field_73012_v.nextDouble() * 0.6 - 0.3;
                    double zr = this.field_145850_b.field_73012_v.nextDouble() * 0.6 - 0.3;
                    this.field_145850_b.func_195594_a(this.getParticle(stack.func_77973_b()), (double)this.field_174879_c.func_177958_n() + 0.5 + x + xr, (double)this.field_174879_c.func_177956_o() + 0.25 + y + yr, (double)this.field_174879_c.func_177952_p() + 0.5 + z + zr, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void tryStartRitual(PlayerEntity player) {
        this.tryStartRitual(msg -> player.func_145747_a(msg, player.func_110124_au()), mana -> ManaItemHandler.instance().requestManaExact(new ItemStack((IItemProvider)Items.field_221585_m), player, mana.intValue(), false), mana -> ManaItemHandler.instance().requestManaExact(new ItemStack((IItemProvider)Items.field_221585_m), player, mana.intValue(), true));
    }

    public void tryStartRitual(Consumer<ITextComponent> messages, Function<Integer, Boolean> manaTest, Consumer<Integer> manaRequest) {
        if (this.recipe != null) {
            messages.accept((ITextComponent)new TranslationTextComponent("message.mythicbotany.ritual_running").func_240699_a_(TextFormatting.GRAY));
        } else {
            Pair<RuneRitualRecipe, Integer> recipe = this.findRecipe();
            if (recipe == null) {
                messages.accept((ITextComponent)new TranslationTextComponent("message.mythicbotany.ritual_wrong_shape").func_240699_a_(TextFormatting.GRAY));
            } else {
                this.tryStart((RuneRitualRecipe)recipe.getLeft(), (Integer)recipe.getRight(), messages, manaTest, manaRequest);
            }
        }
    }

    @Nullable
    private Pair<RuneRitualRecipe, Integer> findRecipe() {
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return null;
        }
        return this.field_145850_b.func_199532_z().func_241447_a_(ModRecipes.RUNE_RITUAL).stream().flatMap(this::recipeMatches).findFirst().orElse(null);
    }

    private Stream<Pair<RuneRitualRecipe, Integer>> recipeMatches(RuneRitualRecipe recipe) {
        if (!recipe.getCenterRune().test(this.getInventory().getStackInSlot(0))) {
            return Stream.empty();
        }
        int transformId = -1;
        for (int i = 0; i < 8; ++i) {
            if (!this.runePatternMatches(recipe, i)) continue;
            transformId = i;
            break;
        }
        if (transformId < 0) {
            return Stream.empty();
        }
        return Stream.of(Pair.of((Object)recipe, (Object)transformId));
    }

    private void tryStart(RuneRitualRecipe recipe, int transform, Consumer<ITextComponent> messages, Function<Integer, Boolean> manaTest, Consumer<Integer> manaRequest) {
        if (recipe.getMana() > 0 && !manaTest.apply(recipe.getMana()).booleanValue()) {
            messages.accept((ITextComponent)new TranslationTextComponent("message.mythicbotany.ritual_less_mana").func_240699_a_(TextFormatting.GRAY));
            return;
        }
        List inputs = Objects.requireNonNull(this.field_145850_b).func_217394_a(EntityType.field_200765_E, BoundingBoxUtils.expand((Vector3d)new Vector3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5), (double)2.0), e -> true);
        List stacks = inputs.stream().map(e -> MutableTriple.of((Object)e, (Object)e.func_92059_d(), (Object)e.func_92059_d().func_190916_E())).filter(t -> !((ItemStack)t.getMiddle()).func_190926_b()).collect(Collectors.toList());
        ArrayList<ItemStack> consumedStacks = new ArrayList<ItemStack>();
        block0: for (Ingredient ingr : recipe.getInputs()) {
            for (MutableTriple triple : stacks) {
                if ((Integer)triple.getRight() <= 0 || !ingr.test((ItemStack)triple.getMiddle())) continue;
                ItemStack copy = ((ItemStack)triple.getMiddle()).func_77946_l();
                copy.func_190920_e(1);
                consumedStacks.add(copy);
                triple.setRight((Object)((Integer)triple.getRight() - 1));
                continue block0;
            }
            messages.accept((ITextComponent)new TranslationTextComponent("message.mythicbotany.ritual_wrong_items").func_240699_a_(TextFormatting.GRAY));
            return;
        }
        if (recipe.getSpecialInput() != null) {
            Either<IFormattableTextComponent, CompoundNBT> result = recipe.getSpecialInput().apply(this.field_145850_b, this.field_174879_c, recipe);
            Optional tc = result.left();
            if (tc.isPresent()) {
                messages.accept((ITextComponent)((IFormattableTextComponent)tc.get()).func_240699_a_(TextFormatting.GRAY));
                return;
            }
            result.ifRight(nbt -> {
                this.specialNbt = nbt;
            });
        }
        manaRequest.accept(recipe.getMana());
        for (MutableTriple triple : stacks) {
            ItemStack stack = (ItemStack)triple.getMiddle();
            stack.func_190920_e(((Integer)triple.getRight()).intValue());
            ((ItemEntity)triple.getLeft()).func_92058_a(stack);
        }
        this.recipe = recipe;
        this.progress = 0;
        this.transformId = transform;
        this.consumedStacks = consumedStacks;
        this.func_70296_d();
        this.markDispatchable();
    }

    private boolean runePatternMatches(RuneRitualRecipe recipe, int idx) {
        for (RuneRitualRecipe.RunePosition rune : recipe.getRunes()) {
            BlockPos runePos = this.field_174879_c.func_177982_a(rune.getX(idx), 0, rune.getZ(idx));
            BlockState state = Objects.requireNonNull(this.field_145850_b).func_180495_p(runePos);
            if (state.func_177230_c() != ModBlocks.runeHolder) {
                return false;
            }
            TileRuneHolder tile = (TileRuneHolder)ModBlocks.runeHolder.getTile(this.field_145850_b, runePos);
            if (rune.getRune().test(tile.getInventory().getStackInSlot(0))) continue;
            return false;
        }
        return true;
    }

    private void updatePatterns(RuneRitualRecipe recipe, int transformId, double progress, boolean sync) {
        if (transformId < 0 || transformId >= 8) {
            transformId = 0;
        }
        this.setTarget(this.field_174879_c, 0.0, sync);
        for (RuneRitualRecipe.RunePosition rune : recipe.getRunes()) {
            BlockPos runePos = this.field_174879_c.func_177982_a(rune.getX(transformId), 0, rune.getZ(transformId));
            BlockState state = Objects.requireNonNull(this.field_145850_b).func_180495_p(runePos);
            if (state.func_177230_c() != ModBlocks.runeHolder) continue;
            TileRuneHolder tile = (TileRuneHolder)ModBlocks.runeHolder.getTile(this.field_145850_b, runePos);
            tile.setTarget(progress == 0.0 ? null : this.field_174879_c, progress, sync);
        }
    }

    public void cancelRecipe() {
        if (this.field_145850_b != null && this.recipe != null) {
            this.updatePatterns(this.recipe, this.transformId, 0.0, true);
            for (ItemStack stack : this.consumedStacks) {
                ItemEntity ie = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
                this.field_145850_b.func_217376_c((Entity)ie);
            }
            if (this.recipe.getSpecialInput() != null) {
                this.recipe.getSpecialInput().cancel(this.field_145850_b, this.field_174879_c, this.recipe, this.specialNbt);
            }
            SolidifiedMana.dropMana(this.field_145850_b, this.field_174879_c, this.recipe.getMana());
            this.recipe = null;
            this.recipeId = null;
            this.progress = 0;
            this.transformId = 0;
            this.consumedStacks = new ArrayList<ItemStack>();
            this.specialNbt = new CompoundNBT();
            this.func_70296_d();
            this.markDispatchable();
        }
    }

    private boolean recipeValid(RuneRitualRecipe recipe, int transformId) {
        if (!recipe.getCenterRune().test(this.getInventory().getStackInSlot(0))) {
            return false;
        }
        if (transformId < 0 || transformId >= 8) {
            transformId = 0;
        }
        for (RuneRitualRecipe.RunePosition rune : recipe.getRunes()) {
            BlockPos runePos = this.field_174879_c.func_177982_a(rune.getX(transformId), 0, rune.getZ(transformId));
            BlockState state = Objects.requireNonNull(this.field_145850_b).func_180495_p(runePos);
            if (state.func_177230_c() != ModBlocks.runeHolder) {
                return false;
            }
            TileRuneHolder tile = (TileRuneHolder)ModBlocks.runeHolder.getTile(this.field_145850_b, runePos);
            if (rune.getRune().test(tile.getInventory().getStackInSlot(0))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        ResourceLocation id = NBTX.getRL((CompoundNBT)nbt, (String)"recipe", (ResourceLocation)MISSIGNO);
        this.recipeId = id == MISSIGNO ? null : id;
        this.progress = nbt.func_74762_e("progress");
        this.transformId = nbt.func_74762_e("transform");
        if (nbt.func_150297_b("Consumed", 9)) {
            ListNBT consumed = nbt.func_150295_c("Consumed", 10);
            this.consumedStacks = new ArrayList<ItemStack>();
            for (int i = 0; i < consumed.size(); ++i) {
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)consumed.func_150305_b(i));
                if (stack.func_190926_b()) continue;
                this.consumedStacks.add(stack);
            }
        } else {
            this.consumedStacks = new ArrayList<ItemStack>();
        }
        this.specialNbt = nbt.func_74775_l("SpecialInputData").func_74737_b();
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        NBTX.putRL((CompoundNBT)nbt, (String)"recipe", (ResourceLocation)(this.recipe == null ? MISSIGNO : this.recipe.func_199560_c()));
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("transform", this.transformId);
        ListNBT consumed = new ListNBT();
        for (ItemStack stack : this.consumedStacks) {
            consumed.add((Object)stack.serializeNBT());
        }
        nbt.func_218657_a("Consumed", (INBT)consumed);
        nbt.func_218657_a("SpecialInputData", (INBT)this.specialNbt.func_74737_b());
        return super.func_189515_b(nbt);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (!this.field_145850_b.field_72995_K) {
            NBTX.putRL((CompoundNBT)nbt, (String)"recipe", (ResourceLocation)(this.recipe == null ? MISSIGNO : this.recipe.func_199560_c()));
            nbt.func_74768_a("progress", this.progress);
            nbt.func_74768_a("transform", this.transformId);
        }
        return nbt;
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        super.handleUpdateTag(state, nbt);
        if (this.field_145850_b.field_72995_K) {
            ResourceLocation id = NBTX.getRL((CompoundNBT)nbt, (String)"recipe", (ResourceLocation)MISSIGNO);
            this.recipeId = id == MISSIGNO ? null : id;
            this.progress = nbt.func_74762_e("progress");
            this.transformId = nbt.func_74762_e("transform");
        }
    }

    private IParticleData getParticle(Item rune) {
        if (rune == ModItems.fimbultyrTablet) {
            return new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Items.field_221696_bj));
        }
        if (rune == vazkii.botania.common.item.ModItems.runeMana) {
            return WispParticleData.wisp((float)0.2f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.3f);
        }
        if (rune == vazkii.botania.common.item.ModItems.runeFire) {
            return ParticleTypes.field_197631_x;
        }
        if (rune == vazkii.botania.common.item.ModItems.runeAir) {
            return ParticleTypes.field_197613_f;
        }
        if (rune == vazkii.botania.common.item.ModItems.runeEarth) {
            return new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Items.field_221582_j));
        }
        if (rune == vazkii.botania.common.item.ModItems.runeWater) {
            return ParticleTypes.field_206864_X;
        }
        int color = RUNE_COLORS.getOrDefault(rune, 0xFFFFFF);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return SparkleParticleData.sparkle((float)2.0f, (float)r, (float)g, (float)b, (int)6);
    }
}

