/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.pylon;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.ModBlocks;
import mythicbotany.MythicBotany;
import mythicbotany.pylon.BlockAlfsteelPylon;
import mythicbotany.pylon.TileAlfsteelPylon;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.core.helper.ShaderWrappedRenderLayer;
import vazkii.botania.client.model.ModelPylonNatura;
import vazkii.botania.mixin.AccessorRenderState;

public class RenderAlfsteelPylon
extends TileEntityRenderer<TileAlfsteelPylon> {
    public static final ResourceLocation TEXTURE = new ResourceLocation(MythicBotany.getInstance().modid, "textures/model/pylon_alfsteel.png");
    public static final RenderType PYLON_GLOW = RenderAlfsteelPylon.initFieldPylonGlow(false);
    public static final RenderType PYLON_GLOW_ITEM = RenderAlfsteelPylon.initFieldPylonGlow(true);
    private final ModelPylonNatura model = new ModelPylonNatura();
    private ItemCameraTransforms.TransformType forceTransform = ItemCameraTransforms.TransformType.NONE;

    private static RenderType initFieldPylonGlow(boolean forItem) {
        RenderType.State.Builder glState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(TEXTURE, false, false)).func_228726_a_(AccessorRenderState.getTranslucentTransparency()).func_228716_a_(new RenderState.DiffuseLightingState(true)).func_228713_a_(new RenderState.AlphaState(0.0f)).func_228714_a_(new RenderState.CullState(false)).func_228719_a_(new RenderState.LightmapState(true));
        if (forItem) {
            glState = glState.func_228721_a_(AccessorRenderState.getItemEntityTarget());
        }
        RenderType.Type layer = RenderType.func_228632_a_((String)(MythicBotany.getInstance().modid + ":alfsteel_pylon_glow" + (forItem ? "_item" : "")), (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)128, (RenderType.State)glState.func_228728_a_(false));
        return ShaderHelper.useShaders() ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.PYLON_GLOW, null, (RenderType)layer) : layer;
    }

    public RenderAlfsteelPylon(TileEntityRendererDispatcher manager) {
        super(manager);
    }

    public void render(@Nonnull TileAlfsteelPylon pylon, float partialTicks, @Nonnull MatrixStack ms, @Nonnull IRenderTypeBuffer buffer, int light, int overlay) {
        this.doRender(pylon, partialTicks, ms, buffer, light, overlay);
    }

    public void doRender(@Nullable TileAlfsteelPylon pylon, float pticks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        boolean direct = pylon == null && (this.forceTransform == ItemCameraTransforms.TransformType.GUI || this.forceTransform.func_241716_a_());
        RenderType glow = direct ? PYLON_GLOW_ITEM : PYLON_GLOW;
        ms.func_227860_a_();
        float worldTime = (float)ClientTickHandler.ticksInGame + pticks;
        worldTime += pylon == null ? 0.0f : (float)new Random(pylon.func_174877_v().hashCode()).nextInt(360);
        ms.func_227861_a_(0.0, pylon == null ? 1.35 : 1.5, 0.0);
        ms.func_227862_a_(1.0f, -1.0f, -1.0f);
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 0.0, -0.5);
        if (pylon != null) {
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(worldTime * 1.5f));
        }
        RenderType layer = RenderType.func_228644_e_((ResourceLocation)TEXTURE);
        IVertexBuilder buffer = buffers.getBuffer(layer);
        this.model.renderRing(ms, buffer, light, overlay);
        if (pylon != null) {
            ms.func_227861_a_(0.0, Math.sin((double)worldTime / 20.0) / 20.0 - 0.025, 0.0);
        }
        ms.func_227865_b_();
        ms.func_227860_a_();
        if (pylon != null) {
            ms.func_227861_a_(0.0, Math.sin((double)worldTime / 20.0) / 17.5, 0.0);
        }
        ms.func_227861_a_(0.5, 0.0, -0.5);
        if (pylon != null) {
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-worldTime));
        }
        buffer = buffers.getBuffer(glow);
        this.model.renderCrystal(ms, buffer, light, overlay);
        ms.func_227865_b_();
        ms.func_227865_b_();
    }

    public static class TEISR
    extends ItemStackTileEntityRenderer {
        private static final LazyValue<TileAlfsteelPylon> DUMMY = new LazyValue(() -> new TileAlfsteelPylon(ModBlocks.alfsteelPylon.getTileType()));

        public void func_239207_a_(ItemStack stack, @Nonnull ItemCameraTransforms.TransformType type, @Nonnull MatrixStack ms, @Nonnull IRenderTypeBuffer buffer, int light, int overlay) {
            if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockAlfsteelPylon) {
                TileEntityRenderer r = TileEntityRendererDispatcher.field_147556_a.func_147547_b((TileEntity)DUMMY.func_179281_c());
                ((RenderAlfsteelPylon)r).forceTransform = type;
                ((RenderAlfsteelPylon)r).doRender(null, 0.0f, ms, buffer, light, overlay);
            }
        }
    }
}

