/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.network;

import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.network.NetworkX;
import mythicbotany.network.AlfSwordLeftClickHandler;
import mythicbotany.network.AlfSwordLeftClickSerializer;
import mythicbotany.network.InfusionHandler;
import mythicbotany.network.InfusionSerializer;
import mythicbotany.network.ItemMagnetImmunityHandler;
import mythicbotany.network.ItemMagnetImmunitySerializer;
import mythicbotany.network.ParticleHandler;
import mythicbotany.network.ParticleSerializer;
import mythicbotany.network.PylonHandler;
import mythicbotany.network.PylonSerializer;
import mythicbotany.network.UpdatePortalTimeHandler;
import mythicbotany.network.UpdatePortalTimeSerializer;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;

public class MythicNetwork
extends NetworkX {
    public MythicNetwork(ModX mod) {
        super(mod);
    }

    protected String getProtocolVersion() {
        return "4";
    }

    public void registerPackets() {
        this.register(new ParticleSerializer(), () -> ParticleHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new InfusionSerializer(), () -> InfusionHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new PylonSerializer(), () -> PylonHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new UpdatePortalTimeSerializer(), () -> UpdatePortalTimeHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new ItemMagnetImmunitySerializer(), () -> ItemMagnetImmunityHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new AlfSwordLeftClickSerializer(), () -> AlfSwordLeftClickHandler::handle, NetworkDirection.PLAY_TO_SERVER);
    }

    public void spawnParticle(World world, BasicParticleType particle, int amount, double x, double y, double z, double xm, double ym, double zm, double xd, double yd, double zd) {
        this.spawnParticle(world, particle, amount, x, y, z, xm, ym, zm, xd, yd, zd, false);
    }

    public void spawnParticle(World world, BasicParticleType particle, int amount, double x, double y, double z, double xm, double ym, double zm, double xd, double yd, double zd, boolean randomizePosition) {
        if (world.field_72995_K) {
            for (int i = 0; i < amount; ++i) {
                if (randomizePosition) {
                    world.func_195594_a((IParticleData)particle, x + world.field_73012_v.nextDouble() * 2.0 * xd - xd, y + world.field_73012_v.nextDouble() * 2.0 * yd - yd, z + world.field_73012_v.nextDouble() * 2.0 * zd - zd, xm, ym, zm);
                    continue;
                }
                world.func_195594_a((IParticleData)particle, x, y, z, xm + world.field_73012_v.nextDouble() * 2.0 * xd - xd, ym + world.field_73012_v.nextDouble() * 2.0 * yd - yd, zm + world.field_73012_v.nextDouble() * 2.0 * zd - zd);
            }
        } else {
            this.instance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, 100.0, world.func_234923_W_())), (Object)new ParticleSerializer.ParticleMessage(particle.getRegistryName(), world.func_234923_W_().getRegistryName(), x, y, z, amount, xm, ym, zm, xd, yd, zd, randomizePosition));
        }
    }

    public void spawnInfusionParticles(World world, BlockPos pos, double progress, int fromColor, int toColor) {
        if (!world.field_72995_K) {
            this.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(pos)), (Object)new InfusionSerializer.InfusionMessage(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world.func_234923_W_().getRegistryName(), progress, fromColor, toColor));
        }
    }

    public void updatePortalTime(ServerPlayerEntity player, int portalTime) {
        if (!player.func_130014_f_().field_72995_K) {
            this.instance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UpdatePortalTimeSerializer.UpdatePortalTimeMessage(portalTime));
        }
    }

    public void setItemMagnetImmune(ItemEntity ie) {
        if (!ie.field_70170_p.field_72995_K && !ie.getPersistentData().func_74767_n("PreventRemoteMovement")) {
            ie.getPersistentData().func_74757_a("PreventRemoteMovement", true);
            this.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> ie), (Object)new ItemMagnetImmunitySerializer.ItemMagnetImmunityMessage(ie.func_145782_y(), true, ie.func_226277_ct_(), ie.func_226278_cu_(), ie.func_226281_cx_()));
        }
    }

    public void removeItemMagnetImmune(ItemEntity ie) {
        if (!ie.field_70170_p.field_72995_K && ie.getPersistentData().func_74767_n("PreventRemoteMovement")) {
            ie.getPersistentData().func_74757_a("PreventRemoteMovement", false);
            this.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> ie), (Object)new ItemMagnetImmunitySerializer.ItemMagnetImmunityMessage(ie.func_145782_y(), false, ie.func_226277_ct_(), ie.func_226278_cu_(), ie.func_226281_cx_()));
        }
    }
}

