/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.functionalflora.base;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import mythicbotany.functionalflora.base.FunctionalFlowerBase;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.IModelData;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.tile.RenderTileSpecialFlower;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;

public class RenderFunctionalFlower<T extends FunctionalFlowerBase>
extends TileEntityRenderer<T> {
    public RenderFunctionalFlower(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(@Nonnull T te, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        RayTraceResult ray;
        LivingEntity view;
        if (((FunctionalFlowerBase)((Object)te)).isFloating() && !((Boolean)ConfigHandler.CLIENT.staticFloaters.get()).booleanValue()) {
            IModelData data = te.getModelData();
            matrixStack.func_227860_a_();
            double worldTime = (float)ClientTickHandler.ticksInGame + partialTicks;
            if (te.func_145831_w() != null) {
                worldTime += (double)new Random(te.func_174877_v().hashCode()).nextInt(1000);
            }
            matrixStack.func_227861_a_(0.5, 0.0, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-((float)worldTime * 0.5f)));
            matrixStack.func_227861_a_(-0.5, (double)((float)Math.sin(worldTime * (double)0.05f) * 0.1f), 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(4.0f * (float)Math.sin(worldTime * (double)0.04f)));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
            BlockState state = te.func_195044_w();
            IBakedModel ibakedmodel = brd.func_184389_a(state);
            brd.func_175019_b().renderModel(matrixStack.func_227866_c_(), buffer.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)state, (boolean)false)), state, ibakedmodel, 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn, data);
            matrixStack.func_227865_b_();
        }
        if (Minecraft.func_71410_x().field_175622_Z instanceof LivingEntity && ItemMonocle.hasMonocle((LivingEntity)(view = (LivingEntity)Minecraft.func_71410_x().field_175622_Z)) && (ray = Minecraft.func_71410_x().field_71476_x) != null && ray.func_216346_c() == RayTraceResult.Type.BLOCK) {
            RadiusDescriptor descriptor;
            BlockPos pos = ((BlockRayTraceResult)ray).func_216350_a();
            if ((te.func_174877_v().equals((Object)pos) || RenderFunctionalFlower.hasBindingAttempt(view, te.func_174877_v())) && (descriptor = ((FunctionalFlowerBase)((Object)te)).getRadius()) != null) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)(-te.func_174877_v().func_177958_n()), (double)(-te.func_174877_v().func_177956_o()), (double)(-te.func_174877_v().func_177952_p()));
                if (descriptor.isCircle()) {
                    RenderFunctionalFlower.renderCircle(matrixStack, buffer, descriptor.getSubtileCoords(), descriptor.getCircleRadius());
                } else {
                    RenderTileSpecialFlower.renderRectangle((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (AxisAlignedBB)descriptor.getAABB(), (boolean)true, null, (byte)32);
                }
                matrixStack.func_227865_b_();
            }
        }
    }

    public static boolean hasBindingAttempt(LivingEntity view, BlockPos tilePos) {
        ItemStack stackHeld = PlayerHelper.getFirstHeldItem((LivingEntity)view, (Item)ModItems.twigWand);
        if (!stackHeld.func_190926_b() && ItemTwigWand.getBindMode((ItemStack)stackHeld)) {
            Optional coords = ItemTwigWand.getBindingAttempt((ItemStack)stackHeld);
            return coords.isPresent() && ((BlockPos)coords.get()).equals((Object)tilePos);
        }
        return false;
    }

    public static void renderCircle(MatrixStack matrixStack, IRenderTypeBuffer buffer, BlockPos center, double radius) {
        matrixStack.func_227860_a_();
        double x = (double)center.func_177958_n() + 0.5;
        double y = center.func_177956_o();
        double z = (double)center.func_177952_p() + 0.5;
        matrixStack.func_227861_a_(x, y, z);
        int color = MathHelper.func_181758_c((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int alpha = 32;
        float f = 0.0625f;
        int totalAngles = 360;
        int drawAngles = 360;
        int step = totalAngles / drawAngles;
        radius -= (double)f;
        IVertexBuilder vertexBuffer = buffer.getBuffer(RenderHelper.CIRCLE);
        Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_();
        Runnable centerFunc = () -> vertexBuffer.func_227888_a_(mat, 0.0f, f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
        ArrayList<Runnable> vertexFuncs = new ArrayList<Runnable>();
        for (int i = 0; i < totalAngles + 1; i += step) {
            double rad = (double)(totalAngles - i) * Math.PI / 180.0;
            float xp = (float)(Math.cos(rad) * radius);
            float zp = (float)(Math.sin(rad) * radius);
            vertexFuncs.add(() -> vertexBuffer.func_227888_a_(mat, xp, f, zp).func_225586_a_(r, g, b, alpha).func_181675_d());
        }
        RenderHelper.triangleFan((Runnable)centerFunc, vertexFuncs);
        radius += (double)f;
        float f1 = f + f / 4.0f;
        int alpha2 = 64;
        centerFunc = () -> vertexBuffer.func_227888_a_(mat, 0.0f, f1, 0.0f).func_225586_a_(r, g, b, alpha2).func_181675_d();
        vertexFuncs.clear();
        for (int i = 0; i < totalAngles + 1; i += step) {
            double rad = (double)(totalAngles - i) * Math.PI / 180.0;
            float xp = (float)(Math.cos(rad) * radius);
            float zp = (float)(Math.sin(rad) * radius);
            vertexFuncs.add(() -> vertexBuffer.func_227888_a_(mat, xp, f1, zp).func_225586_a_(r, g, b, alpha2).func_181675_d());
        }
        RenderHelper.triangleFan((Runnable)centerFunc, vertexFuncs);
        matrixStack.func_227865_b_();
    }
}

