/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.functionalflora.base;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.BlockBase;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.functionalflora.base.BlockFloatingFunctionalFlower;
import mythicbotany.functionalflora.base.FunctionalFlowerBase;
import mythicbotany.functionalflora.base.RenderFunctionalFlower;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.ModBlocks;

public class BlockFunctionalFlower<T extends FunctionalFlowerBase>
extends BlockBase
implements IWandHUD,
IWandable,
IPlantable {
    public static final ResourceLocation POOL_ID = new ResourceLocation("botania", "mana_pool");
    public static final ResourceLocation SPREADER_ID = new ResourceLocation("botania", "mana_spreader");
    private static final VoxelShape SHAPE = BlockFunctionalFlower.func_208617_a((double)4.8, (double)0.0, (double)4.8, (double)12.8, (double)16.0, (double)12.8);
    private final Class<T> teClass;
    private final Constructor<T> teCtor;
    private final TileEntityType<T> teType;
    private final BlockFloatingFunctionalFlower<T> floatingBlock;
    public final boolean isGenerating;

    public BlockFunctionalFlower(ModX mod, Class<T> teClass, AbstractBlock.Properties properties, boolean isGenerating) {
        this(mod, teClass, properties.func_200942_a().func_235828_a_((state, world, pos) -> false).func_200946_b().func_200947_a(SoundType.field_185850_c), new Item.Properties(), isGenerating);
    }

    public BlockFunctionalFlower(ModX mod, Class<T> teClass, AbstractBlock.Properties properties, Item.Properties itemProperties, boolean isGenerating) {
        super(mod, properties.func_200942_a().func_235828_a_((state, world, pos) -> false).func_200946_b().func_200947_a(SoundType.field_185850_c), itemProperties);
        this.teClass = teClass;
        this.isGenerating = isGenerating;
        this.floatingBlock = new BlockFloatingFunctionalFlower(mod, this);
        try {
            this.teCtor = teClass.getConstructor(TileEntityType.class);
        }
        catch (ReflectiveOperationException e) {
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            throw new RuntimeException("Could not get constructor for tile entity " + teClass + ".", e);
        }
        this.teType = new TileEntityType(() -> {
            try {
                return (FunctionalFlowerBase)((Object)((Object)this.teCtor.newInstance(this.getTileType())));
            }
            catch (ReflectiveOperationException e) {
                if (e.getCause() != null) {
                    e.getCause().printStackTrace();
                }
                throw new RuntimeException("Could not create TileEntity of type " + teClass + ".", e);
            }
        }, (Set)ImmutableSet.of((Object)((Object)this), this.floatingBlock), null);
    }

    public Set<Object> getAdditionalRegisters() {
        return ImmutableSet.builder().addAll((Iterable)super.getAdditionalRegisters()).add(this.teType).build();
    }

    public Map<String, Object> getNamedAdditionalRegisters() {
        return ImmutableMap.of((Object)"floating", this.floatingBlock);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(ResourceLocation id, Consumer<Runnable> defer) {
        ClientRegistry.bindTileEntityRenderer(this.teType, RenderFunctionalFlower::new);
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228641_d_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(MatrixStack matrixStack, Minecraft minecraft, World world, BlockPos pos) {
        T te = this.getTile(world, pos);
        String name = I18n.func_135052_a((String)this.func_149739_a(), (Object[])new Object[0]);
        BotaniaAPIClient.instance().drawComplexManaHUD(matrixStack, ((FunctionalFlowerBase)((Object)te)).color, ((FunctionalFlowerBase)((Object)te)).getCurrentMana(), ((FunctionalFlowerBase)((Object)te)).maxMana, name, new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(this.isGenerating ? SPREADER_ID : POOL_ID)), ((FunctionalFlowerBase)((Object)te)).isValidBinding());
    }

    public boolean onUsedByWand(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction side) {
        if (world.field_72995_K) {
            LibX.getNetwork().requestTE(world, pos);
        }
        return true;
    }

    public boolean func_149740_M(@Nonnull BlockState state) {
        return true;
    }

    public int func_180641_l(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        T te = this.getTile(world, pos);
        if (((FunctionalFlowerBase)((Object)te)).getCurrentMana() > 0) {
            return 1 + (int)((double)((FunctionalFlowerBase)((Object)te)).getCurrentMana() / (double)((FunctionalFlowerBase)((Object)te)).maxMana * 14.0);
        }
        return 0;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext ctx) {
        Vector3d shift = state.func_191059_e(world, pos);
        return SHAPE.func_197751_a(shift.field_72450_a, shift.field_72448_b, shift.field_72449_c);
    }

    @Nonnull
    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    @Nonnull
    public BlockState func_196271_a(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld world, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        return !state.func_196955_c((IWorldReader)world, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    protected boolean isValidGround(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_203425_a(Blocks.field_196658_i) || state.func_203425_a(Blocks.field_150346_d) || state.func_203425_a(Blocks.field_196660_k) || state.func_203425_a(Blocks.field_196661_l) || state.func_203425_a(Blocks.field_150458_ak) || state.func_203425_a(ModBlocks.enchantedSoil) || state.func_203425_a(Blocks.field_150391_bh) || state.canSustainPlant(world, pos, Direction.UP, (IPlantable)this);
    }

    public boolean func_196260_a(@Nonnull BlockState state, @Nonnull IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.isValidGround(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    public boolean func_200123_i(BlockState state, @Nonnull IBlockReader reader, @Nonnull BlockPos pos) {
        return state.func_204520_s().func_206888_e();
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull PathType type) {
        return type == PathType.AIR && !this.field_235688_at_ || super.func_196266_a(state, worldIn, pos, type);
    }

    public void func_190948_a(@Nonnull ItemStack stack, @Nullable IBlockReader world, @Nonnull List<ITextComponent> list, @Nonnull ITooltipFlag flag) {
        super.func_190948_a(stack, world, list, flag);
        if (this.isGenerating) {
            list.add((ITextComponent)new TranslationTextComponent("botania.flowerType.generating").func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.ITALIC}));
        } else {
            list.add((ITextComponent)new TranslationTextComponent("botania.flowerType.functional").func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.ITALIC}));
        }
        list.add((ITextComponent)new TranslationTextComponent("block." + this.mod.modid + "." + this.getRegistryName().func_110623_a() + ".description").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
    }

    public boolean func_220074_n(@Nonnull BlockState state) {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public T createTileEntity(BlockState state, IBlockReader world) {
        return (T)((Object)((FunctionalFlowerBase)this.teType.func_200968_a()));
    }

    public T getTile(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !this.teClass.isAssignableFrom(te.getClass())) {
            throw new IllegalStateException("Expected a tile entity of type " + this.teClass + " at " + world + " " + pos + ", got" + te);
        }
        return (T)((Object)((FunctionalFlowerBase)te));
    }

    public TileEntityType<T> getTileType() {
        return this.teType;
    }

    public BlockFloatingFunctionalFlower<T> getFloatingBlock() {
        return this.floatingBlock;
    }

    @Nonnull
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }
}

