/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.functionalflora;

import com.google.common.collect.ImmutableSet;
import io.github.noeppi_noeppi.libx.LibX;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.compat.CauldronCompat;
import mythicbotany.functionalflora.base.FunctionalFlowerBase;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import vazkii.botania.api.item.IPetalApothecary;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.client.fx.WispParticleData;

public class Aquapanthus
extends FunctionalFlowerBase {
    public static final int MAX_TICK_TO_NEXT_CHECK = 5;
    public static final int MANA_PER_TICK = 2;
    public static final int TICKS_TO_FILL = 20;
    public static final Set<ResourceLocation> FILLING_SLOW_IDS = ImmutableSet.of((Object)new ResourceLocation("exnihilosequentia", "barrel_wood"), (Object)new ResourceLocation("exnihilosequentia", "barrel_stone"), (Object)new ResourceLocation("excompressum", "oak_crucible"), (Object)new ResourceLocation("excompressum", "spruce_crucible"), (Object)new ResourceLocation("excompressum", "birch_crucible"), (Object)new ResourceLocation("excompressum", "jungle_crucible"), (Object[])new ResourceLocation[]{new ResourceLocation("excompressum", "acacia_crucible"), new ResourceLocation("excompressum", "dark_oak_crucible")});
    public static final Set<ResourceLocation> FILLING_FAST_IDS = ImmutableSet.of((Object)new ResourceLocation("exnihilosequentia", "crucible_wood"), (Object)new ResourceLocation("exnihilosequentia", "crucible_fired"));
    private transient int tickToNextCheck = 0;
    @Nullable
    private BlockPos currentlyFilling = null;
    private int fillingSince = 0;

    public Aquapanthus(TileEntityType<?> tileEntityType) {
        super(tileEntityType, 0x4444FF, false);
    }

    @Override
    protected void tickFlower() {
        block11: {
            if (!this.field_145850_b.field_72995_K) {
                if (this.currentlyFilling != null) {
                    if (this.mana >= 2) {
                        if (this.fill()) {
                            this.mana = MathHelper.func_76125_a((int)(this.mana - 2), (int)0, (int)this.maxMana);
                            this.didWork = true;
                            ++this.fillingSince;
                        } else {
                            this.fillingSince = 0;
                            this.currentlyFilling = null;
                        }
                    }
                    LibX.getNetwork().updateTE(this.field_145850_b, this.field_174879_c);
                    this.func_70296_d();
                } else {
                    if (this.tickToNextCheck > 0) {
                        --this.tickToNextCheck;
                        return;
                    }
                    this.tickToNextCheck = 5;
                    BlockPos basePos = this.field_174879_c.func_185334_h();
                    for (int xd = -3; xd <= 3; ++xd) {
                        for (int zd = -3; zd <= 3; ++zd) {
                            TileEntity te;
                            BlockPos pos = basePos.func_177982_a(xd, 0, zd);
                            BlockState state = this.field_145850_b.func_180495_p(pos);
                            if (!this.canFill(state, te = this.field_145850_b.func_175625_s(pos))) continue;
                            this.currentlyFilling = pos;
                            this.fillingSince = 0;
                            this.func_70296_d();
                            break block11;
                        }
                    }
                }
            } else if (this.currentlyFilling != null && this.fillingSince > 0) {
                double progress = (double)this.fillingSince / 20.0;
                double x = (double)(this.currentlyFilling.func_177958_n() - this.field_174879_c.func_177958_n()) * progress + (double)this.field_174879_c.func_177958_n() + 0.5;
                double y = (double)this.field_174879_c.func_177956_o() + 1.5 * Math.sin(progress * Math.PI);
                double z = (double)(this.currentlyFilling.func_177952_p() - this.field_174879_c.func_177952_p()) * progress + (double)this.field_174879_c.func_177952_p() + 0.5;
                double xd = (double)(this.currentlyFilling.func_177958_n() - this.field_174879_c.func_177958_n()) * progress / 10.0;
                double yd = Math.sin(progress * Math.PI) / 10.0;
                double zd = (double)(this.currentlyFilling.func_177952_p() - this.field_174879_c.func_177952_p()) * progress / 10.0;
                WispParticleData data = WispParticleData.wisp((float)0.85f, (float)0.1f, (float)0.1f, (float)1.0f, (float)0.25f);
                this.field_145850_b.func_195594_a((IParticleData)data, x, y, z, xd, yd, zd);
                data = WispParticleData.wisp((float)((float)Math.random() * 0.1f + 0.1f), (float)0.2f, (float)0.2f, (float)1.0f, (float)0.9f);
                this.field_145850_b.func_195594_a((IParticleData)data, x, y, z, (double)((float)(Math.random() - 0.5) * 0.05f), (double)((float)(Math.random() - 0.5) * 0.05f), (double)((float)(Math.random() - 0.5) * 0.05f));
            }
        }
    }

    private boolean canFill(BlockState state, @Nullable TileEntity te) {
        if (state.func_177230_c() == Blocks.field_150383_bp && (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a) < 3 && CauldronCompat.canFill(state, te)) {
            return true;
        }
        if (te instanceof IPetalApothecary && ((IPetalApothecary)te).getFluid() == IPetalApothecary.State.EMPTY) {
            return true;
        }
        if ((FILLING_SLOW_IDS.contains(state.func_177230_c().getRegistryName()) || FILLING_FAST_IDS.contains(state.func_177230_c().getRegistryName())) && te != null) {
            IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.UP).orElse(null);
            if (handler != null) {
                int filled = FILLING_FAST_IDS.contains(state.func_177230_c().getRegistryName()) ? handler.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.SIMULATE) : handler.fill(new FluidStack((Fluid)Fluids.field_204546_a, 334), IFluidHandler.FluidAction.SIMULATE);
                return filled > 0 && handler.getFluidInTank(0).getAmount() < handler.getTankCapacity(0);
            }
            return false;
        }
        return false;
    }

    private boolean fill() {
        BlockState state = this.field_145850_b.func_180495_p(this.currentlyFilling);
        TileEntity te = this.field_145850_b.func_175625_s(this.currentlyFilling);
        if (state.func_177230_c() == Blocks.field_150383_bp && (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a) < 3 || te instanceof IPetalApothecary && ((IPetalApothecary)te).getFluid() == IPetalApothecary.State.EMPTY) {
            if (this.fillingSince >= 20) {
                if (state.func_177230_c() == Blocks.field_150383_bp) {
                    this.field_145850_b.func_175656_a(this.currentlyFilling, (BlockState)state.func_206870_a((Property)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)((Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a) + 1), (int)0, (int)3))));
                } else if (te instanceof IPetalApothecary) {
                    ((IPetalApothecary)te).setFluid(IPetalApothecary.State.WATER);
                    te.func_70296_d();
                }
                return false;
            }
            return true;
        }
        if ((FILLING_SLOW_IDS.contains(state.func_177230_c().getRegistryName()) || FILLING_FAST_IDS.contains(state.func_177230_c().getRegistryName())) && te != null) {
            if (this.fillingSince >= 20) {
                IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.UP).orElse(null);
                if (handler != null) {
                    if (FILLING_FAST_IDS.contains(state.func_177230_c().getRegistryName())) {
                        handler.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
                    } else {
                        handler.fill(new FluidStack((Fluid)Fluids.field_204546_a, 334), IFluidHandler.FluidAction.EXECUTE);
                    }
                    te.func_70296_d();
                }
                return false;
            }
            return this.canFill(state, te);
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.field_174879_c, 3);
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState stateIn, @Nonnull CompoundNBT nbtIn) {
        super.func_230337_a_(stateIn, nbtIn);
        if (nbtIn.func_74764_b("waterFilling")) {
            CompoundNBT fillingTag = nbtIn.func_74775_l("waterFilling");
            this.currentlyFilling = new BlockPos(fillingTag.func_74762_e("x"), fillingTag.func_74762_e("y"), fillingTag.func_74762_e("z"));
        } else {
            this.currentlyFilling = null;
        }
        this.fillingSince = nbtIn.func_74762_e("filling_since");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        if (this.currentlyFilling != null) {
            CompoundNBT fillingTag = new CompoundNBT();
            fillingTag.func_74768_a("x", this.currentlyFilling.func_177958_n());
            fillingTag.func_74768_a("y", this.currentlyFilling.func_177956_o());
            fillingTag.func_74768_a("z", this.currentlyFilling.func_177952_p());
            compound.func_218657_a("waterFilling", (INBT)fillingTag);
            compound.func_74768_a("filling_since", this.fillingSince);
        }
        return super.func_189515_b(compound);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        if (!this.field_145850_b.field_72995_K) {
            if (this.currentlyFilling != null) {
                CompoundNBT fillingTag = new CompoundNBT();
                fillingTag.func_74768_a("x", this.currentlyFilling.func_177958_n());
                fillingTag.func_74768_a("y", this.currentlyFilling.func_177956_o());
                fillingTag.func_74768_a("z", this.currentlyFilling.func_177952_p());
                updateTag.func_218657_a("waterFilling", (INBT)fillingTag);
            }
            updateTag.func_74768_a("filling_since", this.fillingSince);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        if (this.field_145850_b.field_72995_K) {
            if (tag.func_74764_b("waterFilling")) {
                CompoundNBT fillingTag = tag.func_74775_l("waterFilling");
                this.currentlyFilling = new BlockPos(fillingTag.func_74762_e("x"), fillingTag.func_74762_e("y"), fillingTag.func_74762_e("z"));
            } else {
                this.currentlyFilling = null;
            }
            this.fillingSince = tag.func_74762_e("filling_since");
        }
        super.handleUpdateTag(state, tag);
    }
}

