/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alftools;

import com.google.common.collect.ImmutableSet;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mythicbotany.ModItems;
import mythicbotany.MythicBotany;
import mythicbotany.pylon.PylonRepairable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.relic.ItemThorRing;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class AlfsteelPick
extends ItemTerraPick
implements PylonRepairable,
Registerable {
    private static final Set<Material> MATERIALS = ImmutableSet.of((Object)Material.field_151576_e, (Object)Material.field_151573_f, (Object)Material.field_151588_w, (Object)Material.field_151592_s, (Object)Material.field_76233_E, (Object)Material.field_151574_g, (Object[])new Material[]{Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B});

    public AlfsteelPick(Item.Properties props) {
        super(props.func_200918_c(4600));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(ResourceLocation id, Consumer<Runnable> defer) {
        defer.accept(() -> {
            ItemModelsProperties.func_239418_a_((Item)ModItems.alfsteelPick, (ResourceLocation)new ResourceLocation(MythicBotany.getInstance().modid, "tipped"), (stack, world, entity) -> AlfsteelPick.isTipped((ItemStack)stack) ? 1.0f : 0.0f);
            ItemModelsProperties.func_239418_a_((Item)ModItems.alfsteelPick, (ResourceLocation)new ResourceLocation(MythicBotany.getInstance().modid, "active"), (stack, world, entity) -> AlfsteelPick.isEnabled((ItemStack)stack) ? 1.0f : 0.0f);
        });
    }

    public int getManaPerDamage() {
        return 2 * super.getManaPerDamage();
    }

    public void breakOtherBlock(PlayerEntity player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        World world;
        BlockState state;
        if (AlfsteelPick.isEnabled((ItemStack)stack) && (MATERIALS.contains((state = (world = player.field_70170_p).func_180495_p(pos)).func_185904_a()) || stack.func_150997_a(state) > 1.0f) && !world.func_175623_d(pos)) {
            boolean thor = !ItemThorRing.getThorRing((PlayerEntity)player).func_190926_b();
            boolean doX = thor || side.func_82601_c() == 0;
            boolean doY = thor || side.func_96559_d() == 0;
            boolean doZ = thor || side.func_82599_e() == 0;
            int origLevel = AlfsteelPick.getLevel((ItemStack)stack);
            int level = origLevel + (thor ? 1 : 0);
            int rangeDepth = level / 2;
            if (ItemTemperanceStone.hasTemperanceActive((PlayerEntity)player) && level > 2) {
                level = 2;
                rangeDepth = 0;
            }
            int range = level - 1;
            int rangeY = Math.max(1, range);
            if (range != 0 || level == 1) {
                Vector3i beginDiff = new Vector3i(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
                Vector3i endDiff = new Vector3i(doX ? range : rangeDepth * -side.func_82601_c(), doY ? rangeY * 2 - 1 : 0, doZ ? range : rangeDepth * -side.func_82599_e());
                ToolCommons.removeBlocksInIteration((PlayerEntity)player, (ItemStack)stack, (World)world, (BlockPos)pos, (Vector3i)beginDiff, (Vector3i)endDiff, s -> MATERIALS.contains(s.func_185904_a()) || stack.func_150997_a(s) > 1.0f);
                if (origLevel == 5) {
                    PlayerHelper.grantCriterion((ServerPlayerEntity)((ServerPlayerEntity)player), (ResourceLocation)ResourceLocationHelper.prefix((String)"challenge/rank_ss_pick"), (String)"code_triggered");
                }
            }
        }
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return repair.func_77973_b() == ModItems.alfsteelIngot || !Ingredient.func_199805_a((ITag)ModTags.Items.INGOTS_TERRASTEEL).test(repair) && super.func_82789_a(toRepair, repair);
    }

    @Override
    public boolean canRepairPylon(ItemStack stack) {
        return stack.func_77952_i() > 0;
    }

    @Override
    public int getRepairManaPerTick(ItemStack stack) {
        return 500;
    }

    @Override
    public ItemStack repairOneTick(ItemStack stack) {
        stack.func_196085_b(Math.max(0, stack.func_77952_i() - 5));
        return stack;
    }

    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return !otherStack.func_77973_b().func_206844_a((ITag)ModTags.Items.TERRA_PICK_BLACKLIST);
    }

    public boolean disposeOfTrashBlocks(ItemStack stack) {
        return AlfsteelPick.isTipped((ItemStack)stack);
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }
}

