/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.noeppi_noeppi.libx.world.WorldSeedHolder;
import java.util.function.LongFunction;
import javax.annotation.Nonnull;
import mythicbotany.alfheim.AlfheimBiomeLayer;
import mythicbotany.alfheim.AlfheimBiomeManager;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.RareBiomeLayer;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.ZoomLayer;

public class AlfheimBiomeProvider
extends BiomeProvider {
    public static final Codec<AlfheimBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").orElseGet(WorldSeedHolder::getSeed).forGetter(provider -> provider.seed), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(provider -> provider.biomeRegistry)).apply((Applicative)instance, instance.stable(AlfheimBiomeProvider::new)));
    private final Layer genBiomes;
    public final long seed;
    public final Registry<Biome> biomeRegistry;

    public AlfheimBiomeProvider(long seed, Registry<Biome> biomeRegistry) {
        super(AlfheimBiomeManager.allBiomes().map(biomeId -> () -> (Biome)biomeRegistry.func_243576_d(biomeId)));
        this.seed = seed;
        this.biomeRegistry = biomeRegistry;
        IAreaFactory areaFactory = AlfheimBiomeProvider.createAreaFactory(biomeRegistry, seedModifier -> new LazyAreaLayerContext(25, seed, seedModifier), seed);
        this.genBiomes = new Layer(areaFactory);
    }

    @Nonnull
    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    @Nonnull
    public BiomeProvider func_230320_a_(long seed) {
        return new AlfheimBiomeProvider(seed, this.biomeRegistry);
    }

    @Nonnull
    public Biome func_225526_b_(int x, int y, int z) {
        return this.genBiomes.func_242936_a(this.biomeRegistry, x, z);
    }

    private static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> createAreaFactory(Registry<Biome> biomeRegistry, LongFunction<C> noiseRandom, long seed) {
        long modified = seed * (seed / 2L);
        IAreaFactory factory = new AlfheimBiomeLayer(biomeRegistry).func_202823_a((IExtendedNoiseRandom)noiseRandom.apply((modified >> 16 & 0xCCDACADDABABL) + (long)"MythicBotany".hashCode()));
        factory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)noiseRandom.apply((modified >> 13 & 0xACEDCECADADBL) + (long)"Botania".hashCode()), factory);
        factory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)noiseRandom.apply((modified >> 27 & 0xABBBCECBACAAL) + (long)"noeppi_noeppi".hashCode()), factory);
        factory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)noiseRandom.apply((modified & 0xBAEADCADBEEBL) + (long)"MelanX".hashCode()), factory);
        factory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)noiseRandom.apply((modified >> 45 & 0xDDEBCCEBCDABL) + (long)"Alfheim".hashCode()), factory);
        factory = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)noiseRandom.apply((modified >> 6 & 0xAACBCADDEACEL) + (long)"skateIEH".hashCode()), factory);
        factory = RareBiomeLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)noiseRandom.apply((modified >> 51 & 0xECEBBABAABDBL) + (long)"Minecraft".hashCode()), factory);
        factory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)noiseRandom.apply((modified >> 36 & 0xEAADADEDBBDBL) + (long)"NorseMythology".hashCode()), factory);
        return factory;
    }
}

