/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.energy.IEnergyStorage;
import owmii.lib.client.util.Text;
import owmii.lib.client.wiki.page.panel.InfoBox;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.item.IEnergyItemProvider;
import owmii.lib.item.VarItem;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.util.Util;

public abstract class EnergyItem<V extends Enum<V>, C extends IEnergyConfig<V>, I extends EnergyItem<V, C, I>>
extends VarItem<V, I>
implements InfoBox.IInfoBoxHolder,
IEnergyItemProvider {
    public EnergyItem(Item.Properties properties, V variant) {
        super(properties, variant);
    }

    public EnergyItem(Item.Properties properties) {
        super(properties);
    }

    public abstract IEnergyConfig<V> getConfig();

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        IEnergyConfig config = this.getConfig();
        return new Energy.Item.Provider(stack, config.getCapacity(this.getVariant()), config.getTransfer(this.getVariant()), config.getTransfer(this.getVariant()));
    }

    @Override
    public boolean isChargeable(ItemStack stack) {
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Energy.ifPresent(stack, (NonNullConsumer<? super IEnergyStorage>)((NonNullConsumer)storage -> {
            Energy.Item energy;
            if (storage instanceof Energy.Item && (energy = (Energy.Item)storage).getCapacity() > 0L) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.lollipop.stored").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.fe.stored", new Object[]{Util.addCommas(energy.getStored()), Util.numFormat(energy.getCapacity())}).func_240699_a_(TextFormatting.DARK_GRAY)));
                tooltip.add((ITextComponent)new TranslationTextComponent("info.lollipop.max.io").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick", new Object[]{Util.numFormat(energy.getMaxExtract())}).func_240699_a_(TextFormatting.DARK_GRAY)));
                tooltip.add((ITextComponent)new StringTextComponent(""));
            }
        }));
    }

    @Override
    public InfoBox getInfoBox(ItemStack stack, InfoBox box) {
        Energy.ifPresent(stack, (NonNullConsumer<? super IEnergyStorage>)((NonNullConsumer)storage -> {
            if (storage instanceof Energy.Item) {
                Energy.Item energy = (Energy.Item)storage;
                box.set((TextComponent)new TranslationTextComponent("info.lollipop.capacity"), (TextComponent)new TranslationTextComponent("info.lollipop.fe", new Object[]{Util.addCommas(energy.getCapacity())}));
                box.set((TextComponent)new TranslationTextComponent("info.lollipop.max.io"), (TextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick", new Object[]{Util.addCommas(energy.getMaxExtract())}));
            }
        }));
        return box;
    }
}

