/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.block;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import owmii.lib.block.AbstractBlock;
import owmii.lib.block.IBlockEntity;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.block.ITankHolder;
import owmii.lib.logistics.IRedstoneInteract;
import owmii.lib.logistics.Redstone;
import owmii.lib.logistics.fluid.Tank;
import owmii.lib.logistics.inventory.Inventory;
import owmii.lib.registry.IVariant;
import owmii.lib.util.Stack;

public class AbstractTileEntity<V extends IVariant, B extends AbstractBlock<V, B>>
extends TileEntity
implements IBlockEntity,
IRedstoneInteract {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    @CapabilityInject(value=IFluidHandler.class)
    public static Capability<IFluidHandler> FLUID_HANDLER_CAPABILITY = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    protected final Inventory inv = Inventory.createBlank();
    private final LazyOptional<Inventory> invHolder = LazyOptional.of(() -> this.inv);
    protected final Tank tank = new Tank(0);
    private final LazyOptional<FluidTank> tankHolder = LazyOptional.of(() -> this.tank);
    protected V variant;
    protected boolean isContainerOpen;
    private Redstone redstone = Redstone.IGNORE;

    public AbstractTileEntity(TileEntityType<?> type) {
        this(type, IVariant.getEmpty());
        this.tank.validate(stack -> true);
    }

    public AbstractTileEntity(TileEntityType<?> type, V variant) {
        super(type);
        this.variant = variant;
        if (this instanceof IInventoryHolder) {
            this.inv.setTile((IInventoryHolder)((Object)this));
        }
    }

    public B getBlock() {
        return (B)((AbstractBlock)this.func_195044_w().func_177230_c());
    }

    public V getVariant() {
        return this.variant;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.readSync(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        return this.writeSync(nbt);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 3, this.writeSync(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readSync(pkt.func_148857_g());
    }

    protected void readSync(CompoundNBT nbt) {
        if (!this.variant.isEmpty() && nbt.func_150297_b("variant", 3)) {
            this.variant = (IVariant)this.variant.read(nbt, "variant");
        }
        if (this instanceof IInventoryHolder && !this.keepInventory()) {
            this.inv.deserializeNBT(nbt);
        }
        if (this instanceof ITankHolder && !((ITankHolder)((Object)this)).keepFluid()) {
            this.tank.readFromNBT(nbt);
        }
        this.redstone = Redstone.values()[nbt.func_74762_e("redstone_mode")];
        this.readStorable(nbt);
    }

    protected CompoundNBT writeSync(CompoundNBT nbt) {
        if (!this.variant.isEmpty()) {
            this.variant.write(nbt, (Enum)((Enum)this.variant), "variant");
        }
        if (this instanceof IInventoryHolder && !this.keepInventory()) {
            nbt.func_197643_a(this.inv.serializeNBT());
        }
        if (this instanceof ITankHolder && !((ITankHolder)((Object)this)).keepFluid()) {
            this.tank.writeToNBT(nbt);
        }
        nbt.func_74768_a("redstone_mode", this.redstone.ordinal());
        return this.writeStorable(nbt);
    }

    public void readStorable(CompoundNBT nbt) {
        if (this instanceof IInventoryHolder && this.keepInventory()) {
            this.inv.deserializeNBT(nbt);
        }
        if (this instanceof ITankHolder && ((ITankHolder)((Object)this)).keepFluid()) {
            this.tank.readFromNBT(nbt);
        }
    }

    public CompoundNBT writeStorable(CompoundNBT nbt) {
        if (this instanceof IInventoryHolder && this.keepInventory()) {
            nbt.func_197643_a(this.inv.serializeNBT());
        }
        if (this instanceof ITankHolder && ((ITankHolder)((Object)this)).keepFluid()) {
            this.tank.writeToNBT(nbt);
        }
        return nbt;
    }

    @Override
    public void onPlaced(World world, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        CompoundNBT tag = Stack.getTagOrEmpty(stack);
        if (!tag.isEmpty()) {
            this.readStorable(tag.func_74775_l("lollipoptile_stack_nbt"));
        }
    }

    @Override
    public void onRemoved(World world, BlockState state, BlockState newState, boolean isMoving) {
        if (!(state.func_177230_c() == newState.func_177230_c() || !(this instanceof IInventoryHolder) || this.keepInventory() && this.keepStorable())) {
            this.getInventory().drop(world, this.field_174879_c);
        }
    }

    public ItemStack storeToStack(ItemStack stack) {
        CompoundNBT nbt = this.writeStorable(new CompoundNBT());
        CompoundNBT nbt1 = Stack.getTagOrEmpty(stack);
        if (!nbt.isEmpty() && this.keepStorable()) {
            nbt1.func_218657_a("lollipoptile_stack_nbt", (INBT)nbt);
            stack.func_77982_d(nbt1);
        }
        return stack;
    }

    public static <T extends AbstractTileEntity> T fromStack(ItemStack stack, T tile) {
        CompoundNBT nbt = stack.func_179543_a("lollipoptile_stack_nbt");
        if (nbt != null) {
            tile.readStorable(nbt);
        }
        return tile;
    }

    public boolean keepStorable() {
        return true;
    }

    protected boolean keepInventory() {
        return false;
    }

    public Tank getTank() {
        return this.tank;
    }

    @Override
    public Redstone getRedstoneMode() {
        return this.redstone;
    }

    @Override
    public void setRedstoneMode(Redstone mode) {
        this.redstone = mode;
    }

    public boolean checkRedstone() {
        boolean power = this.field_145850_b != null && this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        return Redstone.IGNORE.equals((Object)this.getRedstoneMode()) || power && Redstone.ON.equals((Object)this.getRedstoneMode()) || !power && Redstone.OFF.equals((Object)this.getRedstoneMode());
    }

    public void sync() {
        if (this.field_145850_b instanceof ServerWorld) {
            BlockState state = this.func_195044_w();
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public boolean isRemote() {
        return this.field_145850_b != null && this.field_145850_b.field_72995_K;
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.invHolder.invalidate();
        this.tankHolder.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ITEM_HANDLER_CAPABILITY && this instanceof IInventoryHolder && !this.inv.isBlank()) {
            return this.invHolder.cast();
        }
        if (cap == FLUID_HANDLER_CAPABILITY && this instanceof ITankHolder) {
            return this.tankHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    public void setContainerOpen(boolean value) {
        boolean b = this.isContainerOpen;
        this.isContainerOpen = value;
        if (b != value) {
            this.sync();
        }
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

