/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.block;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import owmii.lib.block.AbstractEnergyBlock;
import owmii.lib.block.AbstractTickableTile;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.logistics.IRedstoneInteract;
import owmii.lib.logistics.SidedStorage;
import owmii.lib.logistics.Transfer;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.logistics.energy.SideConfig;
import owmii.lib.registry.IVariant;
import owmii.lib.util.Util;

public class AbstractEnergyStorage<V extends Enum<V>, C extends IEnergyConfig<V>, B extends AbstractEnergyBlock<V, C, B>>
extends AbstractTickableTile<V, B>
implements IRedstoneInteract {
    @CapabilityInject(value=IEnergyStorage.class)
    public static Capability<IEnergyStorage> ENERGY_CAPABILITY = CapabilityEnergy.ENERGY;
    protected final SideConfig sideConfig = new SideConfig(this);
    protected final Energy energy = Energy.create(0L);
    private final SidedStorage<LazyOptional<IEnergyStorage>> energyProxies = SidedStorage.create(this::createEnergyProxy);

    public AbstractEnergyStorage(TileEntityType<?> type) {
        this(type, (Enum)IVariant.getEmpty());
    }

    public AbstractEnergyStorage(TileEntityType<?> type, V variant) {
        super(type, (IVariant)variant);
    }

    private LazyOptional<IEnergyStorage> createEnergyProxy(final @Nullable Direction side) {
        return LazyOptional.of(() -> new IEnergyStorage(){

            public int extractEnergy(int maxExtract, boolean simulate) {
                return Util.safeInt(AbstractEnergyStorage.this.extractEnergy(maxExtract, simulate, side));
            }

            public int getEnergyStored() {
                return Util.safeInt(AbstractEnergyStorage.this.getEnergy().getStored());
            }

            public int getMaxEnergyStored() {
                return AbstractEnergyStorage.this.getEnergy().getMaxEnergyStored();
            }

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return Util.safeInt(AbstractEnergyStorage.this.receiveEnergy(maxReceive, simulate, side));
            }

            public boolean canReceive() {
                return AbstractEnergyStorage.this.canReceiveEnergy(side);
            }

            public boolean canExtract() {
                return AbstractEnergyStorage.this.canExtractEnergy(side);
            }
        });
    }

    @Override
    public void readSync(CompoundNBT nbt) {
        this.sideConfig.read(nbt);
        if (!this.keepEnergy()) {
            this.energy.read(nbt, true, false);
        }
        super.readSync(nbt);
    }

    @Override
    public CompoundNBT writeSync(CompoundNBT nbt) {
        this.sideConfig.write(nbt);
        if (!this.keepEnergy()) {
            this.energy.write(nbt, true, false);
        }
        return super.writeSync(nbt);
    }

    @Override
    public void readStorable(CompoundNBT nbt) {
        if (this.keepEnergy()) {
            this.energy.read(nbt, false, false);
        }
        super.readStorable(nbt);
    }

    @Override
    public CompoundNBT writeStorable(CompoundNBT nbt) {
        if (this.keepEnergy()) {
            this.energy.write(nbt, false, false);
        }
        return super.writeStorable(nbt);
    }

    @Override
    protected void invalidateCaps() {
        super.invalidateCaps();
        this.energyProxies.stream().forEach(LazyOptional::invalidate);
    }

    public boolean keepEnergy() {
        return false;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ENERGY_CAPABILITY && this.isEnergyPresent(side)) {
            return this.energyProxies.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void onFirstTick(World world) {
        super.onFirstTick(world);
        this.energy.setCapacity(this.getEnergyCapacity());
        this.energy.setTransfer(this.getEnergyTransfer());
        this.getSideConfig().init();
        this.sync();
    }

    protected long extractFromSides(World world) {
        long extracted = 0L;
        if (!this.isRemote()) {
            for (Direction side : Direction.values()) {
                if (!this.canExtractEnergy(side)) continue;
                long amount = Math.min(this.getEnergyTransfer(), this.getEnergy().getStored());
                long toExtract = Energy.receive(world.func_175625_s(this.field_174879_c.func_177967_a(side, this.getExtractSidesOffsets()[side.ordinal()])), side, Util.safeInt(amount), false);
                extracted += this.extractEnergy(Util.safeInt(toExtract), false, side);
            }
        }
        return extracted;
    }

    protected int[] getExtractSidesOffsets() {
        return new int[]{1, 1, 1, 1, 1, 1};
    }

    protected long chargeItems(int i) {
        return this.chargeItems(0, i);
    }

    protected long chargeItems(int i, int j) {
        long extracted = 0L;
        if (!this.isRemote()) {
            for (ItemStack stack : this.getChargingInv(i, j)) {
                extracted += this.chargeItem(stack, this.getEnergyTransfer());
            }
        }
        return extracted;
    }

    public List<ItemStack> getChargingInv(int i, int j) {
        return IntStream.range(i, j).mapToObj(value -> (ItemStack)this.inv.getStacks().get(value)).collect(Collectors.toList());
    }

    protected long chargeItem(ItemStack stack, long transfer) {
        if (!stack.func_190926_b()) {
            long amount = Math.min(transfer, this.getEnergy().getStored());
            int received = Energy.receive(stack, amount, false);
            return this.extractEnergy(received, false, null);
        }
        return 0L;
    }

    protected long extractEnergy(int maxExtract, boolean simulate, @Nullable Direction side) {
        if (!this.canExtractEnergy(side)) {
            return 0L;
        }
        Energy energy = this.getEnergy();
        long extracted = Math.min(energy.getStored(), Math.min(energy.getMaxExtract(), (long)maxExtract));
        if (!simulate && extracted > 0L) {
            energy.consume(extracted);
            this.sync(10);
        }
        return extracted;
    }

    protected long receiveEnergy(int maxReceive, boolean simulate, @Nullable Direction side) {
        if (!this.canReceiveEnergy(side)) {
            return 0L;
        }
        Energy energy = this.getEnergy();
        long received = Math.min(energy.getEmpty(), Math.min(energy.getMaxReceive(), (long)maxReceive));
        if (!simulate && received > 0L) {
            energy.produce(received);
            this.sync(10);
        }
        return received;
    }

    public boolean canExtractEnergy(@Nullable Direction side) {
        return side == null || this.isEnergyPresent(side) && this.sideConfig.getType((Direction)side).canExtract;
    }

    public boolean canReceiveEnergy(@Nullable Direction side) {
        return side == null || this.isEnergyPresent(side) && this.sideConfig.getType((Direction)side).canReceive;
    }

    public boolean isEnergyPresent(@Nullable Direction side) {
        return true;
    }

    @Override
    public void onAdded(World world, BlockState state, BlockState oldState, boolean isMoving) {
        super.onAdded(world, state, oldState, isMoving);
        if (state.func_177230_c() != oldState.func_177230_c()) {
            this.getSideConfig().init();
        }
    }

    protected long getEnergyCapacity() {
        return this.getConfig().getCapacity((Enum)((Enum)this.getVariant()));
    }

    protected long getEnergyTransfer() {
        return this.getConfig().getTransfer((Enum)((Enum)this.getVariant()));
    }

    protected C getConfig() {
        return (C)((IEnergyConfig)((AbstractEnergyBlock)this.getBlock()).getConfig());
    }

    public Energy getEnergy() {
        return this.energy;
    }

    public Transfer getTransferType() {
        return Transfer.ALL;
    }

    public SideConfig getSideConfig() {
        return this.sideConfig;
    }
}

